/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.admin.param.DatacenterParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyPrinter;

@Entity
public class TopologyCandidate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NO_NAME = "none";
    @PrimaryKey
    private String candidateName;
    private Topology topology;
    private Map<RepNodeId, String> mountPointAssignments;
    private Map<DatacenterId, Integer> maxShards;
    private DatacenterId smallestDC;
    private List<String> auditTrail;

    private TopologyCandidate() {
    }

    public TopologyCandidate(String name, Topology topoCopy) {
        this.candidateName = name;
        this.topology = topoCopy;
        this.mountPointAssignments = new HashMap<RepNodeId, String>();
        this.maxShards = new HashMap<DatacenterId, Integer>();
        this.auditTrail = new ArrayList<String>();
        this.log("starting number of shards: " + topoCopy.getRepGroupMap().size());
        this.log("number of partitions: " + topoCopy.getPartitionMap().size());
    }

    public Topology getTopology() {
        return this.topology;
    }

    public void resetTopology(Topology topo) {
        this.topology = topo;
    }

    public String getName() {
        return this.candidateName;
    }

    public void setShardsPerDC(DatacenterId dcId, int numShards) {
        this.maxShards.put(dcId, numShards);
    }

    public void setSmallestDC(DatacenterId dcId) {
        this.smallestDC = dcId;
    }

    String getSmallestDCName(Parameters params) {
        if (this.smallestDC != null) {
            return this.smallestDC + "/" + params.get(this.smallestDC).getName();
        }
        return null;
    }

    public String display() {
        StringBuilder sb = new StringBuilder();
        sb.append("name= ").append(this.candidateName);
        sb.append("\nzones= ").append(this.getDatacenters());
        sb.append("\n");
        sb.append(TopologyPrinter.printTopology(this, null, false));
        return sb.toString();
    }

    public Set<DatacenterId> getDatacenters() {
        HashSet<DatacenterId> dcIds = new HashSet<DatacenterId>();
        for (Datacenter dc : this.topology.getDatacenterMap().getAll()) {
            dcIds.add((DatacenterId)dc.getResourceId());
        }
        return dcIds;
    }

    public String showDatacenters(Parameters params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<DatacenterId, Integer> entry : this.maxShards.entrySet()) {
            DatacenterId dcId = entry.getKey();
            DatacenterParams dcp = params.get(dcId);
            sb.append(dcId).append("/").append(dcp.getName());
            sb.append(" maximum shards= ").append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String showAudit() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Audit]\n");
        for (String s : this.auditTrail) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public void log(String s) {
        this.auditTrail.add(s);
    }

    public void saveMountPoint(RepNodeId rnId, String mountPoint) {
        this.mountPointAssignments.put(rnId, mountPoint);
    }

    public String getMountPoint(RepNodeId rnId) {
        return this.mountPointAssignments.get(rnId);
    }

    public Map<RepNodeId, String> getAllMountPoints() {
        return this.mountPointAssignments;
    }
}

