/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class WriteNewParams
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private ParameterMap newParams;
    private StorageNodeId targetSNId;
    private RepNodeId rnid;
    private boolean continuePastError;

    public WriteNewParams(AbstractPlan plan, ParameterMap newParams, RepNodeId rnid, StorageNodeId targetSNId, boolean continuePastError) {
        this.plan = plan;
        this.newParams = newParams;
        this.rnid = rnid;
        this.targetSNId = targetSNId;
        this.continuePastError = continuePastError;
    }

    private WriteNewParams() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        RepNodeParams rnp = admin.getRepNodeParams(this.rnid);
        ParameterMap rnMap = rnp.getMap();
        RepNodeParams newRnp = new RepNodeParams(this.newParams);
        newRnp.setRepNodeId(this.rnid);
        ParameterMap diff = rnMap.diff(this.newParams, true);
        this.plan.getLogger().info("Changing params for " + this.rnid + ": " + diff);
        rnMap.merge(this.newParams, true);
        admin.updateParams(rnp);
        Topology topology = admin.getCurrentTopology();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(this.targetSNId);
        sna.newRepNodeParameters(rnMap);
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return this.continuePastError;
    }

    @Override
    public String toString() {
        return super.toString() + " write new " + this.rnid + " parameters into the Admin database: " + this.newParams.showContents();
    }
}

