/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.logging.Level;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.metadata.Metadata;

@Persistent
public class UpdateMetadata<T extends Metadata<?>>
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    protected MetadataPlan<T> plan;

    public UpdateMetadata(MetadataPlan<T> plan) {
        this.plan = plan;
    }

    protected UpdateMetadata() {
    }

    protected T updateMetadata() {
        return this.plan.getMetadata();
    }

    @Override
    public Task.State doWork() throws Exception {
        T md = this.updateMetadata();
        if (md == null) {
            return Task.State.SUCCEEDED;
        }
        this.plan.getLogger().log(Level.INFO, "About to broadcast {0}", md);
        Admin admin = this.plan.getAdmin();
        if (!Utils.broadcastMetadataChangesToRNs(this.plan.getLogger(), md, admin.getCurrentTopology(), this.toString(), admin.getParams().getAdminParams(), this.plan)) {
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return true;
    }

    @Override
    public boolean logicalCompare(Task t) {
        return true;
    }
}

