/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.admin.plan.task.Task;

@Persistent
public class TaskList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExecutionStrategy strategy;
    private ArrayList<Task> taskList;

    public TaskList(ExecutionStrategy execOrder) {
        this.taskList = new ArrayList();
        this.strategy = execOrder;
    }

    private TaskList() {
    }

    public void add(Task t) {
        this.taskList.add(t);
    }

    public List<Task> getTasks() {
        return (List)this.taskList.clone();
    }

    public int getTotalTaskCount() {
        int count = 0;
        for (Task t : this.taskList) {
            count += t.getTotalTaskCount();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.taskList.isEmpty();
    }

    public ExecutionStrategy getStrategy() {
        return this.strategy;
    }

    public static enum ExecutionStrategy {
        PARALLEL,
        SERIAL;

    }
}

