/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Set;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.ChangeAdminParamsPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class StartAdmin
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private ChangeAdminParamsPlan plan;
    private StorageNodeId snId;
    private AdminId adminId;
    private boolean continuePastError;

    public StartAdmin(ChangeAdminParamsPlan plan, StorageNodeId storageNodeId, AdminId adminId, boolean continuePastError) {
        this.plan = plan;
        this.snId = storageNodeId;
        this.adminId = adminId;
        this.continuePastError = continuePastError;
    }

    protected StartAdmin() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Set<AdminId> needsAction = this.plan.getNeedsActionSet();
        if (needsAction.contains(this.adminId)) {
            StartAdmin.start(this.plan, this.adminId, this.snId);
        }
        return Task.State.SUCCEEDED;
    }

    static void start(AbstractPlan plan, AdminId adminId, StorageNodeId snId) throws RemoteException, NotBoundException {
        Admin admin = plan.getAdmin();
        Parameters parameters = admin.getCurrentParameters();
        AdminParams ap = parameters.get(adminId);
        ap.setDisabled(false);
        admin.updateParams(ap);
        StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(parameters, snId, plan.getLoginManager());
        sna.startAdmin();
    }

    @Override
    public boolean continuePastError() {
        return this.continuePastError;
    }

    @Override
    public String toString() {
        return super.toString() + " start " + this.adminId;
    }
}

