/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class RemoveTable
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private boolean markForDelete;

    public RemoveTable(MetadataPlan<TableMetadata> plan, String tableName, boolean markForDelete) {
        super(plan);
        this.tableName = tableName;
        this.markForDelete = markForDelete;
        TableMetadata md = plan.getMetadata();
        if (md != null) {
            md.checkForRemove(tableName, true);
            return;
        }
        throw new IllegalCommandException("Table does not exist: " + tableName);
    }

    private RemoveTable() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        TableImpl table = md.getTable(this.tableName);
        if (table != null) {
            md.dropTable(this.tableName, this.markForDelete);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public String toString() {
        return TablePlanGenerator.makeName("RemoveTable", this.tableName, null);
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        RemoveTable other = (RemoveTable)t;
        return this.tableName.equalsIgnoreCase(other.tableName) && this.markForDelete == other.markForDelete;
    }
}

