/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.KVBuiltInRoleResolver;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class RemoveRole
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private final String roleName;

    public RemoveRole(SecurityMetadataPlan plan, String roleName) {
        super(plan);
        if (KVBuiltInRoleResolver.resolveRole(roleName) != null) {
            throw new IllegalCommandException("Cannot drop a system built-in role");
        }
        this.roleName = roleName;
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd != null && secMd.getRole(this.roleName) != null) {
            secMd.removeRole(secMd.getRole(this.roleName).getElementId());
            this.plan.getAdmin().saveMetadata(secMd, this.plan);
            return secMd;
        }
        return null;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        RemoveRole other = (RemoveRole)t;
        return this.roleName.equalsIgnoreCase(other.roleName);
    }
}

