/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.TopologyCheckUtils;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.PortTracker;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;

@Persistent(version=1)
public class RelocateRN
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private static final int WAIT_FOR_CONSISTENCY_DELAY_MS = 60000;
    private static final int WAIT_FOR_CONSISTENCY = 60;
    private RepNodeId rnId;
    private StorageNodeId oldSN;
    private StorageNodeId newSN;
    private String newMountPoint;
    private AbstractPlan plan;
    public static TestHook<Integer> FAULT_HOOK;

    public RelocateRN(AbstractPlan plan, StorageNodeId oldSN, StorageNodeId newSN, RepNodeId rnId, String newMountPoint) {
        this.oldSN = oldSN;
        this.newSN = newSN;
        this.plan = plan;
        this.rnId = rnId;
        this.newMountPoint = newMountPoint;
        if (oldSN.equals(newSN)) {
            throw new NonfatalAssertionException("The RelocateRN task does not support relocating to the same Storage Node");
        }
    }

    private RelocateRN() {
    }

    private boolean checkAndRepairLocation() throws RemoteException, NotBoundException {
        Admin admin = this.plan.getAdmin();
        Logger logger = this.plan.getLogger();
        TopologyCheck checker = new TopologyCheck(logger, admin.getCurrentTopology(), admin.getCurrentParameters());
        TopologyCheck.Remedy remedy = checker.checkRNLocation(admin, this.newSN, this.rnId, false, true);
        if (remedy.getType() != TopologyCheck.REMEDY_TYPE.OKAY) {
            logger.info("RelocateRN check of newSN: " + remedy);
        }
        boolean newDone = checker.applyRemedy(remedy, this.plan, this.plan.getDeployedInfo(), this.oldSN, this.newMountPoint);
        remedy = checker.checkRNLocation(admin, this.oldSN, this.rnId, false, true);
        if (remedy.getType() != TopologyCheck.REMEDY_TYPE.OKAY) {
            logger.info("RelocateRN check of oldSN: " + remedy);
        }
        boolean oldDone = checker.applyRemedy(remedy, this.plan, this.plan.getDeployedInfo(), this.oldSN, this.newMountPoint);
        return newDone && oldDone;
    }

    @Override
    public Task.State doWork() throws Exception {
        long stopRNTime;
        Admin admin = this.plan.getAdmin();
        Logger logger = this.plan.getLogger();
        this.checkVersions();
        boolean done = this.checkAndRepairLocation();
        Topology current = admin.getCurrentTopology();
        RepNode rn = current.get(this.rnId);
        if (done && rn.getStorageNodeId().equals(this.newSN)) {
            logger.info(this.rnId + " is already on " + this.newSN + ", no additional metadata changes needed.");
            stopRNTime = System.currentTimeMillis();
        } else {
            LoginManager loginMgr = admin.getLoginManager();
            Utils.confirmSNStatus(current, loginMgr, this.oldSN, true, "Please ensure that " + this.oldSN + " is deployed and running before " + "attempting a relocate " + this.rnId + ".");
            Utils.confirmSNStatus(current, loginMgr, this.newSN, true, "Please ensure that " + this.newSN + " is deployed and running before " + "attempting a relocate " + this.rnId + ".");
            RepGroupId rgId = current.get(this.rnId).getRepGroupId();
            Utils.verifyShardHealth(admin.getCurrentParameters(), current, this.rnId, this.oldSN, this.newSN, this.plan.getLogger());
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 1));
            Utils.stopRN(this.plan, this.oldSN, this.rnId);
            RepNodeParams rnp = admin.getRepNodeParams(this.rnId);
            if (!rnp.isDisabled()) {
                throw new IllegalStateException("Expected disabled bit to be set for " + this.rnId + ": " + rnp);
            }
            stopRNTime = System.currentTimeMillis();
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 2));
            this.changeParamsAndTopo(this.oldSN, this.newSN, rgId);
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 3));
            Utils.changeHAAddress(admin.getCurrentTopology(), admin.getCurrentParameters(), admin.getParams().getAdminParams(), this.rnId, this.oldSN, this.newSN, this.plan, logger);
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 4));
            Topology topo = admin.getCurrentTopology();
            if (!Utils.broadcastTopoChangesToRNs(logger, topo, "relocate " + this.rnId + " from " + this.oldSN + " to " + this.newSN, admin.getParams().getAdminParams(), this.plan)) {
                return Task.State.INTERRUPTED;
            }
            Utils.refreshParamsOnPeers(this.plan, this.rnId);
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 5));
            RelocateRN.startRN(this.plan, this.newSN, this.rnId);
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 6));
        }
        return this.destroyRepNode(stopRNTime);
    }

    private void checkVersions() {
        Admin admin = this.plan.getAdmin();
        RegistryUtils regUtils = new RegistryUtils(admin.getCurrentTopology(), admin.getLoginManager());
        String errorMsg = " cannot be contacted. Please ensure that it is deployed and running before attempting to deploy this topology";
        KVVersion oldVersion = null;
        KVVersion newVersion = null;
        try {
            StorageNodeAgentAPI oldSNA = regUtils.getStorageNodeAgent(this.oldSN);
            oldVersion = oldSNA.ping().getKVVersion();
        }
        catch (RemoteException e) {
            throw new OperationFaultException(this.oldSN + errorMsg);
        }
        catch (NotBoundException e) {
            throw new OperationFaultException(this.oldSN + errorMsg);
        }
        try {
            StorageNodeAgentAPI newSNA = regUtils.getStorageNodeAgent(this.newSN);
            newVersion = newSNA.ping().getKVVersion();
        }
        catch (RemoteException e) {
            throw new OperationFaultException(this.newSN + errorMsg);
        }
        catch (NotBoundException e) {
            throw new OperationFaultException(this.newSN + errorMsg);
        }
        if (VersionUtil.compareMinorVersion(oldVersion, newVersion) > 0) {
            throw new OperationFaultException(this.rnId + " cannot be moved from " + this.oldSN + " to " + this.newSN + " because " + this.oldSN + " is at version " + oldVersion + " and " + this.newSN + " is at older version " + newVersion + ". Please upgrade " + this.newSN + " to a version that is equal or greater than " + oldVersion);
        }
    }

    private Task.State destroyRepNode(long stopRNTime) {
        try {
            if (RelocateRN.destroyRepNode(this.plan, stopRNTime, this.oldSN, this.rnId)) {
                return Task.State.SUCCEEDED;
            }
        }
        catch (InterruptedException ie) {
            return Task.State.INTERRUPTED;
        }
        throw new RuntimeException("Time out while waiting for " + this.rnId + " to come up on " + this.newSN + " and become consistent with" + " the master of the shard before deleting" + " the RepNode from its old home on " + this.oldSN);
    }

    public static boolean destroyRepNode(AbstractPlan plan, long stopRNTime, StorageNodeId targetSNId, RepNodeId targetRNId) throws InterruptedException {
        Admin admin = plan.getAdmin();
        Logger logger = plan.getLogger();
        long endCheckAtThisTime = System.currentTimeMillis() + (long)admin.getParams().getAdminParams().getAwaitRNConsistencyPeriod();
        Topology useTopo = admin.getCurrentTopology();
        RegistryUtils registry = new RegistryUtils(useTopo, admin.getLoginManager());
        do {
            logger.log(Level.INFO, "Waiting for {0} to become consistent before removing it from {1}. Topology says it is on {2}", new Object[]{targetRNId, targetSNId, useTopo.get(targetRNId).getStorageNodeId()});
            try {
                RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(targetRNId);
                if (rnAdmin.awaitConsistency(stopRNTime, 60, TimeUnit.SECONDS)) {
                    logger.log(Level.INFO, "Attempting to delete {0} from {1}", new Object[]{targetRNId, targetSNId});
                    StorageNodeAgentAPI oldSna = registry.getStorageNodeAgent(targetSNId);
                    oldSna.destroyRepNode(targetRNId, true);
                    return true;
                }
            }
            catch (RemoteException re) {
                logger.log(Level.INFO, "Remote call to {0} failed with {1}", new Object[]{targetRNId, re.getLocalizedMessage()});
                if (endCheckAtThisTime <= System.currentTimeMillis()) continue;
                Thread.sleep(60000L);
            }
            catch (NotBoundException nbe) {
                logger.log(Level.INFO, "Registry call failed with {0}", nbe.getLocalizedMessage());
                if (endCheckAtThisTime > System.currentTimeMillis()) {
                    Thread.sleep(60000L);
                }
                registry = new RegistryUtils(admin.getCurrentTopology(), admin.getLoginManager());
            }
        } while (endCheckAtThisTime > System.currentTimeMillis());
        return false;
    }

    public static void startRN(AbstractPlan plan, StorageNodeId targetSNId, RepNodeId targetRNId) throws RemoteException, NotBoundException {
        Admin admin = plan.getAdmin();
        Topology topo = admin.getCurrentTopology();
        RepNodeParams rnp = new RepNodeParams(admin.getRepNodeParams(targetRNId));
        if (rnp.isDisabled()) {
            rnp.setDisabled(false);
            admin.updateParams(rnp);
        }
        plan.getLogger().log(Level.INFO, "Starting up {0} on {1} with  {2}", new Object[]{targetRNId, targetSNId, rnp});
        RegistryUtils regUtils = new RegistryUtils(topo, admin.getLoginManager());
        StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(targetSNId);
        sna.createRepNode(rnp.getMap(), Utils.getMetadataSet(topo, plan));
        sna.newRepNodeParameters(rnp.getMap());
        StorageNode sn = topo.get(targetSNId);
        admin.getMonitor().registerAgent(sn.getHostname(), sn.getRegistryPort(), targetRNId);
    }

    private void changeParamsAndTopo(StorageNodeId before, StorageNodeId after, RepGroupId rgId) {
        Parameters parameters = this.plan.getAdmin().getCurrentParameters();
        Topology topo = this.plan.getAdmin().getCurrentTopology();
        PortTracker portTracker = new PortTracker(topo, parameters, after);
        StorageNodeId origParamsSN = parameters.get(this.rnId).getStorageNodeId();
        StorageNodeId origTopoSN = topo.get(this.rnId).getStorageNodeId();
        Set<RepNodeParams> changedRNParams = this.transferRNParams(parameters, portTracker, topo, before, after, rgId);
        boolean topoChanged = this.transferTopo(topo, before, after);
        if (changedRNParams.isEmpty() && topoChanged || !changedRNParams.isEmpty() && !topoChanged) {
            throw new IllegalStateException(this.rnId + " params and topo out of sync. Original params SN=" + origParamsSN + ", orignal topo SN=" + origTopoSN + " source SN=" + before + " destination SN=" + after);
        }
        Logger logger = this.plan.getLogger();
        if (!topoChanged || changedRNParams.isEmpty()) {
            logger.log(Level.INFO, "No change to params or topology, no need to update in order to move {0} from {1} to {2}", new Object[]{this.rnId, before, after});
            return;
        }
        this.plan.getAdmin().saveTopoAndParams(topo, this.plan.getDeployedInfo(), changedRNParams, Collections.<AdminParams>emptySet(), (Plan)this.plan);
        logger.log(Level.INFO, "Updating params and topo for move of {0} from {1} to {2}: {3}", new Object[]{this.rnId, before, after, changedRNParams});
    }

    private Set<RepNodeParams> transferRNParams(Parameters parameters, PortTracker portTracker, Topology topo, StorageNodeId before, StorageNodeId after, RepGroupId rgId) {
        HashSet<RepNodeParams> changed = new HashSet<RepNodeParams>();
        RepNodeParams rnp = parameters.get(this.rnId);
        ParameterMap policyMap = parameters.copyPolicies();
        if (rnp.getStorageNodeId().equals(after)) {
            this.plan.getLogger().info(this.rnId + " already transferred to " + after);
            return changed;
        }
        if (!rnp.getStorageNodeId().equals(before)) {
            throw new OperationFaultException("Attempted to transfer " + this.rnId + " from " + before + " to " + after + " but unexpectedly found it residing on " + rnp.getStorageNodeId());
        }
        int haPort = portTracker.getNextPort(after);
        String newSNHAHostname = parameters.get(after).getHAHostname();
        String oldNodeHostPort = rnp.getJENodeHostPort();
        String nodeHostPort = newSNHAHostname + ":" + haPort;
        this.plan.getLogger().log(Level.INFO, "transferring HA port for {0} from {1} to {2}", new Object[]{rnp.getRepNodeId(), oldNodeHostPort, nodeHostPort});
        rnp.setStorageNodeId(after);
        rnp.setJENodeHostPort(nodeHostPort);
        rnp.setMountPoint(this.newMountPoint);
        rnp.setJEHelperHosts(TopologyCheckUtils.findPeerRNHelpers(this.rnId, parameters, topo));
        StorageNodeParams snp = parameters.get(after);
        Utils.setRNPHeapCacheGC(policyMap, snp, rnp, topo);
        changed.add(rnp);
        for (RepNode peer : topo.get(rgId).getRepNodes()) {
            RepNodeId peerId = (RepNodeId)peer.getResourceId();
            if (peerId.equals(this.rnId)) continue;
            RepNodeParams peerParam = parameters.get(peerId);
            String oldHelper = peerParam.getJEHelperHosts();
            String newHelpers = oldHelper.replace(oldNodeHostPort, nodeHostPort);
            peerParam.setJEHelperHosts(newHelpers);
            changed.add(peerParam);
        }
        return changed;
    }

    private boolean transferTopo(Topology topo, StorageNodeId before, StorageNodeId after) {
        RepNode rn = topo.get(this.rnId);
        StorageNodeId inUseSNId = rn.getStorageNodeId();
        if (inUseSNId.equals(before)) {
            RepNode updatedRN = new RepNode(after);
            RepGroup rg = topo.get(rn.getRepGroupId());
            rg.update((RepNodeId)rn.getResourceId(), updatedRN);
            return true;
        }
        if (inUseSNId.equals(after)) {
            return false;
        }
        throw new IllegalStateException(rn + " expected to be on old SN " + before + " or new SN " + after + " but instead is on " + inUseSNId);
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public Runnable getCleanupJob() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    RelocateRN.this.cleanupRelocation();
                }
                catch (Exception e) {
                    RelocateRN.this.plan.getLogger().log(Level.SEVERE, "{0}: problem when cancelling relocation {1}", new Object[]{this, LoggerUtils.getStackTrace(e)});
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private void cleanupRelocation() throws RemoteException, NotBoundException {
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 7));
        boolean done = this.checkAndRepairLocation();
        Topology current = this.plan.getAdmin().getCurrentTopology();
        RepNode rn = current.get(this.rnId);
        if (done) {
            if (rn.getStorageNodeId().equals(this.newSN)) {
                this.plan.getLogger().info("In RelocateRN cleanup, shard is  consistent, " + this.rnId + " is on the target " + this.newSN);
                this.destroyRepNode(System.currentTimeMillis());
            }
            this.plan.getLogger().info("In RelocateRN cleanup, shard is consistent, " + this.rnId + " is on " + rn.getStorageNodeId());
        } else {
            this.plan.getLogger().info("In RelocateRN cleanup, shard did not have master, no cleanup attempted since authoritative information is lacking.");
        }
    }

    private boolean checkLocationConsistency() throws InterruptedException, RemoteException, NotBoundException {
        Admin admin = this.plan.getAdmin();
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 7));
        RepNodeParams rnp = admin.getRepNodeParams(this.rnId);
        if (rnp.getStorageNodeId().equals(this.newSN) && !rnp.isDisabled()) {
            return this.destroyRepNode(System.currentTimeMillis()) == Task.State.SUCCEEDED;
        }
        if (rnp.getStorageNodeId().equals(this.oldSN)) {
            if (rnp.isDisabled()) {
                Utils.startRN(this.plan, this.oldSN, this.rnId);
            }
            return true;
        }
        Topology topo = admin.getCurrentTopology();
        this.changeParamsAndTopo(this.newSN, this.oldSN, topo.get(this.rnId).getRepGroupId());
        Utils.refreshParamsOnPeers(this.plan, this.rnId);
        Utils.changeHAAddress(topo, admin.getCurrentParameters(), admin.getParams().getAdminParams(), this.rnId, this.newSN, this.oldSN, this.plan, this.plan.getLogger());
        topo = admin.getCurrentTopology();
        return Utils.broadcastTopoChangesToRNs(this.plan.getLogger(), topo, "revert relocation of  " + this.rnId + " and move back from " + this.newSN + " to " + this.oldSN, admin.getParams().getAdminParams(), this.plan);
    }

    @Override
    public String toString() {
        StorageNodeParams snpOld = this.plan.getAdmin() != null ? this.plan.getAdmin().getStorageNodeParams(this.oldSN) : null;
        StorageNodeParams snpNew = this.plan.getAdmin() != null ? this.plan.getAdmin().getStorageNodeParams(this.newSN) : null;
        return super.toString() + " move " + this.rnId + " from " + (snpOld != null ? snpOld.displaySNIdAndHost() : this.oldSN) + " to " + (snpNew != null ? snpNew.displaySNIdAndHost() : this.newSN);
    }

    @Override
    public void lockTopoComponents(Planner planner) throws PlanLocksHeldException {
        planner.lockShard(this.plan.getId(), this.plan.getName(), new RepGroupId(this.rnId.getGroupId()));
    }
}

