/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class NewRepNodeParameters
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private StorageNodeId hostSNId;
    private RepNodeId targetNodeId;
    private AbstractPlan plan;

    public NewRepNodeParameters() {
    }

    public NewRepNodeParameters(AbstractPlan plan, RepNodeId targetNodeId) {
        this.plan = plan;
        this.targetNodeId = targetNodeId;
    }

    @Override
    public Task.State doWork() throws Exception {
        this.plan.getLogger().log(Level.FINE, "Sending newParameters to {0}", this.targetNodeId);
        try {
            RegistryUtils registry = new RegistryUtils(this.plan.getAdmin().getCurrentTopology(), this.plan.getAdmin().getLoginManager());
            RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(this.targetNodeId);
            rnAdmin.newParameters();
        }
        catch (NotBoundException notbound) {
            this.plan.getLogger().info(this.targetNodeId + " cannot be contacted when updating its parameters: " + notbound);
            throw notbound;
        }
        catch (RemoteException e) {
            this.plan.getLogger().severe("Attempting to update parameters for targetNodeId:" + e);
            throw e;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        StorageNodeParams snp = this.plan.getAdmin() != null ? this.plan.getAdmin().getStorageNodeParams(this.hostSNId) : null;
        String retval = super.toString() + " cause " + this.targetNodeId;
        if (snp != null) {
            retval = retval + " on " + snp.displaySNIdAndHost();
        }
        return retval + " to refresh its parameter state without restarting";
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

