/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;

@Persistent
public class NewAdminGlobalParameters
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AdminId targetAdminId;
    private AbstractPlan plan;
    private String hostname;
    private int registryPort;

    private NewAdminGlobalParameters() {
    }

    public NewAdminGlobalParameters(AbstractPlan plan, String hostname, int registryPort, AdminId targetAdminId) {
        this.plan = plan;
        this.hostname = hostname;
        this.registryPort = registryPort;
        this.targetAdminId = targetAdminId;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public Task.State doWork() throws Exception {
        this.plan.getLogger().fine("Sending newGlobalParameters to Admin " + this.targetAdminId);
        CommandServiceAPI cs = ServiceUtils.waitForAdmin(this.hostname, this.registryPort, this.plan.getLoginManager(), 40L, ConfigurableService.ServiceStatus.RUNNING);
        cs.newGlobalParameters();
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + " cause Admin " + this.targetAdminId + " to refresh its global parameter state without restarting";
    }
}

