/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Set;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

@Persistent
public class GrantRoles
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String grantee;
    private Set<String> roles;

    public GrantRoles(SecurityMetadataPlan plan, String grantee, Set<String> roles) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.grantee = grantee;
        this.roles = roles;
        if (secMd == null || secMd.getUser(grantee) == null) {
            throw new IllegalCommandException("User with name " + grantee + " does not exist in store");
        }
    }

    private GrantRoles() {
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getUser(this.grantee) == null) {
            return null;
        }
        KVStoreUser newCopy = secMd.getUser(this.grantee).clone();
        secMd.updateUser(newCopy.getElementId(), newCopy.grantRoles(this.roles));
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        GrantRoles other = (GrantRoles)t;
        if (!this.grantee.equalsIgnoreCase(other.grantee)) {
            return false;
        }
        return this.roles.equals(other.roles);
    }
}

