/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.util.Set;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.PrivilegeTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class GrantPrivileges
extends PrivilegeTask {
    private static final long serialVersionUID = 1L;

    public GrantPrivileges(SecurityMetadataPlan.PrivilegePlan plan, String roleName, String tableName, Set<String> privNames) {
        super(plan, roleName, tableName, privNames);
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        if (secMd == null || secMd.getRole(this.roleName) == null) {
            return null;
        }
        RoleInstance roleCopy = secMd.getRole(this.roleName).clone();
        secMd.updateRole(roleCopy.getElementId(), roleCopy.grantPrivileges(this.privileges));
        this.plan.getAdmin().saveMetadata(secMd, this.plan);
        return secMd;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        GrantPrivileges other = (GrantPrivileges)t;
        if (!this.roleName.equalsIgnoreCase(other.roleName)) {
            return false;
        }
        return this.privileges.equals(other.privileges);
    }
}

