/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=0)
public class DestroyAdmin
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private StorageNodeId snid;
    private AdminId victim;

    public DestroyAdmin() {
    }

    public DestroyAdmin(AbstractPlan plan, StorageNodeId snid, AdminId victim) {
        this.plan = plan;
        this.snid = snid;
        this.victim = victim;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        Parameters parameters = admin.getCurrentParameters();
        StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(parameters, this.snid, this.plan.getLoginManager());
        sna.destroyAdmin(this.victim, true);
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " Destroy the Admin replica " + this.victim;
    }
}

