/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=0)
public class DeployMultipleRNs
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    protected AbstractPlan plan;
    protected StorageNodeId snId;
    protected String snDescriptor;

    public DeployMultipleRNs(AbstractPlan plan, StorageNodeId snId) {
        this.plan = plan;
        this.snId = snId;
        StorageNodeParams snp = plan.getAdmin().getStorageNodeParams(snId);
        this.snDescriptor = snp.displaySNIdAndHost();
    }

    DeployMultipleRNs() {
    }

    private Set<RepNodeId> getTargets() {
        Parameters parameters = this.plan.getAdmin().getCurrentParameters();
        HashSet<RepNodeId> targetSet = new HashSet<RepNodeId>();
        for (RepNodeParams rnp : parameters.getRepNodeParams()) {
            if (!rnp.getStorageNodeId().equals(this.snId)) continue;
            targetSet.add(rnp.getRepNodeId());
        }
        return targetSet;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        Topology topo = this.plan.getAdmin().getCurrentTopology();
        ParameterMap policyMap = this.plan.getAdmin().getCurrentParameters().copyPolicies();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils regUtils = new RegistryUtils(topo, loginMgr);
        StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(this.snId);
        StorageNodeParams snp = this.plan.getAdmin().getCurrentParameters().get(this.snId);
        int gcThreads = snp.calcGCThreads();
        Set<RepNodeId> targetRNIds = this.getTargets();
        int numRNsOnSN = targetRNIds.size();
        Set<Metadata<? extends MetadataInfo>> metadataSet = Utils.getMetadataSet(topo, this.plan);
        for (RepNodeId rnId : targetRNIds) {
            RepNodeParams rnp = admin.getRepNodeParams(rnId);
            StorageNodeParams.RNHeapAndCacheSize heapAndCache = snp.calculateRNHeapAndCache(policyMap, numRNsOnSN, rnp.getRNCachePercent());
            rnp.setRNHeapAndJECache(heapAndCache);
            rnp.setParallelGCThreads(gcThreads);
            sna.createRepNode(rnp.getMap(), metadataSet);
            StorageNode sn = topo.get(this.snId);
            admin.getMonitor().registerAgent(sn.getHostname(), sn.getRegistryPort(), rnId);
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public void lockTopoComponents(Planner planner) throws PlanLocksHeldException {
        Set<RepNodeId> targets = this.getTargets();
        HashSet<RepGroupId> shards = new HashSet<RepGroupId>();
        for (RepNodeId rnId : targets) {
            shards.add(new RepGroupId(rnId.getGroupId()));
        }
        for (RepGroupId rgId : shards) {
            planner.lockShard(this.plan.getId(), this.plan.getName(), rgId);
        }
    }
}

