/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class CheckRNMemorySettings
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    public static TestHook<Integer> FAULT_HOOK;
    private StorageNodeId snId;
    private DeployTopoPlan plan;

    public CheckRNMemorySettings(DeployTopoPlan plan, StorageNodeId snId) {
        this.snId = snId;
        this.plan = plan;
    }

    private CheckRNMemorySettings() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = this.plan.getAdmin();
        Topology topo = admin.getCurrentTopology();
        Parameters parameters = admin.getCurrentParameters();
        ParameterMap policyMap = parameters.copyPolicies();
        Logger logger = this.plan.getLogger();
        HashSet<RepNodeParams> changed = new HashSet<RepNodeParams>();
        HashSet<RepNodeId> needsRestart = new HashSet<RepNodeId>();
        HashSet<RepNodeId> needsNotification = new HashSet<RepNodeId>();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registry = new RegistryUtils(topo, loginMgr);
        StorageNodeAgentAPI sna = registry.getStorageNodeAgent(this.snId);
        Set<RepNodeId> rns = topo.getHostedRepNodeIds(this.snId);
        StorageNodeParams snp = parameters.get(this.snId);
        for (RepNodeId rnId : rns) {
            RepNodeParams rnp = parameters.get(rnId);
            StorageNodeParams.RNHeapAndCacheSize heapAndCache = snp.calculateRNHeapAndCache(policyMap, rns.size(), rnp.getRNCachePercent());
            long oldHeap = rnp.getMaxHeapMB();
            long oldCacheSize = rnp.getJECacheSize();
            rnp.setRNHeapAndJECache(heapAndCache);
            if (oldHeap != rnp.getMaxHeapMB()) {
                logger.info("Heap size for " + rnId + " has changed from " + oldHeap + "MB to " + rnp.getMaxHeapMB() + "MB");
                changed.add(rnp);
                needsRestart.add(rnId);
                continue;
            }
            if (oldCacheSize != rnp.getJECacheSize()) {
                logger.info("Cache size for " + rnId + " has changed from " + oldCacheSize + " to " + rnp.getJECacheSize());
                changed.add(rnp);
                needsNotification.add(rnId);
                continue;
            }
            RepNodeParams remoteRNP = this.readRemoteRepNodeParams(sna, rnId);
            long remoteHeap = remoteRNP.getMaxHeapMB();
            long remoteCacheSize = rnp.getJECacheSize();
            if (remoteHeap != rnp.getMaxHeapMB()) {
                logger.info("Heap size for " + rnId + " in " + this.snId + " has changed from " + remoteHeap + "MB to " + rnp.getMaxHeapMB() + "MB");
                changed.add(rnp);
                needsRestart.add(rnId);
                continue;
            }
            if (remoteCacheSize == rnp.getJECacheSize()) continue;
            logger.info("Cache size for " + rnId + " in " + this.snId + " has changed from " + remoteCacheSize + " to " + rnp.getJECacheSize());
            changed.add(rnp);
            needsNotification.add(rnId);
        }
        for (RepNodeParams changedParams : changed) {
            admin.updateParams(changedParams);
            sna.newRepNodeParameters(changedParams.getMap());
        }
        for (RepNodeId rnId : needsNotification) {
            RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(rnId);
            rnAdmin.newParameters();
        }
        for (RepNodeId rnId : needsRestart) {
            Utils.stopRN(this.plan, this.snId, rnId);
            Utils.startRN(this.plan, this.snId, rnId);
            Utils.waitForRepNodeState(this.plan, rnId, ConfigurableService.ServiceStatus.RUNNING);
        }
        return Task.State.SUCCEEDED;
    }

    RepNodeParams readRemoteRepNodeParams(StorageNodeAgentAPI sna, RepNodeId rnId) throws RemoteException {
        LoadParameters lp = sna.getParams();
        ParameterMap rMap = lp.getMap(rnId.getFullName(), "repNodeParams");
        return new RepNodeParams(rMap);
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

