/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class ChangeServiceAddresses
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private StorageNodeId oldNode;
    private StorageNodeId newNode;
    private TopologyPlan plan;

    public ChangeServiceAddresses(TopologyPlan plan, StorageNodeId oldNode, StorageNodeId newNode) {
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.plan = plan;
    }

    private ChangeServiceAddresses() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Parameters params = this.plan.getAdmin().getCurrentParameters();
        for (AdminParams ap : params.getAdminParams()) {
            if (!ap.getStorageNodeId().equals(this.newNode)) continue;
            this.changeAdminHAAddress(params, ap.getAdminId());
        }
        AdminParams adminParams = this.plan.getAdmin().getParams().getAdminParams();
        for (RepNodeParams rnp : params.getRepNodeParams()) {
            if (!rnp.getStorageNodeId().equals(this.newNode)) continue;
            Utils.changeHAAddress(this.plan.getTopology(), params, adminParams, rnp.getRepNodeId(), this.oldNode, this.newNode, this.plan, this.plan.getLogger());
        }
        return Task.State.SUCCEEDED;
    }

    private void changeAdminHAAddress(Parameters parameters, AdminId targetId) {
        String problemMsg = " for HA address update of " + targetId + " while replacing " + this.oldNode + " with " + this.newNode + " :";
        ChangeServiceAddresses.changeAdminHAAddress(this.plan, problemMsg, parameters, targetId);
    }

    public static void changeAdminHAAddress(AbstractPlan plan, String problemMsg, Parameters parameters, AdminId targetId) {
        boolean done = false;
        AdminParams targetAP = parameters.get(targetId);
        String targetHelperHosts = targetAP.getHelperHosts();
        String targetNodeHostPort = targetAP.getNodeHostPort();
        for (AdminParams peerAP : parameters.getAdminParams()) {
            AdminId peerId = peerAP.getAdminId();
            if (peerId.equals(targetId)) continue;
            StorageNodeParams peerSNP = parameters.get(peerAP.getStorageNodeId());
            try {
                CommandServiceAPI cs = RegistryUtils.getAdmin(peerSNP.getHostname(), peerSNP.getRegistryPort(), plan.getLoginManager());
                cs.updateMemberHAAddress(targetId, targetHelperHosts, targetNodeHostPort);
                done = true;
                break;
            }
            catch (NotBoundException notbound) {
                plan.getLogger().info(peerId + " cannot be contacted" + problemMsg + notbound);
            }
            catch (RemoteException e) {
                plan.getLogger().severe(peerId + " exception" + problemMsg + e);
            }
        }
        if (!done) {
            throw new OperationFaultException("Couldn't change HA address for " + targetId + " to " + targetNodeHostPort + " " + problemMsg);
        }
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

