/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.util.SecurityUtils;

@Persistent
public class AddTable
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private String parentName;
    private List<String> primaryKey;
    private List<String> majorKey;
    private FieldMap fieldMap;
    private boolean r2compat;
    private int schemaId;
    private String description;

    public AddTable(MetadataPlan<TableMetadata> plan, String tableName, String parentName, FieldMap fieldMap, List<String> primaryKey, List<String> shardKey, boolean r2compat, int schemaId, String description) {
        super(plan);
        this.tableName = tableName;
        this.parentName = parentName;
        this.primaryKey = primaryKey;
        this.majorKey = shardKey;
        this.fieldMap = fieldMap;
        this.r2compat = r2compat;
        this.schemaId = schemaId;
        this.description = description;
        TableMetadata md = plan.getMetadata();
        if (md != null && md.tableExists(tableName, parentName)) {
            throw new IllegalCommandException("Table already exists: " + TableMetadata.makeQualifiedName(tableName, parentName));
        }
        this.ensureCurrentUserOwnsParent();
    }

    private AddTable() {
    }

    private void ensureCurrentUserOwnsParent() {
        if (ExecutionContext.getCurrent() == null) {
            return;
        }
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            return;
        }
        if (this.parentName != null) {
            TableImpl parentTable = md.getTable(this.parentName);
            assert (parentTable != null);
            if (parentTable.getOwner() == null) {
                return;
            }
            if (!AccessCheckUtils.currentUserOwnsResource(parentTable)) {
                throw new IllegalCommandException("Only the owner of table " + this.parentName + " is able to " + "create child tables under it");
            }
        }
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            md = new TableMetadata(true);
        }
        if (!md.tableExists(this.tableName, this.parentName)) {
            md.addTable(this.tableName, this.parentName, this.primaryKey, this.majorKey, this.fieldMap, this.r2compat, this.schemaId, this.description, SecurityUtils.currentUserAsOwner());
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        String name = TableMetadata.makeQualifiedName(this.tableName, this.parentName);
        return TablePlanGenerator.makeName("AddTable", name, null);
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        AddTable other = (AddTable)t;
        if (!this.tableName.equalsIgnoreCase(other.tableName)) {
            return false;
        }
        if (this.parentName == null ? other.parentName != null : !this.parentName.equalsIgnoreCase(other.parentName)) {
            return false;
        }
        return this.primaryKey.equals(other.primaryKey) && this.majorKey.equals(other.majorKey) && this.fieldMap.equals(other.fieldMap);
    }
}

