/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.KVBuiltInRoleResolver;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class AddRole
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private final String roleName;

    public AddRole(SecurityMetadataPlan plan, String roleName) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.roleName = roleName;
        if (secMd != null && secMd.getRole(roleName) == null) {
            if (KVBuiltInRoleResolver.resolveRole(roleName) != null) {
                throw new IllegalCommandException("Role with name " + roleName + " is system-builtin role.");
            }
            try {
                KVStorePrivilegeLabel.valueOf(roleName.toUpperCase());
                throw new IllegalCommandException("Name of " + roleName + " already exists as a privilege");
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata md = (SecurityMetadata)this.plan.getMetadata();
        if (md == null) {
            String storeName = this.plan.getAdmin().getParams().getGlobalParams().getKVStoreName();
            md = new SecurityMetadata(storeName);
        }
        if (md.getRole(this.roleName) == null) {
            RoleInstance newRole = new RoleInstance(this.roleName);
            md.addRole(newRole);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public boolean logicalCompare(Task t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this.getClass() != t.getClass()) {
            return false;
        }
        AddRole other = (AddRole)t;
        return this.roleName.equalsIgnoreCase(other.roleName);
    }
}

