/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class AddPartitions
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    protected DeployTopoPlan plan;
    private List<Integer> partitionCounts;
    private int totalPartitions;

    public AddPartitions(DeployTopoPlan plan, List<Integer> partitionCounts, int totalPartitions) {
        this.plan = plan;
        this.partitionCounts = partitionCounts;
        this.totalPartitions = totalPartitions;
    }

    AddPartitions() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Logger logger = this.plan.getLogger();
        Admin plannerAdmin = this.plan.getAdmin();
        Topology current = plannerAdmin.getCurrentTopology();
        int numExistingPartitions = current.getPartitionMap().size();
        if (numExistingPartitions == this.totalPartitions) {
            logger.info("Partitions already created.");
            return Task.State.SUCCEEDED;
        }
        if (numExistingPartitions != this.totalPartitions && numExistingPartitions != 0) {
            throw new IllegalStateException("Trying to create " + this.totalPartitions + " but this topology unexpectedly already has " + numExistingPartitions + ". Store must be reinitialized");
        }
        for (int whichShard = 0; whichShard < this.partitionCounts.size(); ++whichShard) {
            int numPartitionsForShard = this.partitionCounts.get(whichShard);
            RepGroupId rgId = this.plan.getShardId(whichShard);
            for (int i = 0; i < numPartitionsForShard; ++i) {
                current.add(new Partition(current.get(rgId)));
            }
        }
        plannerAdmin.saveTopo(current, this.plan.getDeployedInfo(), this.plan);
        if (!Utils.broadcastTopoChangesToRNs(logger, current, "Initializing new partitions", plannerAdmin.getParams().getAdminParams(), this.plan)) {
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " totalPartitions = " + this.totalPartitions;
    }
}

