/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.topo.Topology;

@Persistent
public abstract class TopologyPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private Topology topology;
    private transient DeploymentInfo deploymentInfo;

    TopologyPlan(AtomicInteger idGen, String name, Planner planner, Topology topo) {
        super(idGen, name, planner);
        this.topology = topo;
    }

    protected TopologyPlan() {
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    public Topology getTopology() {
        return this.topology;
    }

    protected void setTopology(Topology t) {
        this.topology = t;
    }

    public boolean isFirstExecutionAttempt() {
        Topology current = this.getAdmin().getCurrentTopology();
        Topology createdByPlan = this.getTopology();
        if (current.getSequenceNumber() > createdByPlan.getSequenceNumber()) {
            throw new NonfatalAssertionException("Unexpected error: the current topology version (" + current.getSequenceNumber() + ") is greater than the " + "topology version (" + createdByPlan.getSequenceNumber() + ") used by " + this.getName());
        }
        return current.getSequenceNumber() < createdByPlan.getSequenceNumber();
    }

    @Override
    public DeploymentInfo getDeployedInfo() {
        return this.deploymentInfo;
    }

    @Override
    synchronized PlanRun startNewRun() {
        this.deploymentInfo = DeploymentInfo.makeDeploymentInfo(this, "none");
        return super.startNewRun();
    }

    @Override
    void stripForDisplay() {
        this.topology = null;
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysoperPrivList;
    }
}

