/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.RemoveUserPlan;
import oracle.kv.impl.admin.plan.task.AddRole;
import oracle.kv.impl.admin.plan.task.AddUser;
import oracle.kv.impl.admin.plan.task.ChangeUser;
import oracle.kv.impl.admin.plan.task.GrantPrivileges;
import oracle.kv.impl.admin.plan.task.GrantRoles;
import oracle.kv.impl.admin.plan.task.GrantRolesToRole;
import oracle.kv.impl.admin.plan.task.NewSecurityMDChange;
import oracle.kv.impl.admin.plan.task.RemoveRole;
import oracle.kv.impl.admin.plan.task.RemoveUser;
import oracle.kv.impl.admin.plan.task.RevokePrivileges;
import oracle.kv.impl.admin.plan.task.RevokeRoles;
import oracle.kv.impl.admin.plan.task.RevokeRolesFromRole;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.PasswordHash;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.PasswordHashDigest;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.topo.AdminId;

@Persistent
public class SecurityMetadataPlan
extends MetadataPlan<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private static final SecureRandom random = new SecureRandom();
    private static final KVVersion BASIC_AUTHENTICATION_VERSION = KVVersion.R3_0;
    public static final KVVersion BASIC_AUTHORIZATION_VERSION = KVVersion.R3_1;
    public static final KVVersion REALTIME_SESSION_UPDATE_VERSION = KVVersion.R3_2;
    public static final KVVersion USER_DEFINED_ROLE_VERSION = KVVersion.R3_3;
    private static final String userDefinedRoleNotSupported = "Could not perform operation until all nodes in the store support user-defined role feature";
    private static final String passwordExpireNotSupported = "Could not perform operation until all nodes in the store support password expiration feature";

    public SecurityMetadataPlan(AtomicInteger idGen, String planName, Planner planner) {
        super(idGen, planName, planner);
        SecurityMetadataPlan.checkVersion(planner.getAdmin(), BASIC_AUTHENTICATION_VERSION, "Cannot perform plan " + planName + " when not all" + " nodes in the store support security feature.");
    }

    private SecurityMetadataPlan() {
    }

    private static void ensureNotSelfDrop(String droppedUserName) {
        KVStoreUserPrincipal currentUserPrincipal = KVStoreUserPrincipal.getCurrentUser();
        if (currentUserPrincipal == null) {
            throw new IllegalCommandException("Could not identify current user");
        }
        if (droppedUserName.equals(currentUserPrincipal.getName())) {
            throw new IllegalCommandException("A current online user cannot drop itself");
        }
    }

    @Override
    protected Metadata.MetadataType getMetadataType() {
        return Metadata.MetadataType.SECURITY;
    }

    @Override
    protected Class<SecurityMetadata> getMetadataClass() {
        return SecurityMetadata.class;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Change SecurityMetadata";
    }

    @Override
    public void getCatalogLocks() throws PlanLocksHeldException {
        this.planner.lockElasticity(this.getId(), this.getName());
        this.getPerTaskLocks();
    }

    public PasswordHashDigest makeDefaultHashDigest(char[] plainPassword) {
        byte[] saltValue = PasswordHash.generateSalt(random, 16);
        return PasswordHashDigest.getHashDigest("PBKDF2WithHmacSHA1", 5000, 16, saltValue, plainPassword);
    }

    static void addNewMDChangeTasks(Admin admin, SecurityMetadataPlan plan) {
        Parameters parameters = admin.getCurrentParameters();
        for (AdminId adminId : parameters.getAdminIds()) {
            plan.addTask(new NewSecurityMDChange(plan, adminId));
        }
    }

    public static SecurityMetadataPlan createCreateUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword, Long pwdLifetime) {
        if (pwdLifetime != null) {
            SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, passwordExpireNotSupported);
        }
        String subPlanName = planName != null ? planName : "Create User";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new AddUser(plan, userName, isEnabled, isAdmin, plainPassword, pwdLifetime));
        return plan;
    }

    public static SecurityMetadataPlan createChangeUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, Boolean isEnabled, char[] plainPassword, boolean retainPassword, boolean clearRetainedPassword, Long pwdLifetime) {
        if (pwdLifetime != null) {
            SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, passwordExpireNotSupported);
        }
        String subPlanName = planName != null ? planName : "Change User";
        SecurityMetadataPlan plan = Utils.storeHasVersion(planner.getAdmin(), BASIC_AUTHORIZATION_VERSION) ? new ChangeUserPlan(idGen, subPlanName, planner) : new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new ChangeUser(plan, userName, isEnabled, plainPassword, retainPassword, clearRetainedPassword, pwdLifetime));
        return plan;
    }

    public static SecurityMetadataPlan createDropUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, boolean cascade) {
        SecurityMetadataPlan plan;
        String subPlanName;
        SecurityMetadataPlan.ensureNotSelfDrop(userName);
        String string = subPlanName = planName != null ? planName : "Drop User";
        if (Utils.storeHasVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION)) {
            plan = new RemoveUserPlan(idGen, subPlanName, planner, userName, cascade);
            SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        } else {
            if (cascade) {
                throw new IllegalCommandException("The CASCADE option is not enabled until all nodes in the store have been upgraded to " + USER_DEFINED_ROLE_VERSION + " or higher");
            }
            plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
            plan.addTask(new RemoveUser(plan, userName));
        }
        return plan;
    }

    public static SecurityMetadataPlan createGrantPlan(AtomicInteger idGen, String planName, Planner planner, String grantee, Set<String> roles) {
        String subPlanName = planName != null ? planName : "Grant Roles";
        RolePlan plan = new RolePlan(idGen, subPlanName, planner, roles);
        plan.addTask(new GrantRoles(plan, grantee, roles));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createGrantRolesToRolePlan(AtomicInteger idGen, String planName, Planner planner, String grantee, Set<String> roles) {
        SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, userDefinedRoleNotSupported);
        String subPlanName = planName != null ? planName : "Grant Roles (To Role)";
        RolePlan plan = new RolePlan(idGen, subPlanName, planner, roles);
        plan.addTask(new GrantRolesToRole(plan, grantee, roles));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createGrantPrivsPlan(AtomicInteger idGen, String planName, Planner planner, String roleName, String tableName, Set<String> privs) {
        String subPlanName = planName != null ? planName : "Grant Privileges";
        PrivilegePlan plan = new PrivilegePlan(idGen, subPlanName, planner, privs, tableName == null);
        plan.addTask(new GrantPrivileges(plan, roleName, tableName, privs));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createRevokePlan(AtomicInteger idGen, String planName, Planner planner, String revokee, Set<String> roles) {
        String subPlanName = planName != null ? planName : "Revoke Roles";
        RolePlan plan = new RolePlan(idGen, subPlanName, planner, roles);
        plan.addTask(new RevokeRoles(plan, revokee, roles));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createRevokeRolesFromRolePlan(AtomicInteger idGen, String planName, Planner planner, String revokee, Set<String> roles) {
        SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, userDefinedRoleNotSupported);
        String subPlanName = planName != null ? planName : "Revoke Roles (From Role)";
        RolePlan plan = new RolePlan(idGen, subPlanName, planner, roles);
        plan.addTask(new RevokeRolesFromRole(plan, revokee, roles));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createRevokePrivsPlan(AtomicInteger idGen, String planName, Planner planner, String roleName, String tableName, Set<String> privs) {
        String subPlanName = planName != null ? planName : "Revoke Privileges";
        PrivilegePlan plan = new PrivilegePlan(idGen, subPlanName, planner, privs, tableName == null);
        plan.addTask(new RevokePrivileges(plan, roleName, tableName, privs));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        return plan;
    }

    public static SecurityMetadataPlan createCreateRolePlan(AtomicInteger idGen, String planName, Planner planner, String roleName) {
        SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, userDefinedRoleNotSupported);
        String subPlanName = planName != null ? planName : "Create Role";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new AddRole(plan, roleName));
        return plan;
    }

    public static SecurityMetadataPlan createDropRolePlan(AtomicInteger idGen, String planName, Planner planner, String roleName) {
        SecurityMetadataPlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, userDefinedRoleNotSupported);
        String subPlanName = planName != null ? planName : "Drop Role";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new RemoveRole(plan, roleName));
        SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        for (KVStoreUser user : secMd.getAllUsers()) {
            if (!user.getGrantedRoles().contains(roleName.toLowerCase())) continue;
            plan.addTask(new RevokeRoles(plan, user.getName(), Collections.singleton(roleName)));
            SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        }
        for (RoleInstance role : secMd.getAllRoles()) {
            if (!role.getGrantedRoles().contains(RoleInstance.getNormalizedName(roleName))) continue;
            plan.addTask(new RevokeRolesFromRole(plan, role.name(), Collections.singleton(roleName)));
            SecurityMetadataPlan.addNewMDChangeTasks(planner.getAdmin(), plan);
        }
        return plan;
    }

    public static SecurityMetadataPlan createBroadcastSecurityMDPlan(AtomicInteger idGen, Planner planner) {
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, "Broadcast Security MD", planner);
        plan.addTask(new UpdateMetadata<SecurityMetadata>(plan));
        return plan;
    }

    @Override
    void stripForDisplay() {
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysoperPrivList;
    }

    public static class PrivilegePlan
    extends SecurityMetadataPlan {
        private static final long serialVersionUID = 1L;
        private static final String ALLPRIVS = "ALL";
        private static final String versionNotMetMsg = "Cannot grant or revoke privileges when not all nodes in the store supports user-defined role.";
        private final boolean isSystemPrivsOp;

        private PrivilegePlan(AtomicInteger idGen, String planName, Planner planner, Set<String> privs, boolean isSystemPrivsOp) {
            super(idGen, planName, planner);
            PrivilegePlan.checkVersion(planner.getAdmin(), USER_DEFINED_ROLE_VERSION, versionNotMetMsg);
            this.isSystemPrivsOp = isSystemPrivsOp;
            this.validatePrivileges(privs);
        }

        private void validatePrivileges(Set<String> privNames) {
            for (String privName : privNames) {
                if (ALLPRIVS.equalsIgnoreCase(privName)) continue;
                try {
                    KVStorePrivilegeLabel privLabel = KVStorePrivilegeLabel.valueOf(privName.toUpperCase(Locale.ENGLISH));
                    if (this.checkPrivConsistency(privLabel)) continue;
                    throw new IllegalCommandException("Could not use " + privName + " with type of " + (Object)((Object)privLabel.getType()) + " in this operation " + "which needs privilege type of " + (this.isSystemPrivsOp ? "SYSTEM" : "TABLE"));
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalCommandException(privName + " is not valid privilege name");
                }
            }
        }

        private boolean checkPrivConsistency(KVStorePrivilegeLabel privLabel) {
            if (privLabel.getType().equals((Object)KVStorePrivilege.PrivilegeType.SYSTEM)) {
                return this.isSystemPrivsOp;
            }
            return !this.isSystemPrivsOp;
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            return this.isSystemPrivsOp ? SystemPrivilege.sysoperPrivList : SystemPrivilege.usrviewPrivList;
        }
    }

    @Persistent
    public static class RolePlan
    extends SecurityMetadataPlan {
        private static final long serialVersionUID = 1L;
        private static final String roleUnsupportedMsg = "Cannot grant or revoke roles when not all nodes in the store support role management.";

        public RolePlan(AtomicInteger idGen, String planName, Planner planner, Set<String> roles) {
            super(idGen, planName, planner);
            RolePlan.checkVersion(planner.getAdmin(), REALTIME_SESSION_UPDATE_VERSION, roleUnsupportedMsg);
            this.validateRoleNames(roles);
        }

        private RolePlan() {
        }

        private void validateRoleNames(Set<String> roleNames) {
            RoleResolver roleResolver = this.planner.getAdmin().getRoleResolver();
            if (roleResolver == null) {
                throw new IllegalCommandException("Cannot grant or revole roles. Please make sure the security feature is enabled");
            }
            for (String roleName : roleNames) {
                RoleInstance role = roleResolver.resolve(roleName);
                if (role == null) {
                    throw new IllegalCommandException("Role with name : " + roleName + " does not exist");
                }
                if (role.assignable()) continue;
                throw new IllegalCommandException("Role " + roleName + " cannot be granted or revoked");
            }
        }
    }

    @Persistent
    private static class ChangeUserPlan
    extends SecurityMetadataPlan {
        private static final long serialVersionUID = 1L;

        private ChangeUserPlan(AtomicInteger idGen, String planName, Planner planner) {
            super(idGen, planName, planner);
        }

        private ChangeUserPlan() {
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            return SystemPrivilege.usrviewPrivList;
        }
    }
}

