/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.RemoveUser;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.table.Table;

public class RemoveUserPlan
extends SecurityMetadataPlan {
    private static final long serialVersionUID = 1L;
    private final String userName;

    public RemoveUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, boolean cascade) {
        super(idGen, planName, planner);
        SecurityMetadata secMd = (SecurityMetadata)this.getMetadata();
        this.userName = userName;
        if (secMd != null && secMd.getUser(userName) != null) {
            if (cascade) {
                throw new IllegalCommandException("The CASCADE option is not yet supported in this version");
            }
            this.ensureNotOwnsTable();
            this.addTask(new RemoveUser(this, userName));
        }
    }

    @Override
    public void preExecuteCheck(boolean force, Logger plannerlogger) {
        super.preExecuteCheck(force, plannerlogger);
        this.ensureNotOwnsTable();
    }

    private void ensureNotOwnsTable() {
        HashSet<String> ownedTables = new HashSet<String>();
        this.getOwnedTables(ownedTables);
        if (!ownedTables.isEmpty()) {
            throw new IllegalCommandException("Cannot drop a user that owns tables: " + ownedTables + ". Please retry after dropping all these tables");
        }
    }

    private void getOwnedTables(Set<String> tables) {
        TableMetadata tableMd = this.planner.getAdmin().getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
        if (tableMd == null || tableMd.getTables().isEmpty()) {
            return;
        }
        SecurityMetadata secMd = (SecurityMetadata)this.getMetadata();
        if (secMd == null || secMd.getUser(this.userName) == null) {
            return;
        }
        KVStoreUser user = secMd.getUser(this.userName);
        ResourceOwner owner = new ResourceOwner(user.getElementId(), user.getName());
        for (Table table : tableMd.getTables().values()) {
            this.addTablesToSet(owner, (TableImpl)table, tables);
        }
    }

    private void addTablesToSet(ResourceOwner owner, TableImpl table, Set<String> tables) {
        if (owner.equals(table.getOwner())) {
            tables.add(table.getFullName());
        }
        for (Table table1 : table.getChildTables().values()) {
            this.addTablesToSet(owner, (TableImpl)table1, tables);
        }
    }
}

