/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.ConfirmSNStatus;
import oracle.kv.impl.admin.plan.task.RemoveSN;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RemoveSNPlan
extends TopologyPlan {
    private static final long serialVersionUID = 1L;
    private StorageNodeId target;

    public RemoveSNPlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, StorageNodeId target) {
        super(idGen, planName, planner, topology);
        this.target = target;
        this.validate();
        this.addTask(new ConfirmSNStatus(this, target, false, "Please ensure that " + target + " is stopped before attempting to remove " + "it."));
        this.addTask(new RemoveSN(this, target));
    }

    private RemoveSNPlan() {
    }

    @Override
    public String getDefaultName() {
        return "Remove Storage Node";
    }

    private void validate() {
        Topology topology = this.getTopology();
        Parameters parameters = this.planner.getAdmin().getCurrentParameters();
        if (topology.get(this.target) == null) {
            throw new IllegalCommandException(this.target + " does not exist in the topology and cannot " + "be removed");
        }
        if (parameters.get(this.target) == null) {
            throw new IllegalCommandException(this.target + " does not exist in the parameters and cannot " + "be migrated");
        }
        ArrayList<ResourceId> existingServices = new ArrayList<ResourceId>();
        for (AdminParams ap : parameters.getAdminParams()) {
            if (!ap.getStorageNodeId().equals(this.target)) continue;
            existingServices.add(ap.getAdminId());
        }
        for (RepNodeParams rnp : parameters.getRepNodeParams()) {
            if (!rnp.getStorageNodeId().equals(this.target)) continue;
            existingServices.add(rnp.getRepNodeId());
        }
        if (existingServices.size() > 0) {
            throw new IllegalCommandException("Cannot remove " + this.target + " because it hosts these " + " components: " + existingServices);
        }
    }

    @Override
    void preExecutionSave() {
    }

    public StorageNodeId getTarget() {
        return this.target;
    }
}

