/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.ConfirmDatacenterStatus;
import oracle.kv.impl.admin.plan.task.RemoveDatacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RemoveDatacenterPlan
extends TopologyPlan {
    private static final long serialVersionUID = 1L;
    private DatacenterId targetId;

    public RemoveDatacenterPlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, DatacenterId targetId) {
        super(idGen, planName, planner, topology);
        if (targetId == null) {
            throw new IllegalCommandException("null targetId");
        }
        this.targetId = targetId;
        this.validate();
        String infoMsg = "Cannot remove non-empty zone [id=" + targetId + " name=" + topology.get(targetId).getName() + "].";
        this.addTask(new ConfirmDatacenterStatus(this, targetId, infoMsg));
        this.addTask(new RemoveDatacenter(this, targetId));
    }

    private RemoveDatacenterPlan() {
    }

    @Override
    public String getDefaultName() {
        return "Remove zone";
    }

    private void validate() {
        Topology topo = this.getTopology();
        if (topo.get(this.targetId) == null) {
            throw new IllegalCommandException("Zone [id=" + this.targetId + "] does not exist in the " + "topology and so cannot be removed");
        }
    }

    @Override
    void preExecutionSave() {
    }

    public DatacenterId getTarget() {
        return this.targetId;
    }
}

