/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.io.Serializable;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.util.FormatUtils;

public class PlanStateChange
implements Measurement,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int planId;
    private final String planName;
    private final Plan.State status;
    private final long time;
    private final int attemptNumber;
    private final boolean needsAlert;
    private final String msg;

    public PlanStateChange(int planId, String planName, Plan.State state, int attemptNumber, String msg) {
        this.planId = planId;
        this.planName = planName;
        this.status = state;
        this.time = System.currentTimeMillis();
        this.attemptNumber = attemptNumber;
        this.msg = msg;
        this.needsAlert = this.status == Plan.State.ERROR;
    }

    @Override
    public long getStart() {
        return this.time;
    }

    @Override
    public long getEnd() {
        return this.time;
    }

    @Override
    public int getId() {
        return Metrics.PLAN_STATE.getId();
    }

    public int getPlanId() {
        return this.planId;
    }

    public Plan.State getStatus() {
        return this.status;
    }

    public long getTime() {
        return this.time;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public boolean isNeedsAlert() {
        return this.needsAlert;
    }

    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        String show = "PlanStateChange [id=" + this.planId + " name=" + this.planName + " state=" + (Object)((Object)this.status) + " at " + FormatUtils.formatDateAndTime(this.time) + " numAttempts=" + this.attemptNumber;
        if (this.needsAlert) {
            show = show + " needsAlert=true";
        }
        if (this.msg != null) {
            show = show + " : " + this.msg;
        }
        show = show + "]";
        return show;
    }
}

