/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.ExecutionListener;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.NextJob;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.TaskList;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public class PlanExecutor
implements Callable<Plan.State> {
    private static final int TASK_CHECK_INTERVAL = 1;
    private static final TimeUnit TASK_CHECK_TIME_UNIT = TimeUnit.SECONDS;
    private static final int POOL_SIZE = 5;
    private final AbstractPlan plan;
    private final ScheduledExecutorService pool;
    private final Admin admin;
    private final Planner planner;
    private final PlanRun planRun;
    private final Logger logger;
    private final PlanFaultHandler faultHandler;
    private final int totalTasks;
    private final Set<CleanupInfo> taskCleanups;
    private final ExecutionContext execCtx;
    public static TestHook<Integer> FAULT_HOOK;

    public PlanExecutor(Admin admin, Planner planner, AbstractPlan plan, PlanRun planRun, Logger logger) {
        this.admin = admin;
        this.planner = planner;
        this.plan = plan;
        this.planRun = planRun;
        this.logger = logger;
        this.faultHandler = new PlanFaultHandler();
        this.totalTasks = plan.getTaskList().getTotalTaskCount();
        this.execCtx = ExecutionContext.getCurrent();
        this.pool = new ScheduledThreadPoolExecutor(5, new KVThreadFactory.KVPrivilegedThreadFactory("PlanExecutor", this.execCtx, logger));
        this.taskCleanups = new HashSet<CleanupInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plan.State call() throws Exception {
        this.plan.setLogger(this.logger);
        try {
            this.faultHandler.execute(new SimpleProcedure(){

                @Override
                public void execute() throws Exception {
                    if (PlanExecutor.this.execCtx == null) {
                        this.planStart();
                    } else {
                        ExecutionContext.runWithContext(new ExecutionContext.Procedure<Exception>(){

                            @Override
                            public void run() throws Exception {
                                this.planStart();
                            }
                        }, PlanExecutor.this.execCtx);
                    }
                }

                private void planStart() throws Exception {
                    PlanExecutor.this.taskCleanups.clear();
                    PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.RUNNING, "Plan is starting");
                    for (ExecutionListener listener : PlanExecutor.this.plan.getListeners()) {
                        listener.planStart(PlanExecutor.this.plan);
                    }
                    PlanExecutor.this.admin.savePlan(PlanExecutor.this.plan, "after execution");
                    PlanExecutor.this.plan.preExecutionSave();
                    TaskList taskList = PlanExecutor.this.plan.getTaskList();
                    if (taskList.getStrategy() == TaskList.ExecutionStrategy.PARALLEL) {
                        throw new IllegalStateException(PlanExecutor.this.plan + "does not expect to see a parallel task " + "list at the topmost level");
                    }
                    PlanExecutor.this.executeSerialTaskList(taskList);
                }
            });
            this.faultHandler.execute(new SimpleProcedure(){

                @Override
                public void execute() {
                    if (PlanExecutor.this.execCtx == null) {
                        this.planFinished();
                    } else {
                        ExecutionContext.runWithContext(new ExecutionContext.SimpleProcedure(){

                            @Override
                            public void run() {
                                this.planFinished();
                            }
                        }, PlanExecutor.this.execCtx);
                    }
                }

                private void planFinished() {
                    PlanExecutor.this.logger.log(Level.FINE, "finish count={0}, totalTasks={1}, errors={2}, interrupts={3}", new Object[]{PlanExecutor.this.planRun.getNumFinishedTasks(), PlanExecutor.this.totalTasks, PlanExecutor.this.planRun.getNumErrorTasks(), PlanExecutor.this.planRun.getNumInterruptedTasks()});
                    if (PlanExecutor.this.plan.getState() != Plan.State.ERROR) {
                        if (PlanExecutor.this.planRun.getNumErrorTasks() > 0) {
                            PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.ERROR, "Plan incurred " + PlanExecutor.this.planRun.getNumErrorTasks() + " failed tasks:" + PlanExecutor.this.planRun.getFailureDescription(false));
                        } else if (PlanExecutor.this.plan.getState() == Plan.State.INTERRUPT_REQUESTED) {
                            PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.INTERRUPTED, "Plan interrupted," + PlanExecutor.this.planRun.getNumInterruptedTasks() + " tasks were interrupted");
                        } else if (PlanExecutor.this.planRun.getNumFinishedTasks() == PlanExecutor.this.totalTasks) {
                            PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.SUCCEEDED, "Plan finished.");
                        } else {
                            int unstarted = PlanExecutor.this.totalTasks - PlanExecutor.this.planRun.getNumFinishedTasks();
                            PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.INTERRUPT_REQUESTED, "Plan did not execute " + unstarted + " tasks even through interrupt not" + " requested");
                            PlanExecutor.this.plan.setState(PlanExecutor.this.planRun, PlanExecutor.this.planner, Plan.State.INTERRUPTED, "Plan interrupted, " + unstarted + " tasks not started");
                        }
                    }
                    PlanExecutor.this.admin.savePlan(PlanExecutor.this.plan, "after execution");
                    PlanExecutor.this.planner.planFinished(PlanExecutor.this.plan);
                    for (ExecutionListener listener : PlanExecutor.this.plan.getListeners()) {
                        listener.planEnd(PlanExecutor.this.plan);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            this.faultHandler.execute(new /* invalid duplicate definition of identical inner class */);
            this.pool.shutdownNow();
            throw throwable;
        }
        this.pool.shutdownNow();
        return this.plan.getState();
    }

    private void executeSerialTaskList(TaskList taskList) throws Exception {
        if (taskList.getStrategy() != TaskList.ExecutionStrategy.SERIAL) {
            throw new IllegalStateException(this.plan + " expects a serial task list, not " + (Object)((Object)taskList.getStrategy()));
        }
        for (Task task : taskList.getTasks()) {
            if (this.plan.isInterruptRequested()) break;
            TaskList nestedTaskList = task.getNestedTasks();
            if (nestedTaskList != null) {
                if (!this.executeParallelTaskList(nestedTaskList)) break;
                continue;
            }
            TaskRun taskRun = this.plan.startTask(this.planRun, task, this.logger);
            Future<Task.State> future = null;
            try {
                for (ExecutionListener listener : this.plan.getListeners()) {
                    listener.taskStart(this.plan, task, taskRun.getTaskNum(), this.totalTasks);
                }
                TestHookExecute.doHookIfSet(FAULT_HOOK, null);
                future = this.pool.submit(task.getFirstJob(taskRun.getTaskNum(), null));
            }
            catch (RejectedExecutionException e) {
                this.recordTaskFailure(taskRun, Task.State.PENDING, e, null);
                throw e;
            }
            boolean planShouldContinue = this.examineFuture(future, taskRun, task, null);
            if (this.waitForTaskCleanups() && planShouldContinue) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeParallelTaskList(TaskList taskList) throws Exception {
        if (taskList.getStrategy() != TaskList.ExecutionStrategy.PARALLEL) {
            throw new IllegalStateException(this.plan + " expects a parallel task list, not " + (Object)((Object)taskList.getStrategy()));
        }
        ParallelTaskRunner runner = new ParallelTaskRunner(taskList);
        try {
            for (Task t : taskList.getTasks()) {
                if (t.getNestedTasks() != null) {
                    throw new IllegalStateException("Only one level of task nesting is currently supported, but " + t + " has nested tasks");
                }
                runner.submitFirstJob(t);
            }
        }
        finally {
            runner.clearUnsubmittedTasks();
            boolean listFinished = false;
            do {
                try {
                    listFinished = runner.awaitFinish();
                }
                catch (InterruptedException e) {
                    this.logger.info("Interrupted while waiting for completion of parallel tasks: " + LoggerUtils.getStackTrace(e));
                }
                runner.checkForDeadTasks();
            } while (!listFinished);
            this.logger.log(Level.FINE, "Parallel task submission: listFinished={0}", listFinished);
        }
        boolean planShouldContinue = true;
        for (ParallelTaskRunner.TaskInfo taskInfo : runner.getTaskInfo()) {
            if (this.examineFuture(taskInfo.future, taskInfo.taskRun, taskInfo.task, taskInfo.additionalInfo)) continue;
            planShouldContinue = false;
        }
        this.waitForTaskCleanups();
        return planShouldContinue;
    }

    private void recordTaskFailure(TaskRun taskRun, Task.State taskState, Exception e, String additionalInfo) throws Exception {
        Throwable trueCause = null;
        if (e != null) {
            trueCause = e;
            if (e instanceof ExecutionException) {
                trueCause = e.getCause();
            }
        }
        String problem = taskRun.getTaskNum() + "/" + taskRun.getTaskName() + " failed.";
        if (additionalInfo != null) {
            problem = problem + " " + additionalInfo;
        }
        this.plan.setTaskState(taskRun, taskState, this.logger);
        this.plan.saveFailure(taskRun, trueCause, problem, this.logger);
        this.plan.saveFailure(this.planRun, (Throwable)(trueCause == null ? e : trueCause), problem, this.logger);
        this.logger.log(Level.FINE, "Record failure of {0}/{1}, final state={2} problem={3} {4}", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), taskState, e, additionalInfo});
    }

    private void putPlanInError(Throwable t) {
        String problem = "Problem during plan execution";
        this.plan.saveFailure(this.planRun, t, problem, this.logger);
        if (this.plan.getState() == Plan.State.ERROR) {
            this.logger.log(Level.SEVERE, "Second error in plan execution, plan already in ERROR", t);
        } else {
            this.plan.setState(this.planRun, this.planner, Plan.State.ERROR, problem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForTaskCleanups() {
        if (this.taskCleanups.isEmpty()) {
            return true;
        }
        boolean allSucceeded = true;
        this.plan.setCleanupStarted();
        for (CleanupInfo c : this.taskCleanups) {
            TaskRun tRun = c.getTaskRun();
            boolean cleanupDone = false;
            do {
                try {
                    this.logger.log(Level.INFO, "Waiting for cleanup of task {0}/{1}", new Object[]{tRun.getTaskNum(), tRun.getTaskName()});
                    Future<?> f = c.getFuture();
                    if (f != null) {
                        f.get(1L, TASK_CHECK_TIME_UNIT);
                    }
                    cleanupDone = true;
                }
                catch (InterruptedException retry) {
                    this.logger.log(Level.FINE, "Cleanup of task {0}/{1} interrupted", new Object[]{tRun.getTaskNum(), tRun.getTaskName()});
                }
                catch (TimeoutException retry) {
                    this.logger.log(Level.FINE, "Cleanup of task {0}/{1} timed out, will retry", new Object[]{tRun.getTaskNum(), tRun.getTaskName()});
                }
                catch (Exception e) {
                    allSucceeded = false;
                    cleanupDone = true;
                    String info = LoggerUtils.getStackTrace(e);
                    this.logger.log(Level.SEVERE, "Cleanup of task {0}/{1} failed: {2}", new Object[]{tRun.getTaskNum(), tRun.getTaskName(), info});
                    this.plan.saveCleanupFailure(tRun, info);
                }
                finally {
                    this.plan.cleanupEnded(tRun);
                }
            } while (!this.plan.cleanupInterrupted() && !cleanupDone);
        }
        return allSucceeded;
    }

    private Task.State waitForFinish(Future<Task.State> future, TaskRun taskRun) throws Exception {
        if (future == null) {
            return Task.State.ERROR;
        }
        Task.State tState = Task.State.RUNNING;
        while (tState == Task.State.RUNNING) {
            this.logger.log(Level.FINEST, "start wait for {0}/{1}", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName()});
            try {
                tState = future.get(1L, TASK_CHECK_TIME_UNIT);
            }
            catch (InterruptedException retry) {
                this.logger.log(Level.FINE, "wait for finish of {0}/{1} got {2}", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), retry});
                tState = Task.State.RUNNING;
            }
            catch (TimeoutException e) {
                this.logger.log(Level.FINE, "wait for finish of {0}/{1} got {2}", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), e});
                if (this.plan.isInterruptRequested()) {
                    return Task.State.INTERRUPTED;
                }
                tState = Task.State.RUNNING;
            }
            catch (Exception e) {
                throw e;
            }
        }
        return tState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean examineFuture(Future<Task.State> future, TaskRun taskRun, Task task, String additionalInfo) throws Exception {
        Object cleanupJob;
        boolean planShouldContinue;
        block29: {
            planShouldContinue = task.continuePastError();
            try {
                Task.State tState = this.waitForFinish(future, taskRun);
                if (tState == null) {
                    this.plan.setTaskState(taskRun, Task.State.INTERRUPTED, this.logger);
                    this.plan.saveFailure(taskRun, null, "Null status returned from future.get for " + task, this.logger);
                    planShouldContinue = false;
                } else if (tState == Task.State.INTERRUPTED) {
                    taskRun.setState(Task.State.INTERRUPTED, this.logger);
                    this.plan.saveFailure(taskRun, null, "Task didn't complete, plan was interrupted", this.logger);
                    planShouldContinue = false;
                } else if (tState == Task.State.ERROR) {
                    this.recordTaskFailure(taskRun, tState, null, additionalInfo);
                } else {
                    taskRun.setState(tState, this.logger);
                }
                if (future == null || taskRun.getState() != Task.State.ERROR && taskRun.getState() != Task.State.INTERRUPTED || (cleanupJob = task.getCleanupJob()) == null) break block29;
                this.plan.cleanupStarted(taskRun);
            }
            catch (Exception e) {
                Object cleanupJob2;
                block30: {
                    try {
                        this.recordTaskFailure(taskRun, Task.State.ERROR, e, additionalInfo);
                        if (future == null || taskRun.getState() != Task.State.ERROR && taskRun.getState() != Task.State.INTERRUPTED || (cleanupJob2 = task.getCleanupJob()) == null) break block30;
                        this.plan.cleanupStarted(taskRun);
                    }
                    catch (Throwable throwable) {
                        Object cleanupJob3;
                        if (future != null && (taskRun.getState() == Task.State.ERROR || taskRun.getState() == Task.State.INTERRUPTED) && (cleanupJob3 = task.getCleanupJob()) != null) {
                            this.plan.cleanupStarted(taskRun);
                            this.logger.log(Level.INFO, "Task {0}/{1} ended in {2}, cleaning up.", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), taskRun.getState()});
                            Future<?> f = this.pool.submit((Runnable)cleanupJob3);
                            this.taskCleanups.add(new CleanupInfo(taskRun, f));
                        }
                        this.plan.incrementEndCount(this.planRun, taskRun.getState());
                        if (future != null && !future.isDone()) {
                            future.cancel(true);
                        }
                        this.plan.setEndTime(this.planRun);
                        cleanupJob3 = this.plan;
                        synchronized (cleanupJob3) {
                            if (this.planRun.getState() == Plan.State.RUNNING) {
                                planShouldContinue = taskRun.getState() == Task.State.SUCCEEDED || task.continuePastError();
                            }
                            this.admin.savePlan(this.plan, "after execution");
                        }
                        for (ExecutionListener listener : this.plan.getListeners()) {
                            listener.taskEnd(this.plan, task, taskRun, taskRun.getTaskNum(), this.totalTasks);
                        }
                        throw throwable;
                    }
                    this.logger.log(Level.INFO, "Task {0}/{1} ended in {2}, cleaning up.", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), taskRun.getState()});
                    Future<?> f = this.pool.submit((Runnable)cleanupJob2);
                    this.taskCleanups.add(new CleanupInfo(taskRun, f));
                }
                this.plan.incrementEndCount(this.planRun, taskRun.getState());
                if (future != null && !future.isDone()) {
                    future.cancel(true);
                }
                this.plan.setEndTime(this.planRun);
                cleanupJob2 = this.plan;
                synchronized (cleanupJob2) {
                    if (this.planRun.getState() == Plan.State.RUNNING) {
                        planShouldContinue = taskRun.getState() == Task.State.SUCCEEDED || task.continuePastError();
                    }
                    this.admin.savePlan(this.plan, "after execution");
                }
                for (ExecutionListener listener : this.plan.getListeners()) {
                    listener.taskEnd(this.plan, task, taskRun, taskRun.getTaskNum(), this.totalTasks);
                }
            }
            this.logger.log(Level.INFO, "Task {0}/{1} ended in {2}, cleaning up.", new Object[]{taskRun.getTaskNum(), taskRun.getTaskName(), taskRun.getState()});
            Future<?> f = this.pool.submit((Runnable)cleanupJob);
            this.taskCleanups.add(new CleanupInfo(taskRun, f));
        }
        this.plan.incrementEndCount(this.planRun, taskRun.getState());
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        this.plan.setEndTime(this.planRun);
        cleanupJob = this.plan;
        synchronized (cleanupJob) {
            if (this.planRun.getState() == Plan.State.RUNNING) {
                planShouldContinue = taskRun.getState() == Task.State.SUCCEEDED || task.continuePastError();
            }
            this.admin.savePlan(this.plan, "after execution");
        }
        for (ExecutionListener listener : this.plan.getListeners()) {
            listener.taskEnd(this.plan, task, taskRun, taskRun.getTaskNum(), this.totalTasks);
        }
        return planShouldContinue;
    }

    public static List<Task> getFlatTaskList(Plan plan, int startTask) {
        TaskList taskList = plan.getTaskList();
        ArrayList<Task> unstarted = new ArrayList<Task>();
        int taskCount = 0;
        for (Task task : taskList.getTasks()) {
            TaskList nestedTasks = task.getNestedTasks();
            if (nestedTasks != null) {
                for (Task nested : nestedTasks.getTasks()) {
                    if (taskCount >= startTask) {
                        unstarted.add(nested);
                    }
                    ++taskCount;
                }
                continue;
            }
            if (taskCount >= startTask) {
                unstarted.add(task);
            }
            ++taskCount;
        }
        return unstarted;
    }

    private class CleanupInfo {
        private final TaskRun taskRun;
        private final Future<?> future;

        CleanupInfo(TaskRun taskRun, Future<?> future) {
            this.taskRun = taskRun;
            this.future = future;
        }

        TaskRun getTaskRun() {
            return this.taskRun;
        }

        Future<?> getFuture() {
            return this.future;
        }
    }

    public class ParallelTaskRunner {
        private final CountDownLatch waitForCompletion;
        private final Map<Integer, TaskInfo> taskInfoMap;
        private final int numParallelTasks;
        private static final String RUNNER = "Parallel Task Runner:";
        private int numSubmitted = 0;

        ParallelTaskRunner(TaskList taskList) {
            this.numParallelTasks = taskList.getTotalTaskCount();
            this.waitForCompletion = new CountDownLatch(this.numParallelTasks);
            this.taskInfoMap = new HashMap<Integer, TaskInfo>();
        }

        public void clearUnsubmittedTasks() {
            if (this.numSubmitted < this.numParallelTasks) {
                PlanExecutor.this.logger.log(Level.INFO, "{0} only {1} out of {2} tasks started, reduce number of tasks to wait for.", new Object[]{RUNNER, this.numSubmitted, this.numParallelTasks});
                for (int i = 0; i < this.numParallelTasks - this.numSubmitted; ++i) {
                    this.waitForCompletion.countDown();
                }
            }
        }

        void submitFirstJob(Task task) throws Exception {
            ++this.numSubmitted;
            TaskRun taskRun = PlanExecutor.this.plan.startTask(PlanExecutor.this.planRun, task, PlanExecutor.this.logger);
            try {
                for (ExecutionListener listener : PlanExecutor.this.plan.getListeners()) {
                    listener.taskStart(PlanExecutor.this.plan, task, taskRun.getTaskNum(), PlanExecutor.this.totalTasks);
                }
                this.setTaskInfo(taskRun, task, null);
                PlanExecutor.this.logger.log(Level.FINE, "{0} submitted {1} for task {2}", new Object[]{RUNNER, task.getName(), taskRun.getTaskNum()});
                TestHookExecute.doHookIfSet(FAULT_HOOK, null);
                Future<Task.State> f = PlanExecutor.this.pool.submit(task.getFirstJob(taskRun.getTaskNum(), this));
                this.setTaskInfo(taskRun, task, f);
            }
            catch (RejectedExecutionException e) {
                PlanExecutor.this.logger.log(Level.SEVERE, "{0} task {2}/job={3} got {4}", new Object[]{RUNNER, taskRun.getTaskNum(), task.getName(), e});
                throw new IllegalStateException("Unexpected " + e + ", ScheduledExecutionService should " + "have an unbounded work queue");
            }
            catch (Exception e) {
                PlanExecutor.this.recordTaskFailure(taskRun, Task.State.ERROR, e, "Problem with concurrent start of parallel tasks");
            }
        }

        public Task.State dispatchNextJob(int taskId, NextJob nextJob) {
            TestHookExecute.doHookIfSet(FAULT_HOOK, null);
            PlanExecutor.this.admin.savePlan(PlanExecutor.this.plan, "after execution");
            switch (nextJob.getPrevJobTaskState()) {
                case RUNNING: 
                case PENDING: {
                    if (PlanExecutor.this.plan.isInterruptRequested()) {
                        PlanExecutor.this.logger.log(Level.INFO, "{0}.dispatch: plan is interrupted, {1}/{2} job={3} will not be executed", new Object[]{RUNNER, taskId, this.taskInfoMap.get(taskId).getName(), nextJob.getDescription()});
                        this.completeTaskInfo(taskId, nextJob.getAdditionalInfo());
                        this.waitForCompletion.countDown();
                        return Task.State.INTERRUPTED;
                    }
                    PlanExecutor.this.logger.log(Level.FINE, "{0} task {1}/{2} job={3} will run in {4} {5}", new Object[]{RUNNER, taskId, this.taskInfoMap.get(taskId).getName(), nextJob.getDescription(), nextJob.getDelay(), nextJob.getTimeUnit()});
                    ScheduledFuture<Task.State> f = PlanExecutor.this.pool.schedule(nextJob.getNextCallable(), nextJob.getDelay(), nextJob.getTimeUnit());
                    this.updateTaskInfo(taskId, f);
                    break;
                }
                case SUCCEEDED: 
                case INTERRUPTED: 
                case ERROR: {
                    this.completeTaskInfo(taskId, nextJob.getAdditionalInfo());
                    this.waitForCompletion.countDown();
                    Level logLevel = Level.INFO;
                    if (nextJob.getPrevJobTaskState() == Task.State.SUCCEEDED) {
                        logLevel = Level.FINE;
                    }
                    PlanExecutor.this.logger.log(logLevel, "{0} task {1}/job={2} finished, state={3}", new Object[]{RUNNER, taskId, nextJob, nextJob.getPrevJobTaskState()});
                }
            }
            return nextJob.getPrevJobTaskState();
        }

        boolean awaitFinish() throws InterruptedException {
            PlanExecutor.this.logger.log(Level.FINE, "{0} Wait for {1} out of {2} tasks to complete", new Object[]{RUNNER, this.waitForCompletion.getCount(), this.numParallelTasks});
            boolean done = this.waitForCompletion.await(1L, TASK_CHECK_TIME_UNIT);
            PlanExecutor.this.logger.log(Level.FINE, "{0} {1} out of {2} tasks still outstanding", new Object[]{RUNNER, this.waitForCompletion.getCount(), this.numParallelTasks});
            return done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Task getTask(int taskId) {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                return this.taskInfoMap.get((Object)Integer.valueOf((int)taskId)).task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getDetails(int taskId) {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                return this.taskInfoMap.get((Object)Integer.valueOf((int)taskId)).taskRun.getDetails();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTaskInfo(TaskRun taskRun, Task task, Future<Task.State> f) {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                this.taskInfoMap.put(taskRun.getTaskNum(), new TaskInfo(taskRun, task, f));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTaskInfo(int taskId, Future<Task.State> f) {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                TaskInfo oldInfo = this.taskInfoMap.get(taskId);
                this.taskInfoMap.put(taskId, new TaskInfo(oldInfo.taskRun, oldInfo.task, f));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeTaskInfo(int taskId, String additionalInfo) {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                TaskInfo oldInfo = this.taskInfoMap.get(taskId);
                oldInfo.addInfo(additionalInfo);
                oldInfo.completed = true;
            }
        }

        Collection<TaskInfo> getTaskInfo() {
            return this.taskInfoMap.values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkForDeadTasks() {
            Map<Integer, TaskInfo> map = this.taskInfoMap;
            synchronized (map) {
                for (TaskInfo ti : this.taskInfoMap.values()) {
                    boolean doCleanup = false;
                    if (ti.future == null) {
                        if (!ti.completed) {
                            PlanExecutor.this.logger.log(Level.INFO, "{0} cleaning up unstarted task {1} {2}", new Object[]{RUNNER, ti.taskRun.getTaskNum(), ti.task});
                            doCleanup = true;
                        }
                    } else if (ti.future.isDone() && !ti.completed) {
                        PlanExecutor.this.logger.log(Level.INFO, "{0} cleaning up dead task {1} {2}", new Object[]{RUNNER, ti.taskRun.getTaskNum(), ti.task});
                        doCleanup = true;
                    }
                    if (!doCleanup) continue;
                    ti.completed = true;
                    this.waitForCompletion.countDown();
                }
            }
        }

        private class TaskInfo {
            final TaskRun taskRun;
            final Task task;
            final Future<Task.State> future;
            boolean completed;
            String additionalInfo;

            TaskInfo(TaskRun taskRun, Task task, Future<Task.State> future) {
                this.taskRun = taskRun;
                this.task = task;
                this.future = future;
                this.completed = false;
            }

            void addInfo(String info) {
                this.additionalInfo = this.additionalInfo == null ? info : this.additionalInfo + info + " ";
            }

            String getName() {
                return this.taskRun.getTaskName();
            }
        }
    }

    public static interface SimpleProcedure {
        public void execute() throws Exception;
    }

    private class PlanFaultHandler {
        private PlanFaultHandler() {
        }

        void execute(SimpleProcedure proc) {
            try {
                proc.execute();
            }
            catch (Error e) {
                PlanExecutor.this.putPlanInError(e);
                throw e;
            }
            catch (RuntimeException re) {
                PlanExecutor.this.putPlanInError(re);
                throw re;
            }
            catch (Exception e) {
                PlanExecutor.this.putPlanInError(e);
                throw new OperationFaultException("Problem in plan execution", e);
            }
        }
    }
}

