/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;

@Persistent
public abstract class MetadataPlan<T extends Metadata<? extends MetadataInfo>>
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private int basis;

    protected MetadataPlan(AtomicInteger idGen, String planName, Planner planner) {
        super(idGen, planName, planner);
        T md = this.getMetadata();
        this.basis = md == null ? 0 : md.getSequenceNumber();
    }

    protected MetadataPlan() {
    }

    protected abstract Metadata.MetadataType getMetadataType();

    protected abstract Class<T> getMetadataClass();

    public T getMetadata() {
        return this.getAdmin().getMetadata(this.getMetadataClass(), this.getMetadataType());
    }

    @Override
    public void preExecuteCheck(boolean force, Logger executeLogger) {
        int seqNum;
        T md = this.getMetadata();
        int n = seqNum = md == null ? 0 : md.getSequenceNumber();
        if (seqNum != this.basis) {
            throw new IllegalCommandException("Plan " + this + " was based on the " + (md != null ? md.getType() : "") + " metadata at " + "sequence " + this.basis + " but the current metadata is at sequence " + (md != null ? Integer.valueOf(md.getSequenceNumber()) : "unknown") + ". Please cancel this plan and create a new plan.");
        }
    }

    @Override
    public boolean updatingMetadata(Metadata<?> metadata) {
        return metadata.getType().equals((Object)this.getMetadataType()) ? this.updateBasis(metadata.getSequenceNumber()) : false;
    }

    private boolean updateBasis(int newBasis) {
        if (this.basis == newBasis) {
            return false;
        }
        if (this.basis > newBasis) {
            throw new IllegalStateException(this + " attempting to persist older version of " + (Object)((Object)this.getMetadataType()) + "  metadata");
        }
        this.basis = newBasis;
        return true;
    }

    static void checkVersion(Admin admin, KVVersion targetVersion, String errMsg) {
        if (!Utils.storeHasVersion(admin, targetVersion)) {
            throw new IllegalCommandException(String.format("%s The highest version supported by all nodes is lower than the required version of %s or later.", errMsg, targetVersion.getNumericVersionString()));
        }
    }
}

