/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.StatusReport;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.TopoTaskGenerator;
import oracle.kv.impl.admin.plan.task.MigratePartition;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.TopologyDiff;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.TopologyPrinter;

@Persistent
public class DeployTopoPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private final List<RepGroupId> newlyGeneratedShardIds = new ArrayList<RepGroupId>();
    private String candidateName;
    private int sourceTopoSequence;
    private transient DeploymentInfo deploymentInfo;

    private DeployTopoPlan() {
    }

    public DeployTopoPlan(AtomicInteger idGen, String planName, Planner planner, Topology current, TopologyCandidate candidate) {
        super(idGen, planName, planner);
        this.sourceTopoSequence = current.getSequenceNumber();
        TopoTaskGenerator generator = new TopoTaskGenerator(this, current, candidate, planner.getAdmin().getParams());
        generator.generate();
        this.candidateName = candidate.getName();
    }

    public boolean isNewShardCreated(int planShardIdx) {
        return this.newlyGeneratedShardIds.get(planShardIdx) != null;
    }

    public void setNewShardId(int planShardIdx, RepGroupId shardId) {
        this.newlyGeneratedShardIds.add(planShardIdx, shardId);
    }

    public RepGroupId getShardId(int planShardIdx) {
        if (this.newlyGeneratedShardIds.size() > planShardIdx) {
            return this.newlyGeneratedShardIds.get(planShardIdx);
        }
        return null;
    }

    @Override
    public void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Deploy Topo";
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public DeploymentInfo getDeployedInfo() {
        return this.deploymentInfo;
    }

    @Override
    synchronized PlanRun startNewRun() {
        this.deploymentInfo = DeploymentInfo.makeDeploymentInfo(this, this.candidateName);
        return super.startNewRun();
    }

    @Override
    public void getCatalogLocks() throws PlanLocksHeldException {
        this.planner.lockElasticity(this.getId(), this.getName());
        this.getPerTaskLocks();
    }

    @Override
    public void preExecuteCheck(boolean force, Logger executeLogger) {
        Admin admin = this.planner.getAdmin();
        Topology current = admin.getCurrentTopology();
        Parameters params = admin.getCurrentParameters();
        TopologyCandidate candidate = admin.getCandidate(this.candidateName);
        Topology future = candidate.getTopology();
        executeLogger.log(Level.INFO, "{0} deploying topology candidate {1}.", new Object[]{this.toString(), this.candidateName});
        executeLogger.log(Level.INFO, "Current topology: {0}", TopologyPrinter.printTopology(current));
        TopologyDiff diff = new TopologyDiff(current, null, candidate, params, false);
        executeLogger.log(Level.INFO, "Preview of changes to be executed by {0}:\n{1}", new Object[]{this.toString(), diff.display(true)});
        executeLogger.log(Level.INFO, "Target topology candidate: {0}\n{1}", new Object[]{candidate.getName(), TopologyPrinter.printTopology(future)});
        if (current.getSequenceNumber() != this.sourceTopoSequence) {
            throw new IllegalCommandException("Plan " + this + " was based on the system topology at " + "sequence " + this.sourceTopoSequence + " but the current topology is at sequence " + current.getSequenceNumber() + ". Please cancel this plan and create a new plan with the " + "command \"plan deploy-topology -name " + this.candidateName);
        }
        if (force) {
            executeLogger.log(Level.INFO, "-force specified for {0} so no topology validation will be done.", this.toString());
            return;
        }
        Rules.Results statusQuo = Rules.validate(current, params, true);
        Rules.Results futureState = Rules.validate(future, params, false);
        Rules.Results newIssues = futureState.remove(statusQuo);
        int newViolations = newIssues.getViolations().size();
        if (newViolations > 0) {
            String errorDesc = newViolations == 1 ? "1 new violation" : newViolations + " new violations: " + newIssues;
            throw new IllegalCommandException("Deploying topology candidate \"" + this.candidateName + "\" will introduce " + errorDesc + "\nTo deploy anyway, " + "use plan deploy-topology <candidateName> [force]. " + "Use topology validate [<candidate name>] " + "to view violations in the candidate \"" + this.candidateName + "\" and the current, deployed topology.");
        }
    }

    @Override
    public void describeRunning(Formatter fm, List<TaskRun> running, boolean verbose) {
        ArrayList<TaskRun> migrations = new ArrayList<TaskRun>();
        for (TaskRun tRun : running) {
            if (tRun.getTask() instanceof MigratePartition) {
                migrations.add(tRun);
                continue;
            }
            fm.format("   Task %d/%s started at %s\n", tRun.getTaskNum(), tRun.getTask(), FormatUtils.formatDateAndTime(tRun.getStartTime()));
        }
        int numQueued = 0;
        int numRunning = 0;
        int numSucceeded = 0;
        int numFailed = 0;
        int numUnknown = 0;
        long succeededTime = 0L;
        StringBuilder detailBd = new StringBuilder();
        Formatter taskDetailFM = new Formatter(detailBd);
        for (TaskRun m : migrations) {
            Map<String, String> details = m.getDetails();
            PartitionMigrationStatus targetStatus = PartitionMigrationStatus.parseTargetStatus(details);
            if (targetStatus == null) continue;
            if (verbose) {
                PartitionMigrationStatus sourceStatus = PartitionMigrationStatus.parseSourceStatus(details);
                if (sourceStatus != null && sourceStatus.getStartTime() > 0L) {
                    taskDetailFM.format("   Task %d/%s:\n     %s\n     %s\n", m.getTaskNum(), m.getTask(), targetStatus, sourceStatus);
                } else {
                    taskDetailFM.format("   Task %d/%s:\n     %s\n", m.getTaskNum(), m.getTask(), targetStatus);
                }
            }
            switch (targetStatus.getState()) {
                case PENDING: {
                    ++numQueued;
                    break;
                }
                case RUNNING: {
                    ++numRunning;
                    break;
                }
                case SUCCEEDED: {
                    ++numSucceeded;
                    succeededTime += targetStatus.getEndTime() - targetStatus.getStartTime();
                    break;
                }
                case ERROR: {
                    ++numFailed;
                    break;
                }
                case UNKNOWN: {
                    ++numUnknown;
                }
            }
        }
        if (numQueued != 0) {
            fm.format("   %d partition migrations queued\n", numQueued);
        }
        if (numRunning != 0) {
            fm.format("   %d partition migrations running\n", numRunning);
        }
        if (numSucceeded != 0) {
            fm.format("   %d partition migrations succeeded, avg migration time = %d ms.\n", numSucceeded, succeededTime / (long)numSucceeded);
        }
        if (numUnknown != 0) {
            fm.format("   %d partition migrations could not be contacted for status\n", numUnknown);
        }
        if (numFailed != 0) {
            fm.format("   %d partition migrations failed\n", numFailed);
        } else if (numSucceeded > 0) {
            long elapsedMS = System.currentTimeMillis() - this.createTime;
            long elapsedMSPerTask = elapsedMS / (long)numSucceeded;
            long estMSRemaining = (long)(numQueued + numRunning + numUnknown) * elapsedMSPerTask;
            fm.format(StatusReport.STRING_LABEL, "Estimated completion:", FormatUtils.formatDateAndTime(estMSRemaining + System.currentTimeMillis()));
        }
        if (verbose && detailBd.length() > 0) {
            fm.format("%s", detailBd.toString());
        }
        taskDetailFM.close();
    }

    @Override
    public void describeNotStarted(Formatter fm, List<Task> notStarted, boolean verbose) {
        int migrationCount = 0;
        for (Task t : notStarted) {
            boolean showDetail = true;
            if (!verbose && t instanceof MigratePartition) {
                ++migrationCount;
                showDetail = false;
            }
            if (!showDetail) continue;
            fm.format("   Task %s\n", t);
        }
        if (!verbose && migrationCount > 0) {
            fm.format("   %d partition migrations waiting", migrationCount);
        }
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    @Override
    synchronized void incrementEndCount(PlanRun planRun, Task.State state) {
        this.updatingTopo(this.planner.getAdmin().getCurrentTopology());
        super.incrementEndCount(planRun, state);
    }

    @Override
    public boolean updatingMetadata(Metadata<?> metadata) {
        return metadata.getType().equals((Object)Metadata.MetadataType.TOPOLOGY) ? this.updatingTopo((Topology)metadata) : false;
    }

    private boolean updatingTopo(Topology topology) {
        int seqNum = topology.getSequenceNumber();
        if (seqNum <= this.sourceTopoSequence) {
            return false;
        }
        this.sourceTopoSequence = seqNum;
        return true;
    }

    public synchronized void addTaskDetails(Map<String, String> taskRunStatus, Map<String, String> info) {
        taskRunStatus.putAll(info);
    }

    @Override
    void stripForDisplay() {
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysoperPrivList;
    }
}

