/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.SecurityUtils;

@Persistent
public class DeployTableMetadataPlan
extends MetadataPlan<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private static final KVVersion TABLE_SUPPORT_VERSION = KVVersion.R3_0;
    private static final KVVersion TABLE_AUTH_VERSION = KVVersion.R3_3;

    DeployTableMetadataPlan(AtomicInteger idGen, String planName, Planner planner) {
        super(idGen, planName, planner);
        DeployTableMetadataPlan.checkVersion(planner.getAdmin(), TABLE_SUPPORT_VERSION, "Cannot perform plan " + planName + " when not all" + " nodes in the store support table feature.");
    }

    DeployTableMetadataPlan() {
    }

    @Override
    protected Class<TableMetadata> getMetadataClass() {
        return TableMetadata.class;
    }

    @Override
    public Metadata.MetadataType getMetadataType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Deploy Table Metadata";
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public void getCatalogLocks() throws PlanLocksHeldException {
        this.planner.lockElasticity(this.getId(), this.getName());
        this.getPerTaskLocks();
    }

    @Override
    void stripForDisplay() {
    }

    String getRealTableName(String tableName) {
        TableImpl table;
        TableMetadata md = (TableMetadata)this.getMetadata();
        if (md != null && (table = md.getTable(tableName, false)) != null) {
            return table.getFullName();
        }
        return tableName;
    }

    TableImpl getAndCheckTable(String tableName) {
        TableImpl table;
        TableMetadata md = (TableMetadata)this.getMetadata();
        if (md != null && (table = md.getTable(tableName, false)) != null) {
            return table;
        }
        throw new IllegalCommandException("Table does not exist: " + tableName);
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysdbaPrivList;
    }

    static class RemoveIndexPlan
    extends DeployTableMetadataPlan {
        private static final long serialVersionUID = 1L;
        private final ResourceOwner tableOwner;
        private final long tableId;

        RemoveIndexPlan(AtomicInteger idGen, String planName, String tableName, Planner planner) {
            super(idGen, planName, planner);
            TableImpl table = this.getAndCheckTable(tableName);
            this.tableOwner = table.getOwner();
            this.tableId = table.getId();
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            ResourceOwner currentUser = SecurityUtils.currentUserAsOwner();
            if (currentUser != null && currentUser.equals(this.tableOwner)) {
                return SystemPrivilege.usrviewPrivList;
            }
            return Collections.singletonList(new TablePrivilege.DropIndex(this.tableId));
        }
    }

    static class AddIndexPlan
    extends DeployTableMetadataPlan {
        private static final long serialVersionUID = 1L;
        private final ResourceOwner tableOwner;
        private final long tableId;

        AddIndexPlan(AtomicInteger idGen, String planName, String tableName, Planner planner) {
            super(idGen, planName, planner);
            TableImpl table = this.getAndCheckTable(tableName);
            this.tableOwner = table.getOwner();
            this.tableId = table.getId();
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            ResourceOwner currentUser = SecurityUtils.currentUserAsOwner();
            if (currentUser != null && currentUser.equals(this.tableOwner)) {
                return SystemPrivilege.usrviewPrivList;
            }
            return Collections.singletonList(new TablePrivilege.CreateIndex(this.tableId));
        }
    }

    static class EvolveTablePlan
    extends DeployTableMetadataPlan {
        private static final long serialVersionUID = 1L;
        private final ResourceOwner tableOwner;
        private final long tableId;

        EvolveTablePlan(AtomicInteger idGen, String planName, String tableName, Planner planner) {
            super(idGen, planName, planner);
            TableImpl table = this.getAndCheckTable(tableName);
            this.tableOwner = table.getOwner();
            this.tableId = table.getId();
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            ResourceOwner currentUser = SecurityUtils.currentUserAsOwner();
            if (currentUser != null && currentUser.equals(this.tableOwner)) {
                return SystemPrivilege.usrviewPrivList;
            }
            return Collections.singletonList(new TablePrivilege.EvolveTable(this.tableId));
        }
    }

    static class RemoveTablePlan
    extends DeployTableMetadataPlan {
        private static final long serialVersionUID = 1L;
        private final ResourceOwner tableOwner;
        private final long tableId;
        private final String tableName;
        private final boolean toRemoveIndex;

        RemoveTablePlan(AtomicInteger idGen, String planName, String tableName, boolean removeData, Planner planner) {
            super(idGen, planName, planner);
            TableImpl table = this.getAndCheckTable(tableName);
            this.tableOwner = table.getOwner();
            this.tableId = table.getId();
            this.toRemoveIndex = removeData && !table.getIndexes().isEmpty();
            this.tableName = tableName;
        }

        @Override
        public void preExecuteCheck(boolean force, Logger plannerlogger) {
            super.preExecuteCheck(force, plannerlogger);
            this.checkPrivilegesOnTable();
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            ResourceOwner currentUser = SecurityUtils.currentUserAsOwner();
            if (currentUser != null && currentUser.equals(this.tableOwner)) {
                return SystemPrivilege.usrviewPrivList;
            }
            ArrayList<KVStorePrivilege> privsToCheck = new ArrayList<KVStorePrivilege>();
            if (this.toRemoveIndex) {
                privsToCheck.add(new TablePrivilege.DropIndex(this.tableId));
            }
            privsToCheck.add(SystemPrivilege.DROP_ANY_TABLE);
            return privsToCheck;
        }

        void checkPrivilegesOnTable() {
            SecurityMetadata secMd = this.planner.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
            if (secMd == null) {
                return;
            }
            HashSet<String> involvedRoles = new HashSet<String>();
            for (RoleInstance role : secMd.getAllRoles()) {
                for (KVStorePrivilege priv : role.getPrivileges()) {
                    if (!(priv instanceof TablePrivilege) || ((TablePrivilege)priv).getTableId() != this.tableId) continue;
                    involvedRoles.add(role.name());
                }
            }
            if (!involvedRoles.isEmpty()) {
                throw new IllegalCommandException("Cannot drop table " + this.tableName + " since there are " + "privileges defined on it in roles " + involvedRoles + ". Please revoke the privileges explicitly and then try" + " dropping the table again.");
            }
        }
    }

    static class AddTablePlan
    extends DeployTableMetadataPlan {
        private static final long serialVersionUID = 1L;

        AddTablePlan(AtomicInteger idGen, String planName, Planner planner) {
            super(idGen, planName, planner);
            AddTablePlan.checkVersion(planner.getAdmin(), TABLE_AUTH_VERSION, "Cannot add new tables until all nodes in the store have been upgraded to " + TABLE_AUTH_VERSION);
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            return SystemPrivilege.tableCreatePrivList;
        }
    }
}

