/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.DeploySN;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class DeploySNPlan
extends TopologyPlan {
    private static final long serialVersionUID = 1L;
    private StorageNodeParams inputSNP;
    private StorageNodeParams newSNParams;
    private StorageNodeId snId;

    public DeploySNPlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, DatacenterId datacenterId, StorageNodeParams inputSNP) {
        super(idGen, planName, planner, topology);
        boolean isFirst;
        this.inputSNP = inputSNP;
        Datacenter dc = topology.get(datacenterId);
        if (dc == null) {
            throw new IllegalCommandException(datacenterId + " is not a valid Zone id.  " + "Please provide the id of an existing Zone.");
        }
        StorageNode sn = new StorageNode(dc, inputSNP.getHostname(), inputSNP.getRegistryPort());
        this.newSNParams = new StorageNodeParams(inputSNP.getFilteredMap());
        StorageNode alreadyExists = this.alreadyInTopology(sn);
        StorageNode useStorageNode = null;
        if (alreadyExists != null) {
            useStorageNode = alreadyExists;
            this.guardAgainstDifferentParams((StorageNodeId)alreadyExists.getResourceId());
            isFirst = this.getTopology().getStorageNodeMap().size() == 1;
        } else {
            boolean bl = isFirst = topology.getStorageNodeMap().size() == 0;
            if (planner.getAdmin().getAdminCount() == 0 && !isFirst) {
                throw new IllegalCommandException("An Admin service instance must be deployed on the first deployed StorageNode before any further StorageNode deployments can take place.");
            }
            useStorageNode = topology.add(sn);
        }
        this.snId = useStorageNode.getStorageNodeId();
        this.newSNParams.setStorageNodeId(this.snId);
        this.addTask(new DeploySN(this, isFirst));
    }

    private DeploySNPlan() {
    }

    public StorageNodeParams getRegistrationParams() {
        return this.newSNParams;
    }

    @Override
    public String getDefaultName() {
        return "Deploy Storage Node";
    }

    public StorageNodeId getStorageNodeId() {
        return this.snId;
    }

    public StorageNodeParams getInputStorageNodeParams() {
        return this.inputSNP;
    }

    private StorageNode alreadyInTopology(StorageNode newStorageNode) {
        for (StorageNode s : this.getTopology().getStorageNodeMap().getAll()) {
            if (!newStorageNode.propertiesEquals(s)) continue;
            return s;
        }
        return null;
    }

    private void guardAgainstDifferentParams(StorageNodeId existingId) {
        StorageNodeParams existingParams = this.getAdmin().getStorageNodeParams(existingId);
        if (existingParams == null) {
            return;
        }
        ParameterMap existingParamsMapCopy = existingParams.getFilteredMap().copy();
        existingParamsMapCopy.remove("storageNodeId");
        existingParamsMapCopy.remove("comment");
        for (String paramName : StorageNodeParams.REGISTRATION_PARAMS) {
            existingParamsMapCopy.remove(paramName);
        }
        ParameterMap newParamsMapCopy = this.newSNParams.getMap();
        newParamsMapCopy.remove("storageNodeId");
        newParamsMapCopy.remove("comment");
        if (!existingParamsMapCopy.equals(this.newSNParams.getMap())) {
            throw new IllegalCommandException("A storage node on " + existingParams.getHostname() + ":" + existingParams.getRegistryPort() + " already " + "exists, but has different parameters. The " + "storage node can't be deployed again unless the " + "parameters are identical. Existing parameters:\n" + existingParamsMapCopy.showContents(true) + "New parameters:\n" + newParamsMapCopy.showContents(true));
        }
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    void stripForDisplay() {
        super.stripForDisplay();
        this.inputSNP = null;
        this.newSNParams = null;
    }
}

