/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.DeployAdmin;
import oracle.kv.impl.admin.plan.task.NewAdminParameters;
import oracle.kv.impl.admin.plan.task.UpdateAdminHelperHost;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent(version=1)
public class DeployAdminPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private int httpPort;
    AdminParams targetAP;

    public DeployAdminPlan(AtomicInteger idGen, String name, Planner planner, StorageNodeId snid, int httpPort, AdminType type) {
        super(idGen, name, planner);
        Admin admin = planner.getAdmin();
        this.httpPort = httpPort;
        Topology topo = admin.getCurrentTopology();
        StorageNode sn = topo.get(snid);
        if (sn == null) {
            throw new IllegalCommandException(snid + " is not a valid Storage Node id.  " + "Please provide the id of an existing Storage Node.");
        }
        type = this.computeAdminType(type, topo, snid);
        this.targetAP = this.findExistingParams(admin, snid, type);
        AdminId newAdminId = null;
        if (this.targetAP == null) {
            newAdminId = admin.generateAdminId();
            ParameterMap pMap = admin.copyPolicy();
            this.targetAP = new AdminParams(pMap, newAdminId, snid, httpPort, type);
            this.removeSomePolicyParams(this.targetAP.getMap());
        } else {
            newAdminId = this.targetAP.getAdminId();
        }
        this.addTask(new DeployAdmin(this, snid, newAdminId));
        Parameters parameters = admin.getCurrentParameters();
        for (AdminParams ap : parameters.getAdminParams()) {
            AdminId aid = ap.getAdminId();
            StorageNodeParams snp = parameters.get(ap.getStorageNodeId());
            String hostname = snp.getHostname();
            int registryPort = snp.getRegistryPort();
            this.addTask(new UpdateAdminHelperHost(this, aid));
            this.addTask(new NewAdminParameters(this, hostname, registryPort, aid));
        }
    }

    private AdminType computeAdminType(AdminType type, Topology topo, StorageNodeId snId) {
        if (type != null) {
            return type;
        }
        DatacenterType dcType = topo.getDatacenter(snId).getDatacenterType();
        return Utils.getAdminType(dcType);
    }

    private AdminParams findExistingParams(Admin admin, StorageNodeId snid, AdminType type) {
        Parameters parameters = admin.getCurrentParameters();
        boolean primaryConfigured = type.isPrimary();
        AdminParams existingAP = null;
        for (AdminId aid : parameters.getAdminIds()) {
            AdminParams ap = parameters.get(aid);
            if (snid.equals(ap.getStorageNodeId())) {
                if (existingAP != null) {
                    throw new NonfatalAssertionException("More than one admin service exists on " + snid + ". " + existingAP.getAdminId() + "[" + existingAP.getHttpPort() + "] and " + ap.getAdminId() + " [" + ap.getHttpPort() + "]");
                }
                if (this.httpPort != ap.getHttpPort()) {
                    throw new IllegalCommandException(ap.getAdminId() + " is already configured with " + "httpPort" + ap.getHttpPort() + " and cannot be " + "configured for " + this.httpPort);
                }
                if (!ap.getType().equals((Object)type)) {
                    throw new IllegalCommandException("Attempting to change " + aid + " from " + (Object)((Object)ap.getType()) + " to " + (Object)((Object)type));
                }
                existingAP = ap;
            }
            if (!ap.getType().isPrimary()) continue;
            primaryConfigured = true;
        }
        if (!primaryConfigured) {
            throw new IllegalCommandException("No primary Admin configured");
        }
        return existingAP;
    }

    private void removeSomePolicyParams(ParameterMap map) {
        map.remove("cacheSize");
        map.remove("configProperties");
        map.remove("javaMiscParams");
    }

    private DeployAdminPlan() {
    }

    @Override
    public void preExecutionSave() {
        Admin admin = this.getAdmin();
        Parameters p = admin.getCurrentParameters();
        if (p.get(this.targetAP.getAdminId()) == null) {
            admin.addAdminParams(this.targetAP);
        }
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public String getDefaultName() {
        return "Deploy Admin Service";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    void stripForDisplay() {
        this.targetAP = null;
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysoperPrivList;
    }
}

