/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.NewAdminGlobalParameters;
import oracle.kv.impl.admin.plan.task.NewRNGlobalParameters;
import oracle.kv.impl.admin.plan.task.WriteNewGlobalParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.VersionUtil;

@Persistent
public class ChangeGlobalSecurityParamsPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private static final KVVersion SECURITY_VERSION = KVVersion.R3_0;
    private ParameterMap newParams = null;
    private Parameters currentParams;
    private static final Set<AdminId> allAdminIds = new HashSet<AdminId>();

    public ChangeGlobalSecurityParamsPlan(AtomicInteger idGenerator, String name, Planner planner, Topology topology, ParameterMap map) {
        super(idGenerator, name, planner);
        this.checkSecurityVersion();
        this.newParams = map;
        Admin admin = planner.getAdmin();
        this.currentParams = admin.getCurrentParameters();
        allAdminIds.addAll(this.currentParams.getAdminIds());
        ParameterMap filtered = this.newParams.readOnlyFilter().filter(EnumSet.of(ParameterState.Info.GLOBAL, ParameterState.Info.SECURITY));
        GlobalParams currentGlobalParams = this.currentParams.getGlobalParams();
        boolean needsRestart = filtered.hasRestartRequiredDiff(currentGlobalParams.getMap());
        if (needsRestart) {
            throw new NonfatalAssertionException("Parameter change would require an admin restart, which is not supported.");
        }
        List<StorageNodeId> snIds = topology.getStorageNodeIds();
        for (StorageNodeId snId : snIds) {
            this.addTask(new WriteNewGlobalParams(this, filtered, snId, false));
            this.addNewGlobalParametersTasks(snId, topology);
        }
    }

    private ChangeGlobalSecurityParamsPlan() {
    }

    private void addNewGlobalParametersTasks(StorageNodeId snId, Topology topo) {
        Set<RepNodeId> refreshRns = topo.getHostedRepNodeIds(snId);
        for (RepNodeId rnid : refreshRns) {
            this.addTask(new NewRNGlobalParameters(this, rnid));
        }
        for (AdminId aid : allAdminIds) {
            StorageNodeId sidForAdmin = this.currentParams.get(aid).getStorageNodeId();
            if (!sidForAdmin.equals(snId)) continue;
            StorageNodeParams snp = this.currentParams.get(sidForAdmin);
            String hostname = snp.getHostname();
            int registryPort = snp.getRegistryPort();
            this.addTask(new NewAdminGlobalParameters(this, hostname, registryPort, aid));
        }
    }

    private void checkSecurityVersion() {
        Admin admin = this.planner.getAdmin();
        KVVersion storeVersion = admin.getStoreVersion();
        if (VersionUtil.compareMinorVersion(storeVersion, SECURITY_VERSION) < 0) {
            throw new IllegalCommandException("Cannot perform security metadata related operations when not all nodes in the store support security feature. The highest version supported by all nodes is " + storeVersion.getNumericVersionString() + ", but security metadata operations require version " + SECURITY_VERSION.getNumericVersionString() + " or later.");
        }
    }

    @Override
    public String getDefaultName() {
        return "Change Global Security Params";
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    void stripForDisplay() {
        this.newParams = null;
        this.currentParams = null;
    }

    @Override
    public List<? extends KVStorePrivilege> getRequiredPrivileges() {
        return SystemPrivilege.sysoperPrivList;
    }
}

