/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.persist.model.Persistent;
import java.io.File;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.StringTokenizer;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class RepNodeParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARALLEL_GC_FLAG = "-XX:ParallelGCThreads=";
    public static final String XMS_FLAG = "-Xms";
    public static final String XMX_FLAG = "-Xmx";
    private ParameterMap map;

    public RepNodeParams() {
    }

    public RepNodeParams(ParameterMap map) {
        this.map = map;
    }

    public RepNodeParams(RepNodeParams rnp) {
        this(rnp.getMap().copy());
    }

    public RepNodeParams(StorageNodeId snid, RepNodeId repNodeId, boolean disabled, String haHostname, int haPort, String helperHostname, int helperPort, String mountPoint, NodeType nodeType) {
        this(snid, repNodeId, disabled, haHostname, haPort, HostPortPair.getString((String)helperHostname, (int)helperPort), mountPoint, nodeType);
    }

    public RepNodeParams(StorageNodeId snid, RepNodeId repNodeId, boolean disabled, String haHostname, int haPort, String helperHosts, String mountPoint, NodeType nodeType) {
        this.init(new ParameterMap(), snid, repNodeId, disabled, haHostname, haPort, helperHosts, mountPoint, nodeType);
    }

    public RepNodeParams(ParameterMap map, StorageNodeId snid, RepNodeId repNodeId, boolean disabled, String haHostname, int haPort, String helperHosts, String mountPoint, NodeType nodeType) {
        this.init(map, snid, repNodeId, disabled, haHostname, haPort, helperHosts, mountPoint, nodeType);
    }

    private void init(ParameterMap newmap, StorageNodeId snid, RepNodeId repNodeId, boolean disabled, String haHostname, int haPort, String helperHosts, String mountPoint, NodeType nodeType) {
        this.map = newmap.filter(EnumSet.of(ParameterState.Info.REPNODE));
        this.setStorageNodeId(snid);
        this.setRepNodeId(repNodeId);
        this.setDisabled(disabled);
        this.setJENodeHostPort(HostPortPair.getString((String)haHostname, (int)haPort));
        this.setJEHelperHosts(helperHosts);
        this.addDefaults();
        this.map.setName(repNodeId.getFullName());
        this.map.setType("repNodeParams");
        this.setMountPoint(mountPoint);
        this.setNodeType(nodeType);
    }

    public ParameterMap getMap() {
        return this.map;
    }

    private void addDefaults() {
        this.map.addServicePolicyDefaults(ParameterState.Info.REPNODE);
    }

    public RepNodeId getRepNodeId() {
        return RepNodeId.parse(this.map.get("repNodeId").asString());
    }

    public void setRepNodeId(RepNodeId rnid) {
        this.map.setParameter("repNodeId", rnid.getFullName());
    }

    public StorageNodeId getStorageNodeId() {
        return new StorageNodeId(this.map.get("storageNodeId").asInt());
    }

    public void setStorageNodeId(StorageNodeId snId) {
        this.map.setParameter("storageNodeId", Integer.toString(snId.getStorageNodeId()));
    }

    public File getMountPoint() {
        if (this.map.exists("rnMountPoint")) {
            return new File(this.map.get("rnMountPoint").asString());
        }
        return null;
    }

    public String getMountPointString() {
        if (this.map.exists("rnMountPoint")) {
            return this.map.get("rnMountPoint").asString();
        }
        return null;
    }

    public void setMountPoint(String mountPoint) {
        this.map.setParameter("rnMountPoint", mountPoint);
    }

    public void setDisabled(boolean disabled) {
        this.map.setParameter("disabled", Boolean.toString(disabled));
    }

    public boolean isDisabled() {
        return this.map.get("disabled").asBoolean();
    }

    public long getJECacheSize() {
        return this.map.get("cacheSize").asLong();
    }

    public void setJECacheSize(long size) {
        this.map.setParameter("cacheSize", Long.toString(size));
    }

    public void setRNHeapAndJECache(StorageNodeParams.RNHeapAndCacheSize heapAndCache) {
        this.setJavaMiscParams(this.replaceOrRemoveJVMArg(this.getJavaMiscParams(), XMS_FLAG, heapAndCache.getHeapValAndUnit()));
        this.setJavaMiscParams(this.replaceOrRemoveJVMArg(this.getJavaMiscParams(), XMX_FLAG, heapAndCache.getHeapValAndUnit()));
        this.setJECacheSize(heapAndCache.getCacheBytes());
    }

    public CacheMode getJECacheMode() {
        return (CacheMode)this.map.get("cacheMode").asEnum();
    }

    public void setJECacheMode(CacheMode mode) {
        this.map.setParameter("cacheMode", mode.toString());
    }

    public long getMaxHeapMB() {
        long hb = this.getMaxHeapBytes(false);
        if (hb == 0L) {
            return 0L;
        }
        long heapMB = hb >> 20;
        return heapMB < 0L ? 0L : heapMB;
    }

    private long getMaxHeapBytes(boolean inTargetJVM) {
        if (inTargetJVM) {
            return Runtime.getRuntime().maxMemory();
        }
        String jvmArgs = this.map.getOrDefault("javaMiscParams").asString();
        return RepNodeParams.parseJVMArgsForHeap(XMX_FLAG, jvmArgs);
    }

    public long getMinHeapMB() {
        String jvmArgs = this.map.getOrDefault("javaMiscParams").asString();
        long minHeap = RepNodeParams.parseJVMArgsForHeap(XMS_FLAG, jvmArgs);
        if (minHeap == 0L) {
            return 0L;
        }
        return minHeap >> 20;
    }

    public static long parseJVMArgsForHeap(String prefix, String jvmArgs) {
        String heapVal = RepNodeParams.parseJVMArgsForPrefix(prefix, jvmArgs);
        if (heapVal == null) {
            return 0L;
        }
        long size = RepNodeParams.findHeapNum(heapVal, "g");
        if (size != 0L) {
            return size << 30;
        }
        size = RepNodeParams.findHeapNum(heapVal, "m");
        if (size != 0L) {
            return size << 20;
        }
        size = RepNodeParams.findHeapNum(heapVal, "k");
        if (size != 0L) {
            return size << 10;
        }
        return Long.parseLong(heapVal);
    }

    public static String parseJVMArgsForPrefix(String prefix, String jvmArgs) {
        if (jvmArgs == null) {
            return null;
        }
        String[] args = jvmArgs.split(prefix);
        if (args.length < 2) {
            return null;
        }
        String lastArg = args[args.length - 1];
        String[] lastVal = lastArg.split(" ");
        if (lastVal[0].isEmpty()) {
            return null;
        }
        return lastVal[0].toLowerCase();
    }

    public String replaceOrRemoveJVMArg(String targetJavaMiscParams, String prefix, String newArg) {
        StringTokenizer tokenizer = new StringTokenizer(targetJavaMiscParams);
        StringBuilder result = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String arg = tokenizer.nextToken();
            if (arg.startsWith(prefix)) continue;
            result.append(arg).append(" ");
        }
        if (newArg == null) {
            return result.toString();
        }
        return result.toString() + " " + prefix + newArg;
    }

    private static long findHeapNum(String lastArg, String unit) {
        int unitIndex = lastArg.indexOf(unit);
        if (unitIndex == -1) {
            return 0L;
        }
        return Long.parseLong(lastArg.substring(0, unitIndex));
    }

    public boolean getNRConfigRetainLogFiles() {
        return this.map.getOrDefault("rnNRConfigRetainLogFiles").asBoolean();
    }

    public int getMaxTopoChanges() {
        return this.map.getOrDefault("rnMaxTopoChanges").asInt();
    }

    public void validateCacheAndHeap(boolean inTargetJVM) {
        long minHeapMB;
        long actualMemory;
        long specHeap;
        double maxPercent = 0.9;
        long maxHeapMB = this.getMaxHeapMB();
        if (inTargetJVM && (specHeap = maxHeapMB >> 20) > (actualMemory = Runtime.getRuntime().maxMemory())) {
            throw new IllegalArgumentException("Specified maximum heap of " + maxHeapMB + "MB exceeds available JVM memory of " + actualMemory + ", see JVM parameters:" + this.getJavaMiscParams());
        }
        long maxHeapBytes = this.getMaxHeapBytes(inTargetJVM);
        if (maxHeapBytes > 0L && this.getJECacheSize() > 0L) {
            this.checkMinSizes(maxHeapBytes, (int)(this.getJECacheSize() / 0x100000L));
            if ((double)this.getJECacheSize() / (double)maxHeapBytes > 0.9) {
                String msg = "Parameter cacheSize (" + this.getJECacheSize() + ") may not exceed 90% of " + "available Java heap space (" + maxHeapBytes + ")";
                throw new IllegalArgumentException(msg);
            }
        }
        if ((minHeapMB = this.getMinHeapMB()) > maxHeapMB) {
            throw new IllegalArgumentException("Mininum heap of " + minHeapMB + " exceeds maximum heap of " + maxHeapMB + ", see JVM parameters:" + this.getJavaMiscParams());
        }
    }

    private void checkMinSizes(long heapBytes, int cacheMB) {
        if (heapBytes >> 20 < 32L) {
            String msg = "JVM heap must be at least 32 MB, specified value is " + (heapBytes >> 20) + " MB";
            throw new IllegalArgumentException(msg);
        }
        if (cacheMB < 22) {
            String msg = "Cache size must be at least 22 MB, specified value is " + cacheMB + " MB";
            throw new IllegalArgumentException(msg);
        }
    }

    public int getRequestQuiesceMs() {
        long quiesceMs = ParameterUtils.getDurationMillis(this.map, "requestQuiesceTime");
        return quiesceMs > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)quiesceMs;
    }

    public boolean getCollectEnvStats() {
        return this.map.get("collectEnvStats").asBoolean();
    }

    public int getHAPort() {
        return HostPortPair.getPort((String)this.getJENodeHostPort());
    }

    public String getJENodeHostPort() {
        return this.map.get("nodeHostPort").asString();
    }

    public String getJEHelperHosts() {
        return this.map.get("helperHosts").asString();
    }

    public RMISocketPolicy.SocketFactoryPair getRHSFP(RMISocketPolicy rmiPolicy, String servicePortRange, String csfName, String kvStoreName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("rnRHSOBacklog").asInt()).setSsfPortRange(servicePortRange).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnRHSOConnectTimeout")).setCsfReadTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnRHSOReadTimeout")).setKvStoreName(kvStoreName);
        return rmiPolicy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getAdminSFP(RMISocketPolicy rmiPolicy, String servicePortRange, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.ADMIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("rnAdminSOBacklog").asInt()).setSsfPortRange(servicePortRange).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnAdminSOConnectTimeout")).setCsfReadTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnAdminSOReadTimeout"));
        return rmiPolicy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getLoginSFP(RMISocketPolicy policy, String servicePortRange, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.LOGIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("rnLoginSOBacklog").asInt()).setSsfPortRange(servicePortRange).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnLoginSOConnectTimeout")).setCsfReadTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnLoginSOReadTimeout"));
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getMonitorSFP(RMISocketPolicy rmiPolicy, String servicePortRange, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.MONITOR.interfaceName()).setSsfBacklog(this.map.getOrDefault("rnMonitorSOBacklog").asInt()).setSsfPortRange(servicePortRange).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnMonitorSOConnectTimeout")).setCsfReadTimeout((int)ParameterUtils.getDurationMillis(this.map, "rnMonitorSOReadTimeout"));
        return rmiPolicy.getBindPair(args);
    }

    public boolean getUseClientSocketFactory() {
        return !ClientSocketFactory.isDisabled() && this.map.exists("useClientSocketFactories") ? this.map.get("useClientSocketFactories").asBoolean() : false;
    }

    public void setJENodeHostPort(String nodeHostPort) {
        this.map.setParameter("nodeHostPort", nodeHostPort);
    }

    public void setJEHelperHosts(String helperHost) {
        this.map.setParameter("helperHosts", helperHost);
    }

    public int getConcurrentSourceLimit() {
        return this.map.getOrDefault("rnPMConcurrentSourceLimit").asInt();
    }

    public int getConcurrentTargetLimit() {
        return this.map.getOrDefault("rnPMConcurrentTargetLimit").asInt();
    }

    public long getWaitAfterBusy() {
        return ParameterUtils.getDurationMillis(this.map, "rnPMWaitAfterBusy");
    }

    public long getWaitAfterError() {
        return ParameterUtils.getDurationMillis(this.map, "rnPMWaitAfterError");
    }

    public int getReadWriteTimeout() {
        return (int)ParameterUtils.getDurationMillis(this.map, "rnPMSOReadWriteTimeout");
    }

    public int getConnectTImeout() {
        return (int)ParameterUtils.getDurationMillis(this.map, "rnPMSOConnectTimeout");
    }

    public int getActiveThreshold() {
        return this.map.get("activeThreshold").asInt();
    }

    public String getLoggingConfigProps() {
        return this.map.get("loggingConfigProps").asString();
    }

    public String getJavaMiscParams() {
        return this.map.getOrDefault("javaMiscParams").asString();
    }

    public void setJavaMiscParams(String misc) {
        this.map.setParameter("javaMiscParams", misc);
    }

    public int getMaxTrackedLatency() {
        return (int)ParameterUtils.getDurationMillis(this.map, "maxTrackedLatency");
    }

    public int getStatsInterval() {
        return (int)ParameterUtils.getDurationMillis(this.map, "statsInterval");
    }

    public String getConfigProperties() {
        return this.map.get("configProperties").asString();
    }

    public boolean getMasterBalance() {
        return this.map.getOrDefault("masterBalance").asBoolean();
    }

    public void setMasterBalance(boolean masterBalance) {
        this.map.setParameter("masterBalance", masterBalance ? "true" : "false");
    }

    public void setLatencyCeiling(int ceiling) {
        this.map.setParameter("latencyCeiling", Integer.toString(ceiling));
    }

    public int getLatencyCeiling() {
        return this.map.getOrZeroInt("latencyCeiling");
    }

    public void setThroughputFloor(int floor) {
        this.map.setParameter("throughputFloor", Integer.toString(floor));
    }

    public int getThroughputFloor() {
        return this.map.getOrZeroInt("throughputFloor");
    }

    public void setCommitLagThreshold(long threshold) {
        this.map.setParameter("commitLagThreshold", Long.toString(threshold));
    }

    public long getCommitLagThreshold() {
        return this.map.getOrZeroLong("commitLagThreshold");
    }

    public int getRNCachePercent() {
        return this.map.getOrZeroInt("rnCachePercent");
    }

    public int getParallelGCThreads() {
        String jvmArgs = this.getJavaMiscParams();
        String val = RepNodeParams.parseJVMArgsForPrefix(PARALLEL_GC_FLAG, jvmArgs);
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public void setParallelGCThreads(int gcThreads) {
        String newVal = gcThreads == 0 ? null : Integer.toString(gcThreads);
        this.setJavaMiscParams(this.replaceOrRemoveJVMArg(this.getJavaMiscParams(), PARALLEL_GC_FLAG, newVal));
    }

    public NodeType getNodeType() {
        return NodeType.valueOf((String)this.map.getOrDefault("rnNodeType").asString());
    }

    public void setNodeType(NodeType nodeType) {
        this.map.setParameter("rnNodeType", nodeType.name());
    }

    public void setSessionLimit(String value) {
        this.map.setParameter("sessionLimit", value);
    }

    public int getSessionLimit() {
        return this.map.getOrDefault("sessionLimit").asInt();
    }

    public void setLoginCacheSize(String value) {
        this.map.setParameter("loginCacheSize", value);
    }

    public int getLoginCacheSize() {
        return this.map.getOrDefault("loginCacheSize").asInt();
    }

    public String toString() {
        return this.map.toString();
    }
}

