/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandUtils;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

abstract class SharedCommandWithSubs
extends CommandWithSubs {
    protected SharedCommandWithSubs(List<? extends CommandWithSubs.SubCommand> subCommands, String name, int prefixLength, int minArgCount) {
        super(subCommands, name, prefixLength, minArgCount);
    }

    static abstract class SharedSubCommand
    extends CommandWithSubs.SubCommand {
        protected SharedSubCommand(String name, int prefixLength) {
            super(name, prefixLength);
        }

        protected void validateRepNodes(CommandServiceAPI cs, Set<RepNodeId> rnids) throws RemoteException, ShellException {
            for (RepNodeId rnid : rnids) {
                CommandUtils.ensureRepNodeExists(rnid, cs, this);
            }
        }

        protected int parseInt(String idString, String msg) throws ShellException {
            try {
                return Integer.parseInt(idString);
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException(msg + ": " + idString, this);
            }
        }

        protected StorageNodeId parseSnid(String idString) throws ShellException {
            try {
                return StorageNodeId.parse(idString);
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException("Invalid storage node ID: " + idString, this);
            }
        }

        protected DatacenterId parseDatacenterId(String idString) throws ShellException {
            try {
                return DatacenterId.parse(idString);
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException("Invalid zone ID: " + idString, this);
            }
        }

        protected RepNodeId parseRnid(String idString) throws ShellException {
            try {
                return RepNodeId.parse(idString);
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException("Invalid RepNode ID: " + idString, this);
            }
        }

        protected AdminId parseAdminid(String idString) throws ShellException {
            try {
                return AdminId.parse(idString);
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException("Invalid Admin ID: " + idString, this);
            }
        }

        protected DatacenterType parseDatacenterType(String string) throws ShellException {
            try {
                return DatacenterType.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                throw new ShellUsageException("Invalid zone type: " + string, this);
            }
        }
    }
}

