/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.admin.client.ShowCommand;
import oracle.kv.impl.api.avro.AvroDdl;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.avro.AvroSchemaStatus;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import org.apache.avro.Schema;

class DdlCommand
extends CommandWithSubs {
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new DdlAddSub(), new DdlEnableSub(), new DdlDisableSub());

    DdlCommand() {
        super(subs, "ddl", 3, 3);
    }

    @Override
    protected String getCommandOverview() {
        return "Encapsulates operations that manipulate schemas in the store.";
    }

    protected static AvroSchemaMetadata makeAvroSchemaMetadata(AvroSchemaStatus status) {
        return new AvroSchemaMetadata(status, System.currentTimeMillis(), DdlCommand.getAdminUser(), DdlCommand.getAdminMachine());
    }

    protected static String getAdminUser() {
        return "";
    }

    protected static String getAdminMachine() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    private static abstract class DdlEnableDisableSub
    extends CommandWithSubs.SubCommand {
        private final boolean isEnable;

        protected DdlEnableDisableSub(String name, int prefixMatchLength, boolean isEnable) {
            super(name, prefixMatchLength);
            this.isEnable = isEnable;
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String schemaName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    schemaName = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (schemaName == null) {
                shell.requiredArg("-name", this);
            }
            try {
                AvroSchemaStatus status = this.isEnable ? AvroSchemaStatus.ACTIVE : AvroSchemaStatus.DISABLED;
                int id = ShowCommand.ShowSchemas.parseSchemaNameAndId(schemaName, true, cs, this);
                boolean updated = cs.updateSchemaStatus(id, DdlCommand.makeAvroSchemaMetadata(status));
                return (updated ? "Status updated to " : "Status was already ") + (Object)((Object)status);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }
    }

    private static class DdlDisableSub
    extends DdlEnableDisableSub {
        private DdlDisableSub() {
            super("disable-schema", 3, false);
        }

        @Override
        protected String getCommandSyntax() {
            return "ddl disable-schema -name <name>.<ID>";
        }

        @Override
        protected String getCommandDescription() {
            return "Disables an existing schema";
        }
    }

    private static class DdlEnableSub
    extends DdlEnableDisableSub {
        private DdlEnableSub() {
            super("enable-schema", 3, true);
        }

        @Override
        protected String getCommandSyntax() {
            return "ddl enable-schema -name <name>.<ID>";
        }

        @Override
        protected String getCommandDescription() {
            return "Enables an existing, previously disabled schema";
        }
    }

    private static class DdlAddSub
    extends CommandWithSubs.SubCommand {
        private DdlAddSub() {
            super("add-schema", 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String fileName = null;
            String schemaString = null;
            boolean evolve = false;
            boolean force = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    fileName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-string".equals(arg)) {
                    schemaString = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-evolve".equals(arg)) {
                    evolve = true;
                    continue;
                }
                if ("-force".equals(arg)) {
                    force = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (fileName == null && schemaString == null) {
                shell.requiredArg("-file|-string", this);
            }
            try {
                String schemaName;
                if (schemaString == null) {
                    BufferedReader reader;
                    try {
                        reader = new BufferedReader(new FileReader(fileName));
                    }
                    catch (FileNotFoundException e) {
                        return "File not found: " + fileName;
                    }
                    try {
                        StringBuilder schemaText = new StringBuilder((int)new File(fileName).length());
                        while (true) {
                            String line;
                            try {
                                line = reader.readLine();
                            }
                            catch (IOException e) {
                                String string = "Unable to read file (" + e.getMessage() + ")";
                                try {
                                    reader.close();
                                    return string;
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                return string;
                            }
                            if (line == null) {
                                schemaString = schemaText.toString();
                                break;
                            }
                            schemaText.append(line).append(eol);
                        }
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                try {
                    Schema schema = new Schema.Parser().parse(schemaString);
                    schemaName = schema.getFullName();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                AvroSchemaMetadata metadata = DdlCommand.makeAvroSchemaMetadata(AvroSchemaStatus.ACTIVE);
                try {
                    AvroDdl.AddSchemaOptions options = new AvroDdl.AddSchemaOptions(evolve, force);
                    AvroDdl.AddSchemaResult result = cs.addSchema(metadata, schemaString, options);
                    String resultMsg = "Added schema: " + schemaName + "." + result.getId();
                    String extraMsg = result.getExtraMessage();
                    if (extraMsg == null) return resultMsg;
                    if (extraMsg.length() <= 0) return resultMsg;
                    return resultMsg + eol + extraMsg;
                }
                catch (AdminFaultException afe) {
                    shell.handleUnknownException("Failed to add schema", afe);
                    return "";
                }
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
            }
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "ddl add-schema <-file <file> | -string <schema string>>" + eolt + "[-evolve] [-force]";
        }

        @Override
        protected String getCommandDescription() {
            return "Adds a new schema or changes (evolves) an existing schema with the same" + eolt + "name.  The -evolve flag is used " + "to indicate that the schema is changing." + eolt + "The " + "-force flag adds the schema in spite of evolution warnings.";
        }
    }
}

