/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.Snapshot;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class SnapshotOperationProxy {
    private final Topology topo;
    private final RegistryUtils ru;
    private final Logger logger;

    public SnapshotOperationProxy(Admin admin) {
        assert (admin != null);
        this.topo = admin.getCurrentTopology();
        this.ru = new RegistryUtils(this.topo, admin.getLoginManager());
        this.logger = admin.getLogger();
    }

    private StorageNodeAgentAPI getStorageNodeAgent(StorageNodeId snid) {
        Exception e = null;
        this.logger.fine("Trying to contact storage node " + snid + " for snapshot operation");
        try {
            return this.ru.getStorageNodeAgent(snid);
        }
        catch (ConnectException ce) {
            e = ce;
        }
        catch (RemoteException re) {
            e = re;
        }
        catch (NotBoundException nbe) {
            e = nbe;
        }
        String errMsg = "Cannot contact storage node " + snid + ": " + e.getMessage();
        this.logger.fine(errMsg);
        throw new SNAUnavailableException(errMsg);
    }

    private StorageNodeAgentAPI getStorageNodeAgent() {
        SNAUnavailableException e = null;
        List<StorageNode> storageNodes = this.topo.getSortedStorageNodes();
        StorageNodeAgentAPI snai = null;
        for (StorageNode sn : storageNodes) {
            try {
                snai = this.getStorageNodeAgent((StorageNodeId)sn.getResourceId());
                this.logger.info("Snapshot operation using storage node: " + sn.getResourceId());
                break;
            }
            catch (SNAUnavailableException snaue) {
                e = snaue;
            }
        }
        if (snai == null && e != null) {
            throw e;
        }
        return snai;
    }

    public String[] listSnapshots(StorageNodeId snid) {
        String snStr = snid != null ? snid.toString() : "";
        this.logger.info("List snapshots from storage node " + snStr);
        try {
            StorageNodeAgentAPI snai = snid == null ? this.getStorageNodeAgent() : this.getStorageNodeAgent(snid);
            return snai.listSnapshots();
        }
        catch (Exception e) {
            this.logger.info("Failed to list shapshots from storage node " + snStr + ": " + e);
            throw new IllegalCommandException("Cannot list snapshots from storage node " + snStr + ": " + e.getMessage(), e);
        }
    }

    public Snapshot.SnapResult executeSnapshotOp(Snapshot.SnapshotOperation sop, StorageNodeId snid, ResourceId rid, String sname) {
        try {
            StorageNodeAgentAPI snai = this.getStorageNodeAgent(snid);
            if (sop == Snapshot.SnapshotOperation.CREATE) {
                if (rid instanceof RepNodeId) {
                    snai.createSnapshot((RepNodeId)rid, sname);
                } else {
                    snai.createSnapshot((AdminId)rid, sname);
                }
            } else if (sop == Snapshot.SnapshotOperation.REMOVE) {
                if (rid instanceof RepNodeId) {
                    snai.removeSnapshot((RepNodeId)rid, sname);
                } else {
                    snai.removeSnapshot((AdminId)rid, sname);
                }
            } else if (rid instanceof RepNodeId) {
                snai.removeAllSnapshots((RepNodeId)rid);
            } else {
                snai.removeAllSnapshots((AdminId)rid);
            }
            this.logger.info("Snapshot operation " + (Object)((Object)sop) + " of " + sname + " on " + snid + " for " + rid + " succeeded.");
            return new Snapshot.SnapResult(sop, true, rid, null, "Succeeded");
        }
        catch (Exception e) {
            this.logger.info("Snapshot operation " + (Object)((Object)sop) + " of " + sname + " failed on " + snid + " for " + rid + ": " + e.getMessage());
            return new Snapshot.SnapResult(sop, false, rid, new SnapshotFaultException(e), "Failed");
        }
    }

    private static class SnapshotFaultException
    extends InternalFaultException {
        private static final long serialVersionUID = 1L;

        private SnapshotFaultException(Throwable cause) {
            super(cause);
        }
    }

    private static class SNAUnavailableException
    extends NonfatalAssertionException {
        private static final long serialVersionUID = 1L;

        private SNAUnavailableException(String msg) {
            super(msg);
        }
    }
}

