/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.DdlHandler;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public abstract class SecurityDdlOperation
implements DdlHandler.DdlOperation {
    final String opName;

    SecurityDdlOperation(String opName) {
        this.opName = opName;
    }

    @Override
    public OperationContext getOperationCtx() {
        return new OperationContext(){

            @Override
            public String describe() {
                return SecurityDdlOperation.this.opName;
            }

            @Override
            public List<? extends KVStorePrivilege> getRequiredPrivileges() {
                return SecurityDdlOperation.this.privilegesToCheck();
            }
        };
    }

    @Override
    public void perform(DdlHandler ddlHandler) {
        try {
            this.execute(ddlHandler);
        }
        catch (IllegalCommandException ice) {
            ddlHandler.operationFails(this.opName + " failed for: " + ice.getMessage());
        }
    }

    abstract void execute(DdlHandler var1);

    abstract List<? extends KVStorePrivilege> privilegesToCheck();

    public static class ShowRole
    extends SecurityDdlOperation {
        private final String roleName;
        private final boolean asJson;

        public ShowRole(String roleName, boolean asJson) {
            super("ShowRole");
            this.roleName = roleName;
            this.asJson = asJson;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            String roleInfoStr;
            Admin admin = ddlHandler.getAdmin();
            Map<String, RoleInstance.RoleDescription> roleDescMap = this.getRoleInfo(admin);
            if (roleDescMap == null || roleDescMap.isEmpty()) {
                roleInfoStr = this.asJson ? "{}" : "";
            } else {
                if (this.roleName != null && roleDescMap.get(this.roleName) == null) {
                    throw new IllegalCommandException("Role with name of " + this.roleName + " not found");
                }
                roleInfoStr = this.formatRoleInfo(roleDescMap);
            }
            ddlHandler.setResultString(roleInfoStr);
            ddlHandler.operationSucceeds();
        }

        private Map<String, RoleInstance.RoleDescription> getRoleInfo(Admin admin) {
            SecurityMetadata md = admin.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
            if (md == null) {
                return SecurityMetadata.getBuiltInRoleInfo();
            }
            return md.getRolesDescription();
        }

        private String formatRoleInfo(Map<String, RoleInstance.RoleDescription> roleDescMap) {
            StringBuilder sb = new StringBuilder();
            if (this.asJson) {
                if (this.roleName != null) {
                    sb.append(roleDescMap.get(this.roleName).detailsAsJSON());
                } else {
                    boolean first = true;
                    sb.append("{\"roles\":[");
                    for (RoleInstance.RoleDescription desc : roleDescMap.values()) {
                        if (!first) {
                            sb.append(",");
                        }
                        first = false;
                        sb.append(desc.briefAsJSON());
                    }
                    sb.append("]}");
                }
            } else if (this.roleName != null) {
                sb.append(roleDescMap.get(this.roleName).details());
            } else {
                for (RoleInstance.RoleDescription desc : roleDescMap.values()) {
                    sb.append("role:");
                    sb.append(desc.brief());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.usrviewPrivList;
        }
    }

    public static class ShowUser
    extends SecurityDdlOperation {
        private final String userName;
        private final boolean asJson;

        public ShowUser(String userName, boolean asJson) {
            super("ShowUser");
            this.userName = userName;
            this.asJson = asJson;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            String userInfoStr;
            Admin admin = ddlHandler.getAdmin();
            Map<String, KVStoreUser.UserDescription> userDescMap = this.getUserInfo(admin);
            if (userDescMap == null || userDescMap.isEmpty()) {
                userInfoStr = this.asJson ? "{}" : "";
            } else {
                if (this.userName != null && userDescMap.get(this.userName) == null) {
                    throw new IllegalCommandException("User with name of " + this.userName + " not found");
                }
                userInfoStr = this.formatUserInfo(userDescMap);
            }
            ddlHandler.setResultString(userInfoStr);
            ddlHandler.operationSucceeds();
        }

        private Map<String, KVStoreUser.UserDescription> getUserInfo(Admin admin) {
            SecurityMetadata md = admin.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
            if (md == null) {
                return null;
            }
            ExecutionContext currentCtx = ExecutionContext.getCurrent();
            if (currentCtx == null || currentCtx.hasPrivilege(SystemPrivilege.SYSVIEW)) {
                return md.getUsersDescription();
            }
            return md.getCurrentUserDescription();
        }

        private String formatUserInfo(Map<String, KVStoreUser.UserDescription> userDescMap) {
            StringBuilder sb = new StringBuilder();
            if (this.asJson) {
                if (this.userName != null) {
                    sb.append(userDescMap.get(this.userName).detailsAsJSON());
                } else {
                    boolean first = true;
                    sb.append("{\"users\":[");
                    for (KVStoreUser.UserDescription desc : userDescMap.values()) {
                        if (!first) {
                            sb.append(",");
                        }
                        first = false;
                        sb.append(desc.briefAsJSON());
                        sb.append("]}");
                    }
                }
            } else if (this.userName != null) {
                sb.append(userDescMap.get(this.userName).details());
            } else {
                for (KVStoreUser.UserDescription desc : userDescMap.values()) {
                    sb.append("user:");
                    sb.append(desc.brief());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.usrviewPrivList;
        }
    }

    public static class RevokePrivileges
    extends SecurityDdlOperation {
        private final String roleName;
        private final String tableName;
        private final Set<String> privs;

        public RevokePrivileges(String roleName, String tableName, Set<String> privs) {
            super("RevokePrivileges");
            this.roleName = roleName;
            this.tableName = tableName;
            this.privs = privs;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createRevokePrivilegePlan(this.opName, this.roleName, this.tableName, this.privs);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return this.tableName == null ? SystemPrivilege.sysoperPrivList : SystemPrivilege.usrviewPrivList;
        }
    }

    public static class RevokeRolesFromRole
    extends RevokeRoles {
        public RevokeRolesFromRole(String revokee, String[] roleNames) {
            super(revokee, roleNames);
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createRevokeRolesFromRolePlan(this.opName, this.revokee, this.roleNames);
            ddlHandler.approveAndExecute(planId);
        }
    }

    public static class RevokeRoles
    extends SecurityDdlOperation {
        final String revokee;
        final Set<String> roleNames;

        public RevokeRoles(String revokee, String[] roleNames) {
            super("RevokeRoles");
            this.revokee = revokee;
            this.roleNames = new HashSet<String>();
            Collections.addAll(this.roleNames, roleNames);
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createRevokePlan(this.opName, this.revokee, this.roleNames);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }
    }

    public static class GrantPrivileges
    extends SecurityDdlOperation {
        private final String roleName;
        private final String tableName;
        private final Set<String> privs;

        public GrantPrivileges(String roleName, String tableName, Set<String> privs) {
            super("GrantPrivileges");
            this.roleName = roleName;
            this.tableName = tableName;
            this.privs = privs;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createGrantPrivilegePlan(this.opName, this.roleName, this.tableName, this.privs);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return this.tableName == null ? SystemPrivilege.sysoperPrivList : SystemPrivilege.usrviewPrivList;
        }
    }

    public static class GrantRolesToRole
    extends GrantRoles {
        public GrantRolesToRole(String grantee, String[] roleNames) {
            super(grantee, roleNames);
        }

        @Override
        public void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createGrantRolesToRolePlan(this.opName, this.grantee, this.roleNames);
            ddlHandler.approveAndExecute(planId);
        }
    }

    public static class GrantRoles
    extends SecurityDdlOperation {
        final String grantee;
        final Set<String> roleNames;

        public GrantRoles(String grantee, String[] roleNames) {
            super("GrantRoles");
            this.grantee = grantee;
            this.roleNames = new HashSet<String>();
            Collections.addAll(this.roleNames, roleNames);
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createGrantPlan(this.opName, this.grantee, this.roleNames);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }
    }

    public static class DropRole
    extends SecurityDdlOperation {
        private final String roleName;

        public DropRole(String roleName) {
            super("DropRole");
            this.roleName = roleName;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createDropRolePlan(this.opName, this.roleName);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }
    }

    public static class CreateRole
    extends SecurityDdlOperation {
        private final String roleName;

        public CreateRole(String roleName) {
            super("CreateRole");
            this.roleName = roleName;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createCreateRolePlan(this.opName, this.roleName);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }
    }

    public static class DropUser
    extends SecurityDdlOperation {
        private final String userName;
        private final boolean cascade;

        public DropUser(String userName, boolean cascade) {
            super("DropUser");
            this.userName = userName;
            this.cascade = cascade;
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createDropUserPlan(this.opName, this.userName, this.cascade);
            ddlHandler.approveAndExecute(planId);
        }
    }

    public static class AlterUser
    extends SecurityDdlOperation {
        private final String userName;
        private final Boolean isEnabled;
        private final char[] plainPassword;
        private final boolean retainPassword;
        private final boolean clearRetainedPassword;
        private final Long pwdLifetimeInMillis;

        public AlterUser(String userName, Boolean isEnabled, char[] plainPassword, boolean retainPassword, boolean clearRetainedPassword, Long pwdLifeTimeInMillis) {
            super("AlterUser");
            this.userName = userName;
            this.isEnabled = isEnabled;
            this.plainPassword = plainPassword == null ? null : Arrays.copyOf(plainPassword, plainPassword.length);
            this.retainPassword = retainPassword;
            this.clearRetainedPassword = clearRetainedPassword;
            this.pwdLifetimeInMillis = pwdLifeTimeInMillis;
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.usrviewPrivList;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createChangeUserPlan(this.opName, this.userName, this.isEnabled, this.plainPassword, this.retainPassword, this.clearRetainedPassword, this.pwdLifetimeInMillis);
            ddlHandler.approveAndExecute(planId);
        }
    }

    public static class CreateUser
    extends SecurityDdlOperation {
        private final String userName;
        private final boolean isEnabled;
        private final boolean isAdmin;
        private final char[] plainPassword;
        private final Long pwdLifetimeInMillis;

        public CreateUser(String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword, Long pwdLifeTimeInMillis) {
            super("CreateUser");
            this.userName = userName;
            this.isAdmin = isAdmin;
            this.isEnabled = isEnabled;
            this.plainPassword = Arrays.copyOf(plainPassword, plainPassword.length);
            this.pwdLifetimeInMillis = pwdLifeTimeInMillis;
        }

        @Override
        void execute(DdlHandler ddlHandler) {
            int planId = ddlHandler.getAdmin().getPlanner().createCreateUserPlan(this.opName, this.userName, this.isEnabled, this.isAdmin, this.plainPassword, this.pwdLifetimeInMillis);
            ddlHandler.approveAndExecute(planId);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesToCheck() {
            return SystemPrivilege.sysoperPrivList;
        }
    }
}

