/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.KVBuiltInRoleResolver;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.Cache;
import oracle.kv.impl.security.util.CacheBuilder;

public class AdminRoleResolver
implements RoleResolver {
    private final AdminService adminService;
    private final Cache<String, RoleEntry> roleCache;

    public AdminRoleResolver(AdminService adminService, CacheBuilder.CacheConfig cacheConfig) {
        this.adminService = adminService;
        this.roleCache = CacheBuilder.build(cacheConfig);
    }

    public boolean updateRoleCache(RoleInstance role) {
        return this.roleCache.invalidate(role.name()) != null;
    }

    @Override
    public RoleInstance resolve(String roleName) {
        RoleInstance role = KVBuiltInRoleResolver.resolveRole(roleName);
        if (role == null) {
            RoleEntry entry = this.roleCache.get(RoleInstance.getNormalizedName(roleName));
            if (entry != null) {
                return entry.getRole();
            }
            SecurityMetadata secMd = this.adminService.getAdmin().getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
            if (secMd == null || secMd.getAllRoles().isEmpty()) {
                return null;
            }
            role = secMd.getRole(roleName);
            if (role != null) {
                this.roleCache.put(role.name(), new RoleEntry(role));
            }
        }
        return role;
    }

    private final class RoleEntry
    extends CacheBuilder.CacheEntry {
        private final RoleInstance role;

        RoleEntry(RoleInstance roleInstance) {
            this.role = roleInstance;
        }

        RoleInstance getRole() {
            return this.role;
        }
    }
}

