/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminEntity;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.fault.DatabaseNotReadyException;
import oracle.kv.impl.util.DatabaseUtils;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;

public abstract class AdminEntityDatabase<K, T extends AdminEntity<K>> {
    private static final int DB_OPEN_RETRY_MS = 1000;
    private static final int DB_OPEN_RETRY_MAX = 20;
    private Database entityDb;
    private final Admin admin;
    private final Logger logger;
    private volatile boolean closing = false;

    protected AdminEntityDatabase(Admin admin, Logger logger) {
        if (admin == null) {
            throw new IllegalArgumentException("admin cannot be null");
        }
        this.admin = admin;
        this.logger = logger;
    }

    public synchronized Database openEntityDb() {
        if (this.entityDb == null) {
            this.openEntityDb(this.admin.getEnv());
        }
        return this.entityDb;
    }

    private void openEntityDb(ReplicatedEnvironment repEnv) {
        assert (Thread.holdsLock(this));
        if (repEnv == null) {
            return;
        }
        int retries = 0;
        RuntimeException lastCause = null;
        while (this.entityDb == null && !this.closing && repEnv.isValid()) {
            DatabaseConfig dbConfig = new DatabaseConfig().setAllowCreate(true).setTransactional(true);
            try {
                this.entityDb = this.openDb((Environment)repEnv, dbConfig);
                assert (this.entityDb != null);
                this.logger.log(Level.INFO, "Open Admin entity DB: {0}", this.getDBName());
                return;
            }
            catch (RuntimeException re) {
                if (!DatabaseUtils.handleException(re, this.logger, this.getDBName())) {
                    return;
                }
                lastCause = re;
                if (retries >= 20) {
                    throw new IllegalStateException(String.format("Failed to open entity DB of %s after %d retries: %s", this.getDBName(), retries, lastCause), lastCause);
                }
                this.logger.log(Level.INFO, "Retry opening Admin entity DB: {0} because {1}", new Object[]{this.getDBName(), lastCause});
                ++retries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new IllegalStateException(ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database openDb(Environment env, DatabaseConfig dbConfig) {
        Database database;
        TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        Transaction txn = null;
        Database db = null;
        try {
            txn = env.beginTransaction(null, txnConfig);
            db = env.openDatabase(txn, this.getDBName(), dbConfig);
            txn.commit();
            txn = null;
            Database ret = db;
            db = null;
            database = ret;
        }
        catch (Throwable throwable) {
            TxnUtil.abort(txn);
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException de) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        TxnUtil.abort(txn);
        if (db != null) {
            try {
                db.close();
            }
            catch (DatabaseException de) {
                // empty catch block
            }
        }
        return database;
    }

    public synchronized void closeEntityDb() {
        this.closing = true;
        if (this.entityDb == null) {
            return;
        }
        this.logger.log(Level.INFO, "Closing admin entity DB: {0}", this.getDBName());
        TxnUtil.close(this.logger, this.entityDb, this.getDBName());
        this.entityDb = null;
    }

    public void persistEntity(Transaction txn, T entity) {
        this.checkIfEntityDbValid();
        Object indexKey = entity.getIndexKey();
        DatabaseEntry key = this.keyToEntry(indexKey);
        DatabaseEntry data = new DatabaseEntry(SerializationUtil.getBytes(entity));
        this.entityDb.put(txn, key, data);
        this.logger.log(Level.FINE, "Admin entity stored type: {0}", entity);
    }

    public T fetchEntity(Transaction txn, K indexKey, LockMode lockMode) {
        this.checkIfEntityDbValid();
        DatabaseEntry key = this.keyToEntry(indexKey);
        DatabaseEntry value = new DatabaseEntry();
        this.entityDb.get(txn, key, value, lockMode);
        return (T)SerializationUtil.getObject(value.getData(), AdminEntity.class);
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void checkIfEntityDbValid() {
        if (this.entityDb == null || this.closing) {
            if (this.admin.isClosing()) {
                throw new NonfatalAssertionException(this.getDBName() + " is closed in admin shutting down");
            }
            throw new DatabaseNotReadyException(this.getDBName() + " is not ready");
        }
    }

    private String getDBName() {
        return String.format("Admin%sDatabase", this.getType().getKey());
    }

    protected abstract AdminEntity.EntityType getType();

    protected abstract DatabaseEntry keyToEntry(K var1);
}

