/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.LogFileRewriteListener;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.IndexNotAvailableException;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminPlanDatabase;
import oracle.kv.impl.admin.AdminSchemaVersion;
import oracle.kv.impl.admin.AdminSecurity;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.DdlHandler;
import oracle.kv.impl.admin.DdlResultsReport;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.LoginService;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.PlanWaiter;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.criticalevent.EventRecorder;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.DatacenterParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.PlanStore;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.StatusReport;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.TopologyBuilder;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.TopologyDiff;
import oracle.kv.impl.admin.topo.TopologyStore;
import oracle.kv.impl.api.table.TableMetadataProxy;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataStore;
import oracle.kv.impl.monitor.Monitor;
import oracle.kv.impl.monitor.MonitorKeeper;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterTracker;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.ClientProxyCredentials;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.metadata.SecurityMDListener;
import oracle.kv.impl.security.metadata.SecurityMDTracker;
import oracle.kv.impl.security.metadata.SecurityMDUpdater;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadataProxy;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.AdminType;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.StorageNodeMap;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.JENotifyHooks;
import oracle.kv.impl.util.server.LoggerUtils;

public class Admin
implements MonitorKeeper {
    public static final String ADMIN_STORE_NAME = "AdminEntityStore";
    public static final String CAUSE_CREATE = "after create";
    public static final String CAUSE_APPROVE = "after approval";
    private static final String CAUSE_CANCEL = "after cancel";
    private static final String CAUSE_INTERRUPT = "after interrupt";
    public static final String CAUSE_INTERRUPT_REQUEST = "after interrupt requested";
    public static final String CAUSE_EXEC = "after execution";
    private static final long ADMIN_JE_CACHE_SIZE = 0L;
    private final AdminId adminId;
    private AdminId masterId;
    public static TestHook<Admin> EXECUTE_HOOK;
    private final TopologyStore topoStore;
    private final AdminServiceParams myParams;
    private volatile Planner planner;
    private final ParameterTracker parameterTracker;
    private final ParameterTracker globalParameterTracker;
    private final SecurityMDTracker securityMDTracker;
    private Monitor monitor;
    private EventRecorder eventRecorder;
    private final Logger logger;
    private Parameters parameters;
    private Memo memo;
    private final EnvironmentConfig envConfig;
    private final ReplicationConfig repConfig;
    private final File envDir;
    private final File snapshotDir;
    private final StateChangeListener listener;
    private final ReplicatedEnvironment environment;
    private EntityStore eStore;
    private final AdminService owner;
    private final StartupStatus startupStatus;
    private volatile boolean closing = false;
    private int eventStoreCounter = 0;
    private int eventStoreAgingFrequency = 100;
    private volatile KVVersion storeVersion = KVVersion.PREREQUISITE_VERSION;
    private volatile KVVersion adminVersion = KVVersion.PREREQUISITE_VERSION;
    private volatile AdminPlanDatabase adminPlanDb;
    private volatile PlanStore planStore;
    @Deprecated
    private static int nRecentPlans;

    public Admin(AdminServiceParams params) {
        this(params, null);
    }

    Admin(AdminServiceParams params, AdminService owner) {
        this.owner = owner;
        this.parameters = null;
        this.myParams = params;
        this.parameterTracker = new ParameterTracker();
        this.globalParameterTracker = new ParameterTracker();
        this.securityMDTracker = new SecurityMDTracker();
        AdminParams adminParams = this.myParams.getAdminParams();
        StorageNodeParams snParams = this.myParams.getStorageNodeParams();
        this.adminId = adminParams.getAdminId();
        this.envDir = FileNames.getEnvDir(snParams.getRootDirPath(), this.myParams.getGlobalParams().getKVStoreName(), null, snParams.getStorageNodeId(), this.adminId);
        this.snapshotDir = FileNames.getSnapshotDir(snParams.getRootDirPath(), this.myParams.getGlobalParams().getKVStoreName(), null, snParams.getStorageNodeId(), this.adminId);
        boolean created = FileNames.makeDir(this.envDir);
        LoggerUtils.registerMonitorAdminHandler(this.myParams.getGlobalParams().getKVStoreName(), this.adminId, this);
        this.monitor = new Monitor(this.myParams, this, this.getLoginManager());
        this.eventRecorder = new EventRecorder(this);
        this.addParameterListener(this.monitor);
        this.addParameterListener(UserDataControl.getParamListener());
        this.logger = LoggerUtils.getLogger(this.getClass(), this.myParams);
        ClientSocketFactory.setTimeoutLogger(this.logger);
        this.logger.info("Initializing " + (Object)((Object)this.myParams.getAdminParams().getType()) + " Admin for store: " + this.myParams.getGlobalParams().getKVStoreName());
        if (created) {
            this.logger.info("Created new admin environment dir: " + this.envDir);
        }
        this.logger.info("JVM Runtime maxMemory (bytes): " + Runtime.getRuntime().maxMemory());
        this.logger.info("Non-default JE properties for environment: " + new ParameterUtils(adminParams.getMap()).createProperties(false, true));
        this.envConfig = this.createEnvironmentConfig();
        this.repConfig = this.createReplicationConfig();
        this.listener = new Listener();
        this.environment = this.openEnv();
        this.topoStore = new TopologyStore(this);
        this.startupStatus = new StartupStatus();
        this.environment.setStateChangeListener(this.listener);
        this.startupStatus.waitForIsReady(this);
        this.logger.info("Replicated environment handle established. Cache size: " + this.environment.getConfig().getCacheSize() + ", State: " + (Object)((Object)this.environment.getState()));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public EntityStore getEStore() {
        return this.eStore;
    }

    private Set<Integer> readAndRecoverPlans() {
        assert (Thread.holdsLock(this));
        assert (this.planner != null);
        Map activePlans = (Map)new RunTransaction<Map<Integer, Plan>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Map<Integer, Plan> doTransaction(Transaction txn) {
                Map<Integer, Plan> plans = AbstractPlan.fetchActivePlans(Admin.this.planStore, txn, Admin.this.planner, Admin.this.myParams);
                Admin.this.topoStore.initCachedStartTime(txn);
                Admin.this.logger.log(Level.FINE, "Fetched {0} plans.", plans.size());
                return plans;
            }
        }.run();
        HashSet<Integer> restartSet = new HashSet<Integer>();
        for (Plan p : activePlans.values()) {
            Plan restart = this.planner.recover(p);
            if (restart == null) continue;
            restartSet.add(restart.getId());
        }
        return restartSet;
    }

    private void restartPlans(Set<Integer> restartSet) {
        assert (Thread.holdsLock(this));
        for (Integer planId : restartSet) {
            this.logger.info("Restarting plan " + planId);
            this.executePlan(planId, false);
        }
    }

    private EnvironmentConfig createEnvironmentConfig() {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setAllowCreate(true);
        config.setTransactional(true);
        config.setCacheSize(0L);
        return config;
    }

    private ReplicationConfig createReplicationConfig() {
        AdminParams ap = this.myParams.getAdminParams();
        ReplicationConfig config = new ParameterUtils(ap.getMap()).getAdminRepEnvConfig();
        config.setGroupName(Admin.getAdminRepGroupName(this.myParams.getGlobalParams().getKVStoreName()));
        config.setNodeName(Admin.getAdminRepNodeName(ap.getAdminId()));
        config.setNodeType(this.getNodeType(ap.getType()));
        config.setLogFileRewriteListener((LogFileRewriteListener)new AdminLogRewriteListener(this.snapshotDir, this.myParams));
        if (this.myParams.getSecurityParams() != null) {
            Properties haProps = this.myParams.getSecurityParams().getJEHAProperties();
            this.logger.info("DataChannelFactory: " + haProps.getProperty("je.rep.channelType"));
            config.setRepNetConfig(ReplicationNetworkConfig.create((Properties)haProps));
        }
        config.setConfigParam(RepParams.REPLICA_MESSAGE_QUEUE_SIZE.getName(), "10");
        return config;
    }

    private NodeType getNodeType(AdminType type) {
        switch (type) {
            case PRIMARY: {
                return NodeType.ELECTABLE;
            }
            case SECONDARY: {
                return NodeType.SECONDARY;
            }
        }
        throw new IllegalStateException("Unknown Admin type: " + (Object)((Object)type));
    }

    ReplicationNetworkConfig getRepNetConfig() {
        return this.repConfig.getRepNetConfig();
    }

    public static String getAdminRepGroupName(String kvstoreName) {
        return kvstoreName + "Admin";
    }

    public static String getAdminRepNodeName(AdminId adminId) {
        return Integer.toString(adminId.getAdminInstanceId());
    }

    private ReplicatedEnvironment openEnv() {
        boolean networkRestoreDone = false;
        this.envConfig.setLoggingHandler((Handler)new AdminRedirectHandler(this.myParams));
        this.envConfig.setRecoveryProgressListener((ProgressListener)new AdminRecoveryListener(this.myParams));
        this.repConfig.setSyncupProgressListener((ProgressListener)new AdminSyncupListener(this.myParams));
        while (true) {
            try {
                return new ReplicatedEnvironment(this.envDir, this.repConfig, this.envConfig);
            }
            catch (InsufficientLogException ile) {
                NetworkRestore networkRestore = new NetworkRestore();
                NetworkRestoreConfig config = new NetworkRestoreConfig();
                config.setLogProviders(null);
                networkRestore.execute(ile, config);
                continue;
            }
            catch (RollbackException rbe) {
                Long time = rbe.getEarliestTransactionCommitTime();
                this.logger.info("Rollback exception retrying: " + rbe.getMessage() + (time == null ? "" : " Rolling back to: " + new Date(time)));
                continue;
            }
            catch (Throwable t) {
                String msg = "unexpected exception creating environment";
                this.logger.log(Level.WARNING, "unexpected exception creating environment", t);
                throw new IllegalStateException("unexpected exception creating environment", t);
            }
            break;
        }
    }

    public String toString() {
        return "Admin " + this.adminId;
    }

    private void open() {
        assert (Thread.holdsLock(this));
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                Topology topology = Admin.this.topoStore.readTopology(txn);
                Admin.this.parameters = Admin.this.readParameters(txn);
                Admin.this.memo = Admin.this.readMemo(txn);
                if (topology == null || Admin.this.parameters == null || Admin.this.memo == null) {
                    if (topology != null || Admin.this.parameters != null || Admin.this.memo != null) {
                        throw new IllegalStateException("Inconsistency in Admin database: One of Topology, Parameters, or Memo is missing");
                    }
                    Admin.this.logger.info("Initializing Admin database");
                    String storeName = Admin.this.myParams.getGlobalParams().getKVStoreName();
                    Admin.this.topoStore.save(txn, new RealizedTopology(storeName));
                    Admin.this.logger.fine("Creating Parameters");
                    Admin.this.parameters = new Parameters(storeName);
                    Admin.this.parameters.persist(Admin.this.eStore, txn);
                    Admin.this.logger.fine("Creating Memo");
                    Admin.this.memo = new Memo(1, new EventRecorder.LatestEventTimestamps(0L, 0L, 0L));
                    Admin.this.memo.persist(Admin.this.eStore, txn);
                    Admin.this.logger.info("Admin database initialized");
                } else {
                    Admin.this.logger.info("Using existing Admin database");
                }
                return null;
            }
        }.run();
        this.eventRecorder.start(this.memo.getLatestEventTimestamps());
        this.planner = new Planner(this, this.myParams, this.getNextId());
    }

    public void stopAdminService(boolean force) {
        if (this.owner != null) {
            this.owner.stop(force);
        } else {
            this.shutdown(force);
        }
    }

    public synchronized void shutdown(boolean force) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.eventRecorder.shutdown();
        this.shutdownPlanner(force, true);
        this.monitor.shutdown();
        this.closeAdminPlanDb();
        if (force) {
            try {
                this.eStore.close();
            }
            catch (Exception possible) {
                // empty catch block
            }
            EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl((Environment)this.environment);
            if (envImpl != null) {
                envImpl.close(false);
            }
        } else {
            this.eStore.close();
            this.environment.close();
        }
        LoggerUtils.closeHandlers(this.myParams.getGlobalParams().getKVStoreName());
    }

    private void shutdownPlanner(boolean force, boolean wait) {
        assert (Thread.holdsLock(this));
        if (this.planner != null) {
            this.planner.shutdown(force, wait);
            this.planner = null;
        }
    }

    public synchronized void newParameters() {
        ParameterMap newMap;
        ParameterMap oldMap = this.myParams.getAdminParams().getMap();
        if (oldMap.equals(newMap = ConfigUtils.getAdminMap(this.adminId, this.myParams.getStorageNodeParams(), this.myParams.getGlobalParams(), this.logger))) {
            return;
        }
        this.parameterTracker.notifyListeners(oldMap, newMap);
        this.myParams.setAdminParams(new AdminParams(newMap));
    }

    public synchronized void newGlobalParameters() {
        ParameterMap newMap;
        ParameterMap oldMap = this.myParams.getGlobalParams().getMap();
        if (oldMap.equals(newMap = ConfigUtils.getGlobalMap(this.myParams.getStorageNodeParams(), this.myParams.getGlobalParams(), this.logger))) {
            this.logger.info("newGlobalParameters are identical to old global parameters");
            return;
        }
        this.logger.info("newGlobalParameters: refreshing global parameters");
        this.myParams.setGlobalParams(new GlobalParams(newMap));
        this.globalParameterTracker.notifyListeners(oldMap, newMap);
    }

    public void newSecurityMDChange() {
        SecurityMetadata secMd = this.getMetadata(SecurityMetadata.class, Metadata.MetadataType.SECURITY);
        this.securityMDTracker.notifyListeners(secMd.getLatestChange());
        this.logger.info("newSecurityMDChange: update with the latest security metadata change");
    }

    public void addParameterListener(ParameterListener pl) {
        this.parameterTracker.addListener(pl);
    }

    public void removeParameterListener(ParameterListener pl) {
        this.parameterTracker.removeListener(pl);
    }

    private void addGlobalParameterListener(ParameterListener pl) {
        this.globalParameterTracker.addListener(pl);
    }

    private void addSecurityMDListener(SecurityMDListener secMdListener) {
        this.securityMDTracker.addListener(secMdListener);
    }

    public ReplicatedEnvironment getEnv() {
        return this.environment;
    }

    public Topology getCurrentTopology() {
        return (Topology)new RunTransaction<Topology>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Topology doTransaction(Transaction txn) {
                return Admin.this.topoStore.readTopology(txn);
            }
        }.run();
    }

    public Parameters getCurrentParameters() {
        return (Parameters)new RunTransaction<Parameters>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Parameters doTransaction(Transaction txn) {
                return Admin.this.readParameters(txn);
            }
        }.run();
    }

    public AdminServiceParams getParams() {
        return this.myParams;
    }

    public void saveNextId(int nextId) {
        this.memo.setPlanId(nextId);
        this.logger.log(Level.FINE, "Storing Memo, planId = {0}", nextId);
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                Admin.this.memo.persist(Admin.this.eStore, txn);
                return null;
            }
        }.run();
    }

    public int getNextId() {
        if (this.memo == null) {
            return 0;
        }
        return this.memo.getPlanId();
    }

    public int saveCreatePlan(Plan plan) {
        this.savePlan(plan, CAUSE_CREATE);
        return plan.getId();
    }

    public void savePlan(final Plan plan, String cause) {
        this.logger.log(Level.FINE, "Saving {0} {1}", new Object[]{plan, cause});
        if (this.getPlanner().getCachedPlan(plan.getId()) == null && !plan.getState().isTerminal()) {
            throw new IllegalStateException("Attempting to save plan that is not in the Planner's cache " + plan);
        }
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Void doTransaction(Transaction txn) {
                Plan plan2 = plan;
                synchronized (plan2) {
                    plan.persist(Admin.this.planStore, txn);
                }
                return null;
            }
        }.run();
    }

    private void checkTopoVersion(Topology newTopo) {
        Topology current = this.getCurrentTopology();
        if (newTopo.getSequenceNumber() <= current.getSequenceNumber()) {
            throw new IllegalStateException("Only save newer topologies. Current version=" + current.getSequenceNumber() + " new version=" + newTopo.getSequenceNumber());
        }
    }

    public synchronized void saveTopo(Topology topology, DeploymentInfo info, Plan plan) {
        this.checkTopoVersion(topology);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndRNParam(Topology topology, DeploymentInfo info, RepNodeParams rnp, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.add(rnp);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndParams(Topology topology, DeploymentInfo info, DatacenterParams params, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.add(params);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndParams(Topology topology, DeploymentInfo info, StorageNodeParams snp, GlobalParams gp, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.add(snp);
        if (gp != null) {
            this.parameters.update(gp);
        }
        StorageNodePool pool = this.parameters.getStorageNodePool("AllStorageNodes");
        pool.add(snp.getStorageNodeId());
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndRemoveSN(Topology topology, DeploymentInfo info, StorageNodeId target, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.remove(target);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndRemoveRN(Topology topology, DeploymentInfo info, RepNodeId targetRN, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.remove(targetRN);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndRemoveDatacenter(Topology topology, DeploymentInfo info, DatacenterId targetId, Plan plan) {
        this.checkTopoVersion(topology);
        this.parameters.remove(targetId);
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveTopoAndParams(Topology topology, DeploymentInfo info, Set<RepNodeParams> repNodeParams, Set<AdminParams> adminParams, Plan plan) {
        this.checkTopoVersion(topology);
        for (RepNodeParams rnParams : repNodeParams) {
            this.parameters.update(rnParams);
        }
        for (AdminParams ap : adminParams) {
            this.parameters.update(ap);
        }
        this.storeTopoAndParams(topology, info, plan);
    }

    public synchronized void saveParams(Set<RepNodeParams> repNodeParams, Set<AdminParams> adminParams) {
        for (RepNodeParams rnParams : repNodeParams) {
            this.parameters.update(rnParams);
        }
        for (AdminParams ap : adminParams) {
            this.parameters.update(ap);
        }
        this.storeParameters();
    }

    public synchronized boolean updatePartition(final PartitionId partitionId, final RepGroupId targetRGId, final DeploymentInfo info, final Plan plan) {
        return (Boolean)new RunTransaction<Boolean>(this.environment, RunTransaction.sync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Boolean doTransaction(Transaction txn) {
                Topology t = null;
                Plan plan2 = plan;
                synchronized (plan2) {
                    t = Admin.this.topoStore.readTopology(txn);
                    if (t.get(partitionId).getRepGroupId().equals(targetRGId)) {
                        return false;
                    }
                    t.updatePartition(partitionId, targetRGId);
                    if (plan.updatingMetadata(t)) {
                        plan.persist(Admin.this.planStore, txn);
                    }
                }
                Admin.this.topoStore.save(txn, new RealizedTopology(t, info));
                return true;
            }
        }.run();
    }

    public synchronized void updateParams(RepNodeParams rnp) {
        this.parameters.update(rnp);
        this.storeParameters();
    }

    public synchronized void updateParams(StorageNodeParams snp, GlobalParams gp) {
        this.parameters.update(snp);
        if (gp != null) {
            this.parameters.update(gp);
        }
        this.storeParameters();
    }

    public synchronized void updateParams(AdminParams ap) {
        this.parameters.update(ap);
        this.storeParameters();
    }

    public synchronized void updateParams(GlobalParams gp) {
        this.parameters.update(gp);
        this.storeParameters();
    }

    public synchronized void addAdminParams(AdminParams ap) {
        int id = ap.getAdminId().getAdminInstanceId();
        this.logger.log(Level.FINE, "Saving new AdminParams[{0}]", id);
        int nAdmins = this.getAdminCount();
        if (id <= nAdmins) {
            throw new NonfatalAssertionException("Attempting to add an AdminParams for an existing Admin. Id=" + id + " nAdmins=" + nAdmins);
        }
        this.parameters.add(ap);
        this.storeParameters();
    }

    public synchronized void removeAdminParams(AdminId aid) {
        this.logger.log(Level.FINE, "Removing AdminParams[{0}]", aid);
        if (this.parameters.get(aid) == null) {
            throw new MemberNotFoundException("Removing nonexistent params for admin " + aid);
        }
        int nAdmins = this.getAdminCount();
        if (nAdmins == 1) {
            throw new NonfatalAssertionException("Attempting to remove the sole Admin instance" + aid);
        }
        this.parameters.remove(aid);
        this.storeParameters();
    }

    public synchronized void addStorageNodePool(String name) {
        if (this.parameters.getStorageNodePool(name) != null) {
            throw new IllegalCommandException("Attempt to add a StorageNodePool name that already exists.");
        }
        this.parameters.addStorageNodePool(name);
        this.logger.info("Created Storage Node Pool: " + name);
        this.storeParameters();
    }

    public synchronized void removeStorageNodePool(String name) {
        if (this.parameters.getStorageNodePool(name) == null) {
            throw new IllegalCommandException("Attempt to remove a nonexistent StorageNodePool.");
        }
        this.parameters.removeStorageNodePool(name);
        this.logger.info("Removed Storage Node Pool: " + name);
        this.storeParameters();
    }

    public synchronized void addStorageNodeToPool(String name, StorageNodeId snId) {
        StorageNodePool pool = this.parameters.getStorageNodePool(name);
        if (pool == null) {
            throw new IllegalCommandException("No such Storage Node Pool: " + name);
        }
        Topology current = this.getCurrentTopology();
        StorageNode sn = current.get(snId);
        if (sn == null) {
            throw new IllegalCommandException("Attempt to add nonexistent StorageNode to a pool.");
        }
        this.logger.info("Added Storage Node " + snId.toString() + " to pool: " + name);
        pool.add(snId);
        this.storeParameters();
    }

    public synchronized void replaceStorageNodePool(String name, List<StorageNodeId> ids) {
        StorageNodePool pool = this.parameters.getStorageNodePool(name);
        if (pool == null) {
            throw new IllegalCommandException("No such Storage Node Pool: " + name);
        }
        Topology current = this.getCurrentTopology();
        for (StorageNodeId id : ids) {
            StorageNode sn = current.get(id);
            if (sn != null) continue;
            throw new IllegalCommandException("Attempt to add nonexistent StorageNode to a pool.");
        }
        pool.clear();
        for (StorageNodeId id : ids) {
            pool.add(id);
        }
        this.storeParameters();
    }

    void addTopoCandidate(final String candidateName, final Topology newTopo) {
        new RunTransaction<Void>(this.environment, RunTransaction.writeNoSync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                if (Admin.this.topoStore.exists(txn, candidateName)) {
                    throw new IllegalCommandException(candidateName + " already exists and can't be added as a new" + " topology candidate.");
                }
                Admin.this.topoStore.save(txn, new TopologyCandidate(candidateName, newTopo));
                return null;
            }
        }.run();
    }

    void addTopoCandidate(String candidateName, String sourceCandidateName) {
        Topology source = this.getCandidate(sourceCandidateName).getTopology();
        this.addTopoCandidate(candidateName, source);
    }

    void deleteTopoCandidate(final String candidateName) {
        new RunTransaction<Void>(this.environment, RunTransaction.writeNoSync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                if (!Admin.this.topoStore.exists(txn, candidateName)) {
                    throw new IllegalCommandException(candidateName + " doesn't exist");
                }
                Admin.this.topoStore.delete(txn, candidateName);
                return null;
            }
        }.run();
    }

    public String createTopoCandidate(final String topologyName, final String snPoolName, final int numPartitions) {
        return (String)new RunTransaction<String>(this.environment, RunTransaction.writeNoSync, this.logger){

            @Override
            String doTransaction(Transaction txn) {
                if (Admin.this.topoStore.exists(txn, topologyName)) {
                    throw new IllegalCommandException("Topology " + topologyName + " already exists");
                }
                StorageNodePool pool = Admin.this.parameters.getStorageNodePool(snPoolName);
                if (pool == null) {
                    throw new IllegalCommandException("Storage Node Pool " + snPoolName + " not found.");
                }
                TopologyBuilder tb = new TopologyBuilder(Admin.this.getCurrentTopology(), topologyName, pool, numPartitions, Admin.this.getCurrentParameters(), Admin.this.myParams);
                TopologyCandidate candidate = tb.build();
                Admin.this.topoStore.save(txn, candidate);
                return "Created: " + candidate.getName();
            }
        }.run();
    }

    public TopologyCandidate getCandidate(final String candidateName) {
        return (TopologyCandidate)new RunTransaction<TopologyCandidate>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            TopologyCandidate doTransaction(Transaction txn) {
                return Admin.this.getCandidate(txn, candidateName);
            }
        }.run();
    }

    private TopologyCandidate getCandidate(Transaction txn, String candidateName) {
        TopologyCandidate candidate = this.topoStore.get(txn, candidateName);
        if (candidate == null) {
            throw new IllegalCommandException("Topology " + candidateName + " does not exist. Use " + " topology list to see all available candidate");
        }
        return candidate;
    }

    public List<String> listTopoCandidates() {
        return (List)new RunTransaction<List<String>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            List<String> doTransaction(Transaction txn) {
                return Admin.this.topoStore.getCandidateNames(txn);
            }
        }.run();
    }

    public String redistributeTopology(final String candidateName, final String snPoolName) {
        return (String)new RunTransaction<String>(this.environment, RunTransaction.writeNoSync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String doTransaction(Transaction txn) {
                TopologyCandidate candidate = Admin.this.getCandidate(txn, candidateName);
                StorageNodePool pool = Admin.this.freezeSNPool(snPoolName);
                try {
                    TopologyBuilder tb = new TopologyBuilder(candidate, pool, Admin.this.getCurrentParameters(), Admin.this.myParams);
                    TopologyCandidate newCandidate = tb.build();
                    Admin.this.topoStore.save(txn, newCandidate);
                    String string = "Redistributed: " + newCandidate.getName();
                    return string;
                }
                finally {
                    pool.thaw();
                }
            }
        }.run();
    }

    public String rebalanceTopology(final String candidateName, final String snPoolName, final DatacenterId dcId) {
        return (String)new RunTransaction<String>(this.environment, RunTransaction.writeNoSync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String doTransaction(Transaction txn) {
                TopologyCandidate candidate = Admin.this.getCandidate(txn, candidateName);
                StorageNodePool pool = Admin.this.freezeSNPool(snPoolName);
                try {
                    TopologyBuilder tb = new TopologyBuilder(candidate, pool, Admin.this.getCurrentParameters(), Admin.this.myParams);
                    TopologyCandidate newCandidate = tb.rebalance(dcId);
                    Admin.this.topoStore.save(txn, newCandidate);
                    String string = "Rebalanced: " + newCandidate.getName();
                    return string;
                }
                finally {
                    pool.thaw();
                }
            }
        }.run();
    }

    private StorageNodePool freezeSNPool(String snPoolName) {
        StorageNodePool pool = this.parameters.getStorageNodePool(snPoolName);
        if (pool == null) {
            throw new IllegalCommandException("Storage Node Pool " + snPoolName + " not found.");
        }
        pool.freeze();
        return pool;
    }

    private Parameters readParameters(Transaction txn) {
        Parameters params = Parameters.fetch(this.eStore, txn);
        if (params == null) {
            this.logger.fine("Parameters not found");
        } else {
            this.logger.fine("Parameters fetched");
        }
        return params;
    }

    private Memo readMemo(Transaction txn) {
        Memo m = Memo.fetch(this.eStore, txn);
        if (m == null) {
            this.logger.fine("Memo not found");
        } else {
            this.logger.fine("Memo fetched");
        }
        return m;
    }

    public void storeEvents(final List<CriticalEvent> events, final EventRecorder.LatestEventTimestamps let) {
        new RunTransaction<Void>(this.environment, RunTransaction.noSync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                for (CriticalEvent pe : events) {
                    pe.persist(Admin.this.eStore, txn);
                    if (Admin.this.eventStoreCounter++ % Admin.this.eventStoreAgingFrequency != 0) continue;
                    CriticalEvent.ageStore(Admin.this.eStore, txn, Admin.this.getEventExpiryAge());
                }
                Admin.this.memo.setLatestEventTimestamps(let);
                Admin.this.memo.persist(Admin.this.eStore, txn);
                return null;
            }
        }.run();
    }

    public List<CriticalEvent> getEvents(final long startTime, final long endTime, final CriticalEvent.EventType type) {
        return (List)new RunTransaction<List<CriticalEvent>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            List<CriticalEvent> doTransaction(Transaction txn) {
                return CriticalEvent.fetch(Admin.this.eStore, txn, startTime, endTime, type);
            }
        }.run();
    }

    public CriticalEvent getOneEvent(final String eventId) {
        return (CriticalEvent)new RunTransaction<CriticalEvent>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            CriticalEvent doTransaction(Transaction txn) {
                return CriticalEvent.fetch(Admin.this.eStore, txn, eventId);
            }
        }.run();
    }

    public synchronized void approvePlan(int id) {
        Plan p = this.getAndCheckPlan(id);
        this.planner.approvePlan(id);
        this.savePlan(p, CAUSE_APPROVE);
        this.logger.info(p + " approved");
    }

    public synchronized void cancelPlan(int id) {
        Plan p = this.getAndCheckPlan(id);
        this.planner.cancelPlan(id);
        this.savePlan(p, CAUSE_CANCEL);
        this.logger.info(p + " canceled");
    }

    public synchronized void interruptPlan(int id) {
        Plan p = this.getAndCheckPlan(id);
        this.planner.interruptPlan(id);
        this.savePlan(p, CAUSE_INTERRUPT);
        this.logger.info(p + " interrupted");
    }

    public synchronized void executePlan(int id, boolean force) {
        Plan p = this.getAndCheckPlan(id);
        try {
            this.planner.executePlan(p, force);
        }
        catch (PlanLocksHeldException e) {
            throw new IllegalCommandException(e.getMessage());
        }
    }

    public synchronized int executePlanOrFindMatch(int id) {
        Plan p = this.getAndCheckPlan(id);
        try {
            this.planner.executePlan(p, false);
            return id;
        }
        catch (PlanLocksHeldException e) {
            int runningPlanId = e.getOwningPlanId();
            Plan runningPlan = this.getPlanById(runningPlanId);
            if (runningPlan.logicalCompare(p)) {
                return runningPlanId;
            }
            throw new IllegalCommandException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plan.State awaitPlan(int id, int timeout, TimeUnit timeoutUnit) {
        Plan p = this.getAndCheckPlan(id);
        PlanWaiter waiter = new PlanWaiter();
        p.addWaiter(waiter);
        this.logger.log(Level.FINE, "Waiting for plan {0}, timeout={1} {2}", new Object[]{p, timeout, timeoutUnit});
        try {
            if (timeout == 0) {
                while (!waiter.waitForPlanEnd(10, TimeUnit.SECONDS)) {
                    if (!p.getPlanner().isShutdown()) continue;
                    throw new IllegalCommandException("Cannot service request, admin is shutdown");
                }
            } else {
                boolean completed = waiter.waitForPlanEnd(timeout, timeoutUnit);
                if (!completed) {
                    this.logger.log(Level.INFO, "Timed out (timeout {0} ms) waiting for plan {1} to finish, state={2} ", new Object[]{timeoutUnit.toMillis(timeout), p, p.getState()});
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Level.INFO, "Interrupted while waiting for {0} to finish, end state={1}", new Object[]{p, p.getState()});
        }
        finally {
            p.removeWaiter(waiter);
        }
        this.logger.log(Level.INFO, "awaitPlan of {0} finished, state={1}", new Object[]{p, p.getState()});
        return p.getState();
    }

    public void assertSuccess(int planId) {
        Plan p = this.getAndCheckPlan(planId);
        Plan.State status = p.getState();
        if (status == Plan.State.SUCCEEDED) {
            return;
        }
        ExecutionState.ExceptionTransfer transfer = p.getLatestRunExceptionTransfer();
        String msg = p + " ended with " + (Object)((Object)status);
        if (transfer != null) {
            if (transfer.getFailure() != null) {
                Throwable failure = transfer.getFailure();
                OperationFaultException newEx = new OperationFaultException(msg + ": " + transfer.getDescription(), failure);
                newEx.setStackTrace(failure.getStackTrace());
                throw newEx;
            }
            if (transfer.getDescription() != null) {
                throw new OperationFaultException(msg + ": " + transfer.getDescription());
            }
        }
        throw new OperationFaultException(msg);
    }

    public Plan getPlanById(final int id) {
        Plan p = this.getPlanner().getCachedPlan(id);
        if (p != null) {
            return p;
        }
        return (Plan)new RunTransaction<Plan>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Plan doTransaction(Transaction txn) {
                Plan uncachedPlan = AbstractPlan.fetchPlanById(id, Admin.this.planStore, txn, Admin.this.getPlanner(), Admin.this.myParams);
                if (uncachedPlan == null) {
                    return null;
                }
                if (!uncachedPlan.getState().isTerminal()) {
                    throw new IllegalStateException("Found non-terminal plan that is not cached. " + uncachedPlan);
                }
                return uncachedPlan;
            }
        }.run();
    }

    Plan getAndCheckPlan(int id) {
        Plan p = this.getPlanById(id);
        if (p == null) {
            throw new IllegalCommandException("Plan id " + id + " doesn't exist");
        }
        return p;
    }

    @Deprecated
    public synchronized Map<Integer, Plan> getRecentPlansCopy() {
        if (this.planner == null) {
            return null;
        }
        return (Map)new RunTransaction<Map<Integer, Plan>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Map<Integer, Plan> doTransaction(Transaction txn) {
                return AbstractPlan.fetchRecentPlansForDisplay(nRecentPlans, Admin.this.planStore, txn, Admin.this.planner, Admin.this.myParams);
            }
        }.run();
    }

    public int[] getPlanIdRange(final long startTime, final long endTime, final int n, final String planOwnerId) {
        return (int[])new RunTransaction<int[]>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            int[] doTransaction(Transaction txn) {
                return AbstractPlan.getPlanIdRange(Admin.this.planStore, txn, startTime, endTime, n, planOwnerId);
            }
        }.run();
    }

    public synchronized Map<Integer, Plan> getPlanRange(final int firstPlanId, final int howMany, final String planOwnerId) {
        if (this.planner == null) {
            return Collections.emptyMap();
        }
        return (Map)new RunTransaction<Map<Integer, Plan>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            Map<Integer, Plan> doTransaction(Transaction txn) {
                return AbstractPlan.getPlanRange(Admin.this.planStore, txn, Admin.this.planner, Admin.this.myParams, firstPlanId, howMany, planOwnerId);
            }
        }.run();
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void storeParameters() {
        this.logger.fine("Storing Parameters");
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                Admin.this.parameters.persist(Admin.this.eStore, txn);
                return null;
            }
        }.run();
    }

    private void storeTopoAndParams(final Topology topology, final DeploymentInfo info, final Plan plan) {
        assert (Thread.holdsLock(this));
        this.logger.log(Level.FINE, "Storing parameters and topology with sequence #: {0}", topology.getSequenceNumber());
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Void doTransaction(Transaction txn) {
                Plan plan2 = plan;
                synchronized (plan2) {
                    if (plan.updatingMetadata(topology)) {
                        plan.persist(Admin.this.planStore, txn);
                    }
                }
                Admin.this.topoStore.save(txn, new RealizedTopology(topology, info));
                Admin.this.parameters.persist(Admin.this.eStore, txn);
                Admin.this.memo.persist(Admin.this.eStore, txn);
                return null;
            }
        }.run();
    }

    public StorageNodeParams getStorageNodeParams(StorageNodeId targetSNId) {
        return this.parameters.get(targetSNId);
    }

    public ParameterMap copyPolicy() {
        return this.parameters.copyPolicies();
    }

    public void setPolicy(ParameterMap policyParams) {
        this.parameters.setPolicies(policyParams);
        this.storeParameters();
    }

    public long getEventExpiryAge() {
        return this.myParams.getAdminParams().getEventExpiryAge();
    }

    public void setEventStoreAgingFrequency(int f) {
        this.eventStoreAgingFrequency = f;
    }

    public AdminId generateAdminId() {
        return this.parameters.getNextAdminId();
    }

    public int getAdminCount() {
        return this.parameters.getAdminCount();
    }

    public RepNodeParams getRepNodeParams(RepNodeId targetRepNodeId) {
        return this.parameters.get(targetRepNodeId);
    }

    public GlobalParams getGlobalParams() {
        return this.parameters.getGlobalParams();
    }

    synchronized EntityStore initEstore() {
        if (this.eStore == null) {
            AnnotationModel model = new AnnotationModel();
            model.registerClass(TableMetadataProxy.class);
            model.registerClass(SecurityMetadataProxy.class);
            StoreConfig stConfig = new StoreConfig();
            stConfig.setAllowCreate(true);
            stConfig.setTransactional(true);
            stConfig.setModel((EntityModel)model);
            this.setMutations(stConfig);
            this.eStore = new EntityStore((Environment)this.environment, ADMIN_STORE_NAME, stConfig);
        }
        return this.eStore;
    }

    private void setMutations(StoreConfig stConfig) {
        Mutations mutations = new Mutations();
        mutations.addDeleter(new Deleter("oracle.kv.impl.util.registry.RegistryUtils", 0));
        mutations.addDeleter(new Deleter("oracle.kv.impl.admin.plan.DeployStorePlan", 0, "registryUtils"));
        stConfig.setMutations(mutations);
    }

    private void checkSchemaVersion(final boolean isMaster) {
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            @Override
            Void doTransaction(Transaction txn) {
                AdminSchemaVersion schemaVersion = new AdminSchemaVersion(Admin.this, Admin.this.logger);
                if (isMaster) {
                    schemaVersion.checkAndUpdateVersion(txn);
                } else {
                    schemaVersion.checkVersion(txn);
                }
                return null;
            }
        }.run();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void enterMode(StateChangeEvent sce) {
        state = sce.getState();
        switch (31.$SwitchMap$com$sleepycat$je$rep$ReplicatedEnvironment$State[state.ordinal()]) {
            case 1: {
                this.enterMasterMode();
                break;
            }
            case 2: {
                this.enterReplicaMode(new AdminId(Integer.parseInt(sce.getMasterNodeName())));
                break;
            }
            case 3: {
                envImpl = DbInternal.getEnvironmentImpl((Environment)this.environment);
                if (envImpl != null) ** GOTO lbl14
                this.logger.info("Admin replica is detached; envImpl is null");
                ** GOTO lbl20
lbl14:
                // 1 sources

                try {
                    envImpl.checkIfInvalid();
                    this.logger.info("Admin replica is detached; env is valid.");
                }
                catch (DatabaseException rre) {
                    this.shutdownForForeignThreadFault(rre, "State Change Notifier");
                }
            }
lbl20:
            // 4 sources

            case 4: {
                this.enterDetachedMode();
            }
        }
    }

    private void enterMasterMode() {
        assert (Thread.holdsLock(this));
        try {
            this.startupStatus.setUnready(this);
            this.masterId = this.adminId;
            this.checkSchemaVersion(true);
            this.initEstore();
            this.initPlanStore(true);
            this.eventRecorder.shutdown();
            this.monitor.shutdown();
            this.removeParameterListener(this.monitor);
            this.monitor = new Monitor(this.myParams, this, this.getLoginManager());
            this.eventRecorder = new EventRecorder(this);
            this.open();
            this.monitor.setupExistingAgents(this.getCurrentTopology());
            this.addParameterListener(this.monitor);
            Set<Integer> restartSet = this.readAndRecoverPlans();
            this.startupStatus.setReady(this);
            this.restartPlans(restartSet);
        }
        catch (RuntimeException e) {
            this.logger.info("RuntimeException while entering master mode, " + e.getMessage());
            this.startupStatus.setError(this, e);
        }
    }

    private void enterReplicaMode(AdminId newMaster) {
        assert (Thread.holdsLock(this));
        try {
            this.startupStatus.setUnready(this);
            this.masterId = newMaster;
            this.checkSchemaVersion(false);
            this.initEstore();
            this.initPlanStore(false);
            this.eventRecorder.shutdown();
            this.shutdownPlanner(false, false);
            this.monitor.shutdown();
            this.removeParameterListener(this.monitor);
            this.startupStatus.setReady(this);
        }
        catch (RuntimeException e) {
            this.logger.info("RuntimeException while entering replica mode, " + e.getMessage());
            this.startupStatus.setError(this, e);
        }
    }

    private void enterDetachedMode() {
        this.enterReplicaMode(null);
    }

    public synchronized ReplicatedEnvironment.State getReplicationMode() {
        return this.environment.getState();
    }

    public synchronized URI getMasterHttpAddress() {
        Parameters p = this.getCurrentParameters();
        AdminParams ap = p.get(this.masterId);
        StorageNodeParams snp = p.get(ap.getStorageNodeId());
        int httpPort = ap.getHttpPort();
        String httpHost = snp.getHostname();
        try {
            return new URI("http", null, httpHost, httpPort, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new NonfatalAssertionException("Unexpected bad URI", e);
        }
    }

    public synchronized URI getMasterRmiAddress() {
        Parameters p = this.getCurrentParameters();
        AdminParams ap = p.get(this.masterId);
        StorageNodeParams snp = p.get(ap.getStorageNodeId());
        try {
            return new URI("rmi", null, snp.getHostname(), snp.getRegistryPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new NonfatalAssertionException("Unexpected bad URL", e);
        }
    }

    public List<String> displayRealizedTopologies(final boolean concise) {
        return (List)new RunTransaction<List<String>>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            List<String> doTransaction(Transaction txn) {
                return Admin.this.topoStore.displayHistory(txn, concise);
            }
        }.run();
    }

    public long validateStartTime(long proposedStartTime) {
        return this.topoStore.validateStartTime(proposedStartTime);
    }

    String getPlanStatus(int planId, long options) {
        Plan p = this.getAndCheckPlan(planId);
        StatusReport report = new StatusReport(p, options);
        return report.display();
    }

    public LoadParameters getAllParams() {
        LoadParameters ret = new LoadParameters();
        ret.addMap(this.myParams.getGlobalParams().getMap());
        ret.addMap(this.myParams.getStorageNodeParams().getMap());
        ret.addMap(this.myParams.getAdminParams().getMap());
        return ret;
    }

    public Planner getPlanner() {
        Planner p = this.planner;
        if (p == null) {
            throw new IllegalCommandException("Cannot service request, admin is not the master");
        }
        return p;
    }

    public void syncEventRecorder() {
        this.eventRecorder.sync();
    }

    public String getStorewideLogName() {
        return this.myParams.getStorageNodeParams().getHostname() + ":" + this.monitor.getStorewideLogName();
    }

    public KVStore openKVStore() {
        ClientProxyCredentials creds;
        Topology topo = this.getCurrentTopology();
        StorageNodeMap snMap = topo.getStorageNodeMap();
        int nHelpers = Math.min(100, snMap.size());
        String[] helperArray = new String[nHelpers];
        int i = 0;
        for (StorageNode sn : snMap.getAll()) {
            if (i >= nHelpers) break;
            helperArray[i] = sn.getHostname() + ':' + sn.getRegistryPort();
            ++i;
        }
        KVStoreConfig config = new KVStoreConfig(topo.getKVStoreName(), helperArray);
        Properties props = new Properties();
        props.setProperty("oracle.kv.transport", "internal");
        config.setSecurityProperties(props);
        KVStoreUserPrincipal currentUser = KVStoreUserPrincipal.getCurrentUser();
        if (currentUser == null) {
            creds = null;
        } else {
            LoginManager loginMgr = this.getLoginManager();
            creds = new ClientProxyCredentials(currentUser, loginMgr);
        }
        return KVStoreFactory.getStore(config, creds, null);
    }

    public String previewTopology(String targetTopoName, String startTopoName, boolean verbose) {
        Topology startTopo;
        if (startTopoName == null) {
            startTopo = this.getCurrentTopology();
        } else {
            TopologyCandidate startCand = this.getCandidate(startTopoName);
            startTopo = startCand.getTopology();
        }
        TopologyCandidate target = this.getCandidate(targetTopoName);
        TopologyDiff diff = new TopologyDiff(startTopo, startTopoName, target, this.parameters);
        return diff.display(verbose);
    }

    public String changeRepFactor(final String candidateName, final String snPoolName, final DatacenterId dcId, final int repFactor) {
        return (String)new RunTransaction<String>(this.environment, RunTransaction.writeNoSync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String doTransaction(Transaction txn) {
                TopologyCandidate candidate = Admin.this.getCandidate(txn, candidateName);
                StorageNodePool pool = Admin.this.freezeSNPool(snPoolName);
                try {
                    TopologyBuilder tb = new TopologyBuilder(candidate, pool, Admin.this.getCurrentParameters(), Admin.this.myParams);
                    TopologyCandidate newCandidate = tb.changeRepfactor(repFactor, dcId);
                    Admin.this.topoStore.save(txn, newCandidate);
                    String string = "Changed replication factor in " + newCandidate.getName();
                    return string;
                }
                finally {
                    pool.thaw();
                }
            }
        }.run();
    }

    public String validateTopology(String candidateName) {
        Rules.Results results = null;
        String prefix = null;
        if (candidateName == null) {
            results = Rules.validate(this.getCurrentTopology(), this.getCurrentParameters(), true);
            prefix = "the current deployed topology";
        } else {
            TopologyCandidate candidate = this.getCandidate(candidateName);
            results = Rules.validate(candidate.getTopology(), this.getCurrentParameters(), false);
            prefix = "topology candidate \"" + candidateName + "\"";
        }
        return "Validation for " + prefix + ":\n" + results;
    }

    public String moveRN(final String candidateName, final RepNodeId rnId, final StorageNodeId snId) {
        return (String)new RunTransaction<String>(this.environment, RunTransaction.writeNoSync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String doTransaction(Transaction txn) {
                TopologyCandidate candidate = Admin.this.getCandidate(txn, candidateName);
                StorageNodePool pool = Admin.this.freezeSNPool("AllStorageNodes");
                try {
                    TopologyBuilder tb = new TopologyBuilder(candidate, pool, Admin.this.getCurrentParameters(), Admin.this.myParams);
                    RepNode oldRN = candidate.getTopology().get(rnId);
                    if (oldRN == null) {
                        String string = rnId + " doesn't exist, and can't be moved.";
                        return string;
                    }
                    TopologyCandidate newCandidate = tb.relocateRN(rnId, snId);
                    RepNode newRN = newCandidate.getTopology().get(rnId);
                    if (newRN == null) {
                        throw new IllegalStateException(rnId + " is missing from the new topology candidate: " + TopologyPrinter.printTopology(newCandidate.getTopology()));
                    }
                    if (!newRN.getStorageNodeId().equals(oldRN.getStorageNodeId())) {
                        Admin.this.topoStore.save(txn, newCandidate);
                        String string = "Moved " + rnId + " from " + oldRN.getStorageNodeId() + " to " + newRN.getStorageNodeId();
                        return string;
                    }
                    String string = "Couldn't find an eligible SN to house " + rnId;
                    return string;
                }
                finally {
                    pool.thaw();
                }
            }
        }.run();
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public int getLatencyCeiling(ResourceId rnid) {
        if (rnid instanceof RepNodeId) {
            RepNodeParams rnp = this.parameters.get((RepNodeId)rnid);
            return rnp == null ? 0 : rnp.getLatencyCeiling();
        }
        return 0;
    }

    @Override
    public int getThroughputFloor(ResourceId rnid) {
        if (rnid instanceof RepNodeId) {
            RepNodeParams rnp = this.parameters.get((RepNodeId)rnid);
            return rnp == null ? 0 : rnp.getThroughputFloor();
        }
        return 0;
    }

    @Override
    public long getCommitLagThreshold(ResourceId rnid) {
        if (rnid instanceof RepNodeId) {
            RepNodeParams rnp = this.parameters.get((RepNodeId)rnid);
            return rnp == null ? 0L : rnp.getCommitLagThreshold();
        }
        return 0L;
    }

    private void updateAdminStatus(ConfigurableService.ServiceStatus newStatus) {
        if (this.owner == null) {
            return;
        }
        this.owner.updateAdminStatus(this, newStatus);
    }

    TopologyStore getTopoStore() {
        return this.topoStore;
    }

    public void shutdownForForeignThreadFault(Exception e, String name) {
        this.logger.log(Level.SEVERE, "Admin shutting down for fault in thread " + name, e);
        if (this.owner != null) {
            this.owner.getFaultHandler().queueShutdown(e, ProcessExitCode.RESTART);
        } else {
            new StoppableThread("StopAdminForForeignThreadFault"){

                public void run() {
                    Admin.this.shutdown(true);
                }

                protected Logger getLogger() {
                    return Admin.this.getLogger();
                }
            }.start();
        }
    }

    public ReplicationGroupAdmin getReplicationGroupAdmin(AdminId targetId) {
        AdminParams targetAP = this.parameters.get(targetId);
        if (targetAP == null) {
            return null;
        }
        String targetHelperHosts = targetAP.getHelperHosts();
        HashSet<InetSocketAddress> helperSockets = new HashSet<InetSocketAddress>();
        StringTokenizer tokenizer = new StringTokenizer(targetHelperHosts, ",");
        while (tokenizer.hasMoreTokens()) {
            String helper = tokenizer.nextToken();
            helperSockets.add(HostPortPair.getSocket((String)helper));
        }
        String storeName = this.parameters.getGlobalParams().getKVStoreName();
        String groupName = Admin.getAdminRepGroupName(storeName);
        return new ReplicationGroupAdmin(groupName, helperSockets, this.repConfig.getRepNetConfig());
    }

    public void removeAdminFromRepGroup(AdminId victim) {
        this.logger.info("Removing Admin replica " + victim + " from the replication group.");
        ReplicationGroupAdmin rga = this.getReplicationGroupAdmin(victim);
        if (rga == null) {
            throw new MemberNotFoundException("The admin " + victim + " is not in the rep group.");
        }
        String victimNodeName = Admin.getAdminRepNodeName(victim);
        int nAdmins = this.getAdminCount();
        if (nAdmins == 1) {
            throw new NonfatalAssertionException("Attempting to remove the sole Admin instance" + victim);
        }
        rga.removeMember(victimNodeName);
    }

    public void transferMaster() {
        this.logger.info("Transferring Admin mastership");
        HashSet<String> replicas = new HashSet<String>();
        for (AdminId r : this.parameters.getAdminIds()) {
            if (this.adminId.equals(r)) continue;
            replicas.add(Admin.getAdminRepNodeName(r));
        }
        try {
            this.environment.transferMaster(replicas, 60, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new NonfatalAssertionException("Master transfer failed", e);
        }
    }

    public boolean checkStoreVersion(KVVersion requiredVersion) {
        return VersionUtil.compareMinorVersion(this.getStoreVersion(), requiredVersion) >= 0;
    }

    public boolean checkAdminGroupVersion(KVVersion requiredVersion) {
        return VersionUtil.compareMinorVersion(this.getAdminGroupVersion(), requiredVersion) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVVersion getStoreVersion() {
        if (VersionUtil.compareMinorVersion(this.storeVersion, KVVersion.CURRENT_VERSION) >= 0) {
            return this.storeVersion;
        }
        KVVersion v = this.getSNsVersion(this.getCurrentTopology().getStorageNodeIds());
        Admin admin = this;
        synchronized (admin) {
            if (v.compareTo(this.storeVersion) > 0) {
                this.storeVersion = v;
            }
            return this.storeVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KVVersion getAdminGroupVersion() {
        if (VersionUtil.compareMinorVersion(this.adminVersion, KVVersion.CURRENT_VERSION) >= 0) {
            return this.adminVersion;
        }
        ArrayList<StorageNodeId> snIds = new ArrayList<StorageNodeId>();
        Parameters params = this.getCurrentParameters();
        for (AdminId aId : params.getAdminIds()) {
            snIds.add(params.get(aId).getStorageNodeId());
        }
        KVVersion v = this.getSNsVersion(snIds);
        Admin admin = this;
        synchronized (admin) {
            if (v.compareTo(this.adminVersion) > 0) {
                this.adminVersion = v;
            }
            return this.adminVersion;
        }
    }

    KVVersion getAdminHighestVersion() {
        ArrayList<StorageNodeId> snIds = new ArrayList<StorageNodeId>();
        Parameters params = this.getCurrentParameters();
        for (AdminId aId : params.getAdminIds()) {
            snIds.add(params.get(aId).getStorageNodeId());
        }
        KVVersion v = KVVersion.CURRENT_VERSION;
        RegistryUtils registryUtils = new RegistryUtils(this.getCurrentTopology(), this.getLoginManager());
        for (StorageNodeId snId : snIds) {
            StorageNodeStatus snStatus = this.getSNStatus(snId, registryUtils);
            KVVersion snVersion = snStatus.getKVVersion();
            if (VersionUtil.compareMinorVersion(snVersion, v) <= 0) continue;
            v = snVersion;
        }
        return v;
    }

    private KVVersion getSNsVersion(List<StorageNodeId> snIds) {
        RegistryUtils registryUtils = new RegistryUtils(this.getCurrentTopology(), this.getLoginManager());
        KVVersion v = KVVersion.CURRENT_VERSION;
        for (StorageNodeId snId : snIds) {
            StorageNodeStatus snStatus = this.getSNStatus(snId, registryUtils);
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(KVVersion.PREREQUISITE_VERSION) < 0) {
                String prereq = KVVersion.PREREQUISITE_VERSION.getNumericVersionString();
                throw new AdminFaultException(new IllegalCommandException("Node " + snId + " is at software version " + snVersion.getNumericVersionString() + " which does not meet the current prerequisite." + " It must be upgraded to version " + prereq + " or greater."));
            }
            if (VersionUtil.compareMinorVersion(snVersion, v) >= 0) continue;
            v = snVersion;
        }
        return v;
    }

    StorageNodeStatus getSNStatus(StorageNodeId snId, RegistryUtils utils) {
        try {
            return utils.getStorageNodeAgent(snId).ping();
        }
        catch (RemoteException re) {
            throw new AdminFaultException(re);
        }
        catch (NotBoundException nbe) {
            throw new AdminFaultException(nbe);
        }
    }

    boolean checkAdminMasterVersion(KVVersion requiredVersion) {
        KVVersion masterVersion;
        AdminId currentMaster = this.masterId;
        if (currentMaster == null) {
            throw new AdminFaultException(new NonfatalAssertionException("Admin is in DETACHED mode. The master is unknown."));
        }
        if (currentMaster.equals(this.adminId)) {
            masterVersion = KVVersion.CURRENT_VERSION;
        } else {
            Parameters p = this.getCurrentParameters();
            AdminParams ap = p.get(currentMaster);
            masterVersion = this.getSNsVersion(Arrays.asList(ap.getStorageNodeId()));
        }
        return VersionUtil.compareMinorVersion(masterVersion, requiredVersion) >= 0;
    }

    public <T extends Metadata<? extends MetadataInfo>> T getMetadata(final Class<T> returnType, final Metadata.MetadataType metadataType) {
        this.logger.log(Level.FINE, "Getting {0} metadata", (Object)metadataType);
        return (T)((Metadata)new RunTransaction<T>(this.environment, RunTransaction.readOnly, this.logger){

            @Override
            T doTransaction(Transaction txn) {
                try {
                    return MetadataStore.read(returnType, metadataType, Admin.this.eStore, txn);
                }
                catch (IndexNotAvailableException inae) {
                    Admin.this.logger.log(Level.FINE, "Metadata is currently unavailable: {0}", inae);
                    return null;
                }
            }
        }.run());
    }

    public void saveMetadata(final Metadata<?> metadata, final Plan plan) {
        this.logger.log(Level.FINE, "Storing {0} ", metadata);
        new RunTransaction<Void>(this.environment, RunTransaction.sync, this.logger){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Void doTransaction(Transaction txn) {
                if (plan != null) {
                    Plan plan2 = plan;
                    synchronized (plan2) {
                        if (plan.updatingMetadata(metadata)) {
                            plan.persist(Admin.this.planStore, txn);
                        }
                    }
                }
                MetadataStore.save(metadata, Admin.this.eStore, txn);
                return null;
            }
        }.run();
    }

    public LoginManager getLoginManager() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getLoginManager();
    }

    boolean isReady() {
        return this.startupStatus.isReady(this);
    }

    void installSecurityUpdater() {
        if (this.owner != null) {
            AdminSecurity aSecurity = this.owner.getAdminSecurity();
            LoginService loginService = this.owner.getLoginService();
            LoginUpdater loginUpdater = new LoginUpdater();
            SecurityMDUpdater secMDUpdater = new SecurityMDUpdater();
            loginUpdater.addServiceParamsUpdaters(aSecurity);
            loginUpdater.addGlobalParamsUpdaters(aSecurity);
            secMDUpdater.addRoleChangeUpdaters(aSecurity);
            secMDUpdater.addUserChangeUpdaters(aSecurity);
            if (loginService != null) {
                loginUpdater.addServiceParamsUpdaters(loginService);
                loginUpdater.addGlobalParamsUpdaters(loginService);
                this.addSecurityMDListener(loginService);
            }
            this.addParameterListener(new LoginUpdater.ServiceParamsListener(loginUpdater));
            this.addGlobalParameterListener(new LoginUpdater.GlobalParamsListener(loginUpdater));
            this.addSecurityMDListener(new SecurityMDUpdater.RoleChangeListener(secMDUpdater));
            this.addSecurityMDListener(new SecurityMDUpdater.UserChangeListener(secMDUpdater));
        }
    }

    public RoleResolver getRoleResolver() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getRoleResolver();
    }

    public synchronized AdminPlanDatabase initAdminPlanDb() {
        if (this.adminPlanDb == null) {
            this.adminPlanDb = new AdminPlanDatabase(this, this.logger);
            this.logger.info("Admin plan database initialized");
        }
        return this.adminPlanDb;
    }

    synchronized void closeAdminPlanDb() {
        if (this.adminPlanDb == null) {
            return;
        }
        this.adminPlanDb.closeEntityDb();
        this.adminPlanDb = null;
    }

    public AdminPlanDatabase getAdminPlanDb() {
        return this.adminPlanDb;
    }

    private void initPlanStore(boolean force) {
        if (force || this.planStore == null) {
            AdminSchemaVersion schemaVersion = new AdminSchemaVersion(this, this.logger);
            int currentSchemaVersion = schemaVersion.openAndReadSchemaVersion();
            this.planStore = PlanStore.getStoreByVersion(this, currentSchemaVersion);
            this.logger.log(Level.INFO, "Initialized plan store to {0}", this.planStore.getName());
        }
    }

    public ExecutionInfo executeStatement(String ddlStatement, short serialVersion) {
        assert (TestHookExecute.doHookIfSet(EXECUTE_HOOK, this));
        AccessChecker accessChecker = this.owner == null ? null : this.owner.getAdminSecurity().getAccessChecker();
        DdlHandler handler = new DdlHandler(ddlStatement, this, accessChecker);
        int planId = handler.getPlanId();
        if (!handler.getSuccess()) {
            assert (planId == 0);
            assert (handler.getErrorMessage() != null);
            if (handler.canRetry()) {
                throw new OperationFaultException("Error from " + ddlStatement + ": " + handler.getErrorMessage());
            }
            throw new IllegalCommandException("Error from " + ddlStatement + ": " + handler.getErrorMessage());
        }
        if (handler.hasPlan()) {
            return this.getExecutionStatus(planId, serialVersion);
        }
        DdlResultsReport report = new DdlResultsReport(handler, serialVersion);
        return new ExecutionInfoImpl(0, true, report.getStatus(), report.getStatusAsJson(), true, false, null, false, report.getResult());
    }

    public ExecutionInfo getExecutionStatus(int planId, short serialVersion) {
        assert (TestHookExecute.doHookIfSet(EXECUTE_HOOK, this));
        Plan p = this.getPlanById(planId);
        if (p == null) {
            throw new IllegalCommandException("Attempt to get status for plan " + planId + " but it doesn't exist");
        }
        PlanRun planRun = p.getExecutionState().getLatestPlanRun();
        DdlResultsReport ddlReport = new DdlResultsReport(p, serialVersion);
        return new ExecutionInfoImpl(planId, planRun.isTerminated(), ddlReport.getStatus(), ddlReport.getStatusAsJson(), planRun.isSuccess(), planRun.isCancelled(), planRun.getFailureDescription(false), planRun.getState().equals((Object)Plan.State.ERROR), ddlReport.getResult());
    }

    public Plan.State getCurrentPlanState(int planId) {
        Plan p = this.getPlanById(planId);
        if (p == null) {
            throw new IllegalCommandException("Attempt to get status for plan " + planId + " but it doesn't exist");
        }
        return p.getExecutionState().getLatestPlanRun().getState();
    }

    static {
        nRecentPlans = 100;
    }

    private static class StartupStatus {
        private Status status = Status.INITIALIZING;
        private RuntimeException problem;

        StartupStatus() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setReady(Admin admin) {
            Admin admin2 = admin;
            synchronized (admin2) {
                this.status = Status.READY;
                admin.notifyAll();
                admin.updateAdminStatus(ConfigurableService.ServiceStatus.RUNNING);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setUnready(Admin admin) {
            Admin admin2 = admin;
            synchronized (admin2) {
                this.status = Status.INITIALIZING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isReady(Admin admin) {
            Admin admin2 = admin;
            synchronized (admin2) {
                return this.status == Status.READY;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setError(Admin admin, RuntimeException e) {
            Admin admin2 = admin;
            synchronized (admin2) {
                this.status = Status.ERROR;
                this.problem = e;
                admin.notifyAll();
                admin.updateAdminStatus(ConfigurableService.ServiceStatus.ERROR_RESTARTING);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForIsReady(Admin admin) {
            Admin admin2 = admin;
            synchronized (admin2) {
                while (this.status == Status.INITIALIZING) {
                    try {
                        admin.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new IllegalStateException("Interrupted while waiting for Admin initialization", ie);
                    }
                }
            }
            if (this.status == Status.READY) {
                return;
            }
            if (this.status == Status.ERROR) {
                throw this.problem;
            }
        }

        private static enum Status {
            INITIALIZING,
            READY,
            ERROR;

        }
    }

    private static abstract class RunTransaction<T> {
        private static final int TRANSACTION_RETRY_MAX = 10;
        private static final int RETRY_WAIT = 3000;
        public static final TransactionConfig readOnly = new TransactionConfig().setReadOnly(true);
        public static final TransactionConfig sync = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        public static final TransactionConfig noSync = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE));
        public static final TransactionConfig writeNoSync = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        private final ReplicatedEnvironment env;
        private final Logger logger;
        private final TransactionConfig config;

        RunTransaction(ReplicatedEnvironment env, TransactionConfig config, Logger logger) {
            this.env = env;
            this.logger = logger;
            if (TestStatus.isWriteNoSyncAllowed() && !config.getReadOnly() && config.getDurability().getLocalSync() == Durability.SyncPolicy.SYNC) {
                Durability newDurability = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, config.getDurability().getReplicaSync(), config.getDurability().getReplicaAck());
                this.config = config.clone().setDurability(newDurability);
            } else {
                this.config = config;
            }
        }

        /*
         * Exception decompiling
         */
        T run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        abstract T doTransaction(Transaction var1);
    }

    private class Listener
    implements StateChangeListener {
        private Listener() {
        }

        public void stateChange(final StateChangeEvent sce) throws RuntimeException {
            ReplicatedEnvironment.State state = sce.getState();
            Admin.this.logger.info("State change event: " + new Date(sce.getEventTime()) + ", State: " + (Object)((Object)state) + ", Master: " + (state.isMaster() || state.isReplica() ? sce.getMasterNodeName() : "none"));
            if (Admin.this.closing) {
                return;
            }
            new StoppableThread("ReplicationStateChange"){

                public void run() {
                    Admin.this.enterMode(sce);
                }

                protected Logger getLogger() {
                    return Admin.this.logger;
                }
            }.start();
        }
    }

    @Entity
    public static class Memo {
        private static final String MEMO_KEY = "Memo";
        @PrimaryKey
        private final String memoKey = "Memo";
        private int planId;
        private EventRecorder.LatestEventTimestamps latestEventTimestamps;
        @Deprecated
        private int repFactor;

        public Memo(int firstPlanId, EventRecorder.LatestEventTimestamps let) {
            this.planId = firstPlanId;
            this.latestEventTimestamps = let;
        }

        private Memo() {
        }

        private int getPlanId() {
            return this.planId;
        }

        private void setPlanId(int nextId) {
            this.planId = nextId;
        }

        private EventRecorder.LatestEventTimestamps getLatestEventTimestamps() {
            return this.latestEventTimestamps;
        }

        private void setLatestEventTimestamps(EventRecorder.LatestEventTimestamps let) {
            this.latestEventTimestamps = let;
        }

        public void persist(EntityStore estore, Transaction txn) {
            PrimaryIndex mi = estore.getPrimaryIndex(String.class, Memo.class);
            mi.put(txn, (Object)this);
        }

        public static Memo fetch(EntityStore estore, Transaction txn) {
            PrimaryIndex mi = estore.getPrimaryIndex(String.class, Memo.class);
            return (Memo)mi.get(txn, (Object)MEMO_KEY, LockMode.READ_COMMITTED);
        }
    }

    private static class AdminLogRewriteListener
    extends JENotifyHooks.LogRewriteListener {
        AdminLogRewriteListener(File snapshotDir, AdminServiceParams adminServiceParams) {
            super(snapshotDir, LoggerUtils.getLogger(AdminLogRewriteListener.class, adminServiceParams));
        }
    }

    private static class AdminSyncupListener
    extends JENotifyHooks.SyncupListener {
        AdminSyncupListener(AdminServiceParams adminServiceParams) {
            super(LoggerUtils.getLogger(AdminSyncupListener.class, adminServiceParams));
        }
    }

    private static class AdminRecoveryListener
    extends JENotifyHooks.RecoveryListener {
        AdminRecoveryListener(AdminServiceParams adminServiceParams) {
            super(LoggerUtils.getLogger(AdminRecoveryListener.class, adminServiceParams));
        }
    }

    private static class AdminRedirectHandler
    extends JENotifyHooks.RedirectHandler {
        AdminRedirectHandler(AdminServiceParams adminServiceParams) {
            super(LoggerUtils.getLogger(AdminRedirectHandler.class, adminServiceParams));
        }
    }
}

