/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.KVStoreException;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.split.SplitBuilder;
import oracle.kv.impl.topo.split.TopoSplit;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import oracle.kv.impl.util.TopologyLocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

abstract class TableInputFormatBase<K, V>
extends InputFormat<K, V> {
    private static String kvStoreName = null;
    private static String[] kvHelperHosts = null;
    private static String[] kvHadoopHosts = null;
    private static String tableName = null;
    private static String primaryKeyProperty = null;
    private static String fieldRangeProperty = null;
    private static Direction direction = Direction.UNORDERED;
    private static Consistency consistency = null;
    private static long timeout = 0L;
    private static TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private static int maxRequests = 0;
    private static int batchSize = 0;
    private static int maxBatches = 0;
    private static String kvStoreSecurityFile = null;

    protected TableInputFormatBase() {
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Topology topology;
        if (context != null) {
            Configuration conf = context.getConfiguration();
            this.initializeParameters(conf);
        }
        if (kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided. Use either the " + ParamConstant.KVSTORE_NAME.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setKVStoreName().");
        }
        if (kvHelperHosts == null) {
            throw new IllegalArgumentException("No KV Helper Hosts were provided. Use either the " + ParamConstant.KVSTORE_NODES.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setKVHelperHosts().");
        }
        if (kvHadoopHosts == null) {
            kvHadoopHosts = new String[kvHelperHosts.length];
            for (int i = 0; i < kvHelperHosts.length; ++i) {
                String[] hostPort = kvHelperHosts[i].trim().split(":");
                TableInputFormatBase.kvHadoopHosts[i] = hostPort[0];
            }
        }
        if (tableName == null) {
            throw new IllegalArgumentException("No Table Name provided. Use either the " + ParamConstant.TABLE_NAME.getName() + " parameter or call " + TableInputFormatBase.class.getName() + ".setTableName().");
        }
        KVStoreLogin storeLogin = new KVStoreLogin(null, kvStoreSecurityFile);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        RepNodeLoginManager loginMgr = null;
        if (storeLogin.foundSSLTransport()) {
            loginMgr = KVStoreLogin.getRepNodeLoginMgr(kvHelperHosts, storeLogin.getLoginCredentials(), kvStoreName);
        }
        try {
            topology = TopologyLocator.get(kvHelperHosts, 0, loginMgr, kvStoreName);
        }
        catch (KVStoreException KVSE) {
            KVSE.printStackTrace();
            return null;
        }
        SplitBuilder sb = new SplitBuilder(topology);
        List<TopoSplit> splits = sb.createShardSplits(consistency);
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>(splits.size());
        for (TopoSplit ts : splits) {
            TableInputSplit split = new TableInputSplit();
            split.setKVStoreName(kvStoreName);
            split.setKVHelperHosts(kvHelperHosts);
            split.setLocations(kvHadoopHosts);
            split.setTableName(tableName);
            split.setKVStoreSecurityFile(storeLogin.getSecurityFilePath());
            split.setPrimaryKeyProperty(primaryKeyProperty);
            split.setFieldRangeProperty(fieldRangeProperty);
            split.setDirection(direction);
            split.setConsistency(consistency);
            split.setTimeout(timeout);
            split.setTimeoutUnit(timeoutUnit);
            split.setMaxRequests(maxRequests);
            split.setBatchSize(batchSize);
            split.setMaxBatches(maxBatches);
            split.setPartitionSets(ts.getPartitionSets());
            ret.add(split);
        }
        return ret;
    }

    public static void setKVStoreName(String newStoreName) {
        kvStoreName = newStoreName;
    }

    public static void setKVHelperHosts(String[] newHelperHosts) {
        kvHelperHosts = newHelperHosts;
    }

    public static void setKVHadoopHosts(String[] newHadoopHosts) {
        kvHadoopHosts = newHadoopHosts;
    }

    public static void setTableName(String newTableName) {
        tableName = newTableName;
    }

    public static void setPrimaryKeyProperty(String newProperty) {
        primaryKeyProperty = newProperty;
    }

    public static void setFieldRangeProperty(String newProperty) {
        fieldRangeProperty = newProperty;
    }

    public static void setDirection(Direction newDirection) {
        direction = newDirection;
    }

    public static void setConsistency(Consistency consistency) {
        if (consistency != Consistency.ABSOLUTE && consistency != Consistency.NONE_REQUIRED_NO_MASTER && consistency != Consistency.NONE_REQUIRED && consistency != null) {
            throw new IllegalArgumentException("Consistency may only be ABSOLUTE, NONE_REQUIRED_NO_MASTER, or NONE_REQUIRED");
        }
        TableInputFormatBase.consistency = consistency;
    }

    public static void setTimeout(long timeout) {
        TableInputFormatBase.timeout = timeout;
    }

    public static void setTimeoutUnit(TimeUnit timeoutUnit) {
        TableInputFormatBase.timeoutUnit = timeoutUnit;
    }

    public static void setMaxRequests(int newMaxRequests) {
        maxRequests = newMaxRequests;
    }

    public static void setBatchSize(int batchSize) {
        TableInputFormatBase.batchSize = batchSize;
    }

    public static void setMaxBatches(int newMaxBatches) {
        maxBatches = newMaxBatches;
    }

    public static void setKVSecurity(String kvStoreSecurity) {
        kvStoreSecurityFile = kvStoreSecurity;
    }

    private void initializeParameters(Configuration conf) {
        if (conf != null) {
            String kvStoreSecurityStr;
            String maxBatchesStr;
            String batchSizeStr;
            String maxRequestsStr;
            String timeoutParamName;
            String timeoutStr;
            String consistencyStr;
            String fieldRangeProp;
            String primaryKeyProp;
            String hadoopHosts;
            String helperHosts;
            String kvStoreNameProp = conf.get(ParamConstant.KVSTORE_NAME.getName());
            if (kvStoreNameProp != null) {
                kvStoreName = kvStoreNameProp;
            }
            if ((helperHosts = conf.get(ParamConstant.KVSTORE_NODES.getName())) != null) {
                kvHelperHosts = helperHosts.trim().split(",");
            }
            if ((hadoopHosts = conf.get(ParamConstant.KVHADOOP_NODES.getName())) != null) {
                kvHadoopHosts = hadoopHosts.trim().split(",");
            } else {
                kvHadoopHosts = new String[kvHelperHosts.length];
                for (int i = 0; i < kvHelperHosts.length; ++i) {
                    String[] hostPort = kvHelperHosts[i].trim().split(":");
                    TableInputFormatBase.kvHadoopHosts[i] = hostPort[0];
                }
            }
            String tableNameProp = conf.get(ParamConstant.TABLE_NAME.getName());
            if (tableNameProp != null) {
                tableName = tableNameProp;
            }
            if ((primaryKeyProp = conf.get(ParamConstant.PRIMARY_KEY.getName())) != null) {
                primaryKeyProperty = primaryKeyProp;
            }
            if ((fieldRangeProp = conf.get(ParamConstant.FIELD_RANGE.getName())) != null) {
                fieldRangeProperty = fieldRangeProp;
            }
            if ((consistencyStr = conf.get(ParamConstant.CONSISTENCY.getName())) != null) {
                consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            }
            if ((timeoutStr = conf.get(timeoutParamName = ParamConstant.TIMEOUT.getName())) != null) {
                timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
                timeoutUnit = TimeUnit.MILLISECONDS;
            }
            if ((maxRequestsStr = conf.get(ParamConstant.MAX_REQUESTS.getName())) != null) {
                try {
                    maxRequests = Integer.parseInt(maxRequestsStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.MAX_REQUESTS.getName() + ": " + maxRequestsStr);
                }
            }
            if ((batchSizeStr = conf.get(ParamConstant.BATCH_SIZE.getName())) != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + ": " + batchSizeStr);
                }
            }
            if ((maxBatchesStr = conf.get(ParamConstant.MAX_BATCHES.getName())) != null) {
                try {
                    maxBatches = Integer.parseInt(maxBatchesStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.MAX_BATCHES.getName() + ": " + maxBatchesStr);
                }
            }
            if ((kvStoreSecurityStr = conf.get(ParamConstant.KVSTORE_SECURITY.getName())) != null && kvStoreSecurityFile == null) {
                kvStoreSecurityFile = kvStoreSecurityStr;
            }
        }
    }
}

