/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;

public class TableFloatObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableFloatObjectInspector {
    TableFloatObjectInspector() {
        super(TypeInfoFactory.floatTypeInfo);
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new FloatWritable(this.get(o));
    }

    public float get(Object o) {
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof FieldValue) {
            return ((FieldValue)o).asFloat().get();
        }
        throw new IllegalArgumentException("object is not of type Float or type FieldValue");
    }

    public Object create(float value) {
        return Float.valueOf(value);
    }

    public Object set(Object o, float value) {
        return ((FieldDef)o).createFloat(value);
    }
}

