/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import oracle.kv.FaultException;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FastExternalizable;

public class Version
implements FastExternalizable,
Serializable {
    private static final long serialVersionUID = 1L;
    static final short MAGIC = 1243;
    private final UUID repGroupUuid;
    private final long repGroupVlsn;
    private final RepNodeId repNodeId;
    private final long repNodeLsn;

    public Version(UUID repGroupUuid, long repGroupVlsn) {
        assert (repGroupUuid != null);
        assert (repGroupVlsn > 0L);
        this.repGroupUuid = repGroupUuid;
        this.repGroupVlsn = repGroupVlsn;
        this.repNodeId = null;
        this.repNodeLsn = 0L;
    }

    public Version(UUID repGroupUuid, long repGroupVlsn, RepNodeId repNodeId, long repNodeLsn) {
        assert (repGroupUuid != null);
        assert (repGroupVlsn > 0L) : repGroupVlsn;
        assert (repNodeId != null);
        assert (repNodeLsn != 0L && repNodeLsn != -1L) : repNodeLsn;
        this.repGroupUuid = repGroupUuid;
        this.repGroupVlsn = repGroupVlsn;
        this.repNodeId = repNodeId;
        this.repNodeLsn = repNodeLsn;
    }

    public Version(ObjectInput in, short serialVersion) throws IOException {
        long mostSig = in.readLong();
        long leastSig = in.readLong();
        this.repGroupUuid = new UUID(mostSig, leastSig);
        this.repGroupVlsn = in.readLong();
        if (in.read() == 0) {
            this.repNodeId = null;
            this.repNodeLsn = 0L;
            return;
        }
        this.repNodeId = (RepNodeId)ResourceId.readFastExternal(in, serialVersion);
        this.repNodeLsn = in.readLong();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeLong(this.repGroupUuid.getMostSignificantBits());
        out.writeLong(this.repGroupUuid.getLeastSignificantBits());
        out.writeLong(this.repGroupVlsn);
        if (this.repNodeId == null) {
            out.write(0);
            return;
        }
        out.write(1);
        this.repNodeId.writeFastExternal(out, serialVersion);
        out.writeLong(this.repNodeLsn);
    }

    public byte[] toByteArray() {
        int headerSize = 6;
        byte payloadSize = this.repNodeId == null ? (byte)27 : 44;
        ByteBuffer bb = ByteBuffer.allocate(6 + payloadSize);
        bb.putShort((short)-21267);
        bb.putShort((short)5);
        bb.put((byte)119);
        bb.put(payloadSize);
        bb.putShort((short)7);
        bb.putLong(this.repGroupUuid.getMostSignificantBits());
        bb.putLong(this.repGroupUuid.getLeastSignificantBits());
        bb.putLong(this.repGroupVlsn);
        if (this.repNodeId == null) {
            bb.put((byte)0);
        } else {
            bb.put((byte)1);
            bb.put((byte)this.repNodeId.getType().ordinal());
            bb.putInt(this.repNodeId.getGroupId());
            bb.putInt(this.repNodeId.getNodeNum());
            bb.putLong(this.repNodeLsn);
        }
        return bb.array();
    }

    public static Version fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return new Version(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public UUID getRepGroupUUID() {
        return this.repGroupUuid;
    }

    public long getVLSN() {
        return this.repGroupVlsn;
    }

    @Deprecated
    public long getVersion() {
        return this.repGroupVlsn;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Version)) {
            return false;
        }
        Version o = (Version)other;
        return this.repGroupVlsn == o.repGroupVlsn && this.repGroupUuid.equals(o.repGroupUuid);
    }

    public int hashCode() {
        return this.repGroupUuid.hashCode() + (int)this.repGroupVlsn;
    }

    public String toString() {
        return "<Version repGroupUuid=" + this.repGroupUuid + " vlsn=" + new VLSN(this.repGroupVlsn).toString() + " repNodeId=" + this.repNodeId + " lsn=" + DbLsn.getNoFormatString(this.repNodeLsn) + '>';
    }

    public boolean sameLogicalVersion(long otherVlsn) {
        return this.repGroupVlsn == otherVlsn;
    }

    public boolean samePhysicalVersion(RepNodeId otherNodeId, long otherNodeLsn) {
        return this.repNodeLsn == otherNodeLsn && this.repNodeId != null && this.repNodeId.equals(otherNodeId);
    }
}

