/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.Consistency;
import oracle.kv.ConsistencyException;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.DurabilityException;
import oracle.kv.ExecutionFuture;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.LoginCredentials;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.OperationResult;
import oracle.kv.ParallelScanIterator;
import oracle.kv.RequestTimeoutException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.StatementResult;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.lob.KVLargeObject;
import oracle.kv.stats.KVStats;
import oracle.kv.table.TableAPI;

public interface KVStore
extends KVLargeObject,
Closeable {
    public ValueVersion get(Key var1) throws ConsistencyException, RequestTimeoutException, FaultException;

    public ValueVersion get(Key var1, Consistency var2, long var3, TimeUnit var5) throws ConsistencyException, RequestTimeoutException, FaultException;

    public SortedMap<Key, ValueVersion> multiGet(Key var1, KeyRange var2, Depth var3) throws ConsistencyException, RequestTimeoutException, FaultException;

    public SortedMap<Key, ValueVersion> multiGet(Key var1, KeyRange var2, Depth var3, Consistency var4, long var5, TimeUnit var7) throws ConsistencyException, RequestTimeoutException, FaultException;

    public SortedSet<Key> multiGetKeys(Key var1, KeyRange var2, Depth var3) throws ConsistencyException, RequestTimeoutException, FaultException;

    public SortedSet<Key> multiGetKeys(Key var1, KeyRange var2, Depth var3, Consistency var4, long var5, TimeUnit var7) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<KeyValueVersion> multiGetIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<KeyValueVersion> multiGetIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<Key> multiGetKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<Key> multiGetKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9) throws ConsistencyException, RequestTimeoutException, FaultException;

    public ParallelScanIterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9, StoreIteratorConfig var10) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<Key> storeKeysIterator(Direction var1, int var2) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Iterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9) throws ConsistencyException, RequestTimeoutException, FaultException;

    public ParallelScanIterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9, StoreIteratorConfig var10) throws ConsistencyException, RequestTimeoutException, FaultException;

    public Version put(Key var1, Value var2) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version put(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfAbsent(Key var1, Value var2) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfAbsent(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfPresent(Key var1, Value var2) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfPresent(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfVersion(Key var1, Value var2, Version var3) throws DurabilityException, RequestTimeoutException, FaultException;

    public Version putIfVersion(Key var1, Value var2, Version var3, ReturnValueVersion var4, Durability var5, long var6, TimeUnit var8) throws DurabilityException, RequestTimeoutException, FaultException;

    public boolean delete(Key var1) throws DurabilityException, RequestTimeoutException, FaultException;

    public boolean delete(Key var1, ReturnValueVersion var2, Durability var3, long var4, TimeUnit var6) throws DurabilityException, RequestTimeoutException, FaultException;

    public boolean deleteIfVersion(Key var1, Version var2) throws DurabilityException, RequestTimeoutException, FaultException;

    public boolean deleteIfVersion(Key var1, Version var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7) throws DurabilityException, RequestTimeoutException, FaultException;

    public int multiDelete(Key var1, KeyRange var2, Depth var3) throws DurabilityException, RequestTimeoutException, FaultException;

    public int multiDelete(Key var1, KeyRange var2, Depth var3, Durability var4, long var5, TimeUnit var7) throws DurabilityException, RequestTimeoutException, FaultException;

    public List<OperationResult> execute(List<Operation> var1) throws OperationExecutionException, DurabilityException, FaultException;

    public List<OperationResult> execute(List<Operation> var1, Durability var2, long var3, TimeUnit var5) throws OperationExecutionException, DurabilityException, FaultException;

    public OperationFactory getOperationFactory();

    @Override
    public void close();

    public KVStats getStats(boolean var1);

    public AvroCatalog getAvroCatalog();

    public TableAPI getTableAPI();

    public void login(LoginCredentials var1) throws RequestTimeoutException, AuthenticationFailureException, FaultException, IllegalArgumentException;

    public void logout() throws RequestTimeoutException, FaultException;

    public ExecutionFuture execute(String var1) throws FaultException, IllegalArgumentException;

    public StatementResult executeSync(String var1) throws FaultException, IllegalArgumentException;

    public ExecutionFuture getFuture(byte[] var1) throws IllegalArgumentException;
}

