/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.babelfish.ABabelfishTask;
import oracle.dbtools.migration.gui.babelfish.InstallSQLTranslatorPanel;
import oracle.dbtools.migration.gui.babelfish.OfflineBabelfishInstallTask;
import oracle.dbtools.migration.gui.babelfish.OnlineBabelfishInstallTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RunPrivilegedScript;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.CanceledException;

public class InstallSQLTranslatorMenu
extends AbstractMenuAction {
    public void launch() {
        String string = null;
        try {
            string = this.getDBObject().getConnection().getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            this.severe(sQLException);
        }
        if (string != null) {
            this.runLoad(this.getDBObject(), string);
        }
    }

    private void checkPermission(String string) {
        String string2 = this.getDBObject().getConnectionName();
        String string3 = "select count(*) from USER_JAVA_POLICY where type_name='java.lang.RuntimePermission' and name='getClassLoader' and enabled='ENABLED'";
        String string4 = "select count(*) from USER_JAVA_POLICY where type_name='java.lang.RuntimePermission' and name='setContextClassLoader' and enabled='ENABLED'";
        if (!this.gotUserPermission(this.getDBObject().getConnection(), string3) || !this.gotUserPermission(this.getDBObject().getConnection(), string4)) {
            String string5 = SEMessages.getString("InstallSQLTranslatorMenu.SysPasswordRequired");
            String string6 = SEMessages.getString("InstallSQLTranslatorMenu.SysPasswordRequiredTitle");
            String string7 = null;
            boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string5, (String)string6, string7);
            if (!bl) {
                return;
            }
            String[] stringArray = new String[]{"begin dbms_java.grant_permission('" + string + "', 'SYS:java.lang.RuntimePermission', 'getClassLoader', ''); " + "dbms_java.grant_permission('" + string + "', 'SYS:java.lang.RuntimePermission', 'setContextClassLoader', ''); " + " end;"};
            boolean bl2 = this.createRoles(string2, stringArray);
            if (!bl2) {
                return;
            }
        }
    }

    private void runLoad(DBObject dBObject, String string) {
        ActionListener actionListener;
        InstallSQLTranslatorPanel installSQLTranslatorPanel = new InstallSQLTranslatorPanel(false);
        String string2 = SEMessages.getString("InstallSQLTranslatorMenu.PanelTitle");
        boolean bl = UIUtils.showPanelAsDialog((JPanel)installSQLTranslatorPanel, (String)string2, (ActionListener)(actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                } else {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        }));
        if (bl) {
            Object object;
            String string3 = installSQLTranslatorPanel.getTranslatorType();
            boolean bl2 = installSQLTranslatorPanel.hasProfile();
            boolean bl3 = installSQLTranslatorPanel.isOnlineMode();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (bl2) {
                string4 = installSQLTranslatorPanel.getProfileName();
                string5 = installSQLTranslatorPanel.getProfileConnection();
                string6 = ABabelfishTask.getPackageFileName(string3);
                object = ABabelfishTask.getPackageName(string3);
                string7 = string;
                string8 = "BEGIN  dbms_sql_translator.create_profile('" + string4 + "'); " + " dbms_sql_translator.set_attribute('" + string4 + "', dbms_sql_translator.attr_translator, '" + string7 + "." + (String)object + "'); " + " dbms_sql_translator.set_attribute('" + string4 + "', dbms_sql_translator.ATTR_TRANSLATE_NEW_SQL, dbms_sql_translator.attr_value_true); " + " END;" + "\n/\n " + "GRANT ALL ON SQL TRANSLATION PROFILE " + string4 + " TO " + string7 + ";";
                try {
                    Connection connection = Connections.getInstance().getConnection(string5);
                    String string9 = " select  count(*) from user_sys_privs where privilege = 'CREATE SQL TRANSLATION PROFILE'";
                    if (!this.gotUserPermission(connection, string9)) {
                        String string10 = SEMessages.getString("InstallSQLTranslatorMenu.SysPasswordRequired2");
                        String string11 = SEMessages.getString("InstallSQLTranslatorMenu.SysPasswordRequiredTitle2");
                        String string12 = null;
                        boolean bl4 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string10, (String)string11, string12);
                        if (!bl4) {
                            return;
                        }
                        String string13 = connection.getMetaData().getUserName();
                        String[] stringArray = new String[]{"GRANT CREATE SQL TRANSLATION PROFILE TO " + string13};
                        this.createRoles(string5, stringArray);
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage() + ":" + exception.getStackTrace()[0]);
                    this.severe(exception);
                }
            }
            if (bl3) {
                this.checkPermission(string);
                object = new OnlineBabelfishInstallTask(dBObject, string, string8, string5, string3);
                object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        final String string = SEMessages.getString("InstallSQLTranslatorMenu.FinishedMessage");
                        final String string2 = SEMessages.getString("InstallSQLTranslatorMenu.Title");
                        final String string3 = null;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)string2, (String)string3);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            runnable.run();
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        if (throwable == null) {
                            Logger.severe(((Object)((Object)this)).getClass(), (String)SEMessages.getString("InstallFailed"));
                            return;
                        }
                        while (throwable.getCause() != null) {
                            if (!((throwable = throwable.getCause()) instanceof ConnectionCanceledException) && !(throwable instanceof CanceledException)) continue;
                            throwable = null;
                            break;
                        }
                        if (throwable != null) {
                            final String string = throwable.getMessage();
                            final String string2 = SEMessages.getString("InstallFailed");
                            final String string3 = null;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)string2, (String)string3);
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)object);
            } else {
                object = new OfflineBabelfishInstallTask(dBObject, string, string3);
                RaptorTaskManager.getInstance().addTask((RaptorTask)object);
            }
        }
    }

    private String getSchemaName(String string) {
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            try {
                return connection.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return null;
    }

    public boolean gotUserPermission(Connection connection, String string) {
        String string2;
        DBUtil dBUtil = null;
        dBUtil = DBUtil.getInstance((Connection)connection);
        return dBUtil != null && (string2 = dBUtil.executeOracleReturnOneCol(string, null)).equals("1");
    }

    private boolean createRoles(String string, String[] stringArray) {
        try {
            boolean bl = false;
            Connection connection = InstallSQLTranslatorMenu.getConnection(string);
            if (connection != null) {
                bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)connection);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            this.warn(sQLException);
            return false;
        }
    }

    private static Connection getConnection(String string) {
        Connection connection = null;
        if (connection == null) {
            connection = RunPrivilegedScript.getConnection((String)string, (String)"sys", (String)"SYSDBA");
        }
        return connection;
    }
}

