/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class IlvContrastingColor
extends Color
implements Composite {
    private final Color a;
    private final Color b;
    private final float c;
    private final float d;
    public static final RenderingHints.Key KNOWN_BACKGROUND_COLOR = KnownBackgroundColorKey.a;

    public IlvContrastingColor(Color color, Color color2, float f2) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.a = color;
        this.b = color2;
        this.c = f2;
        this.d = f2 * 255.0f;
    }

    public IlvContrastingColor() {
        this(Color.black, Color.white, 0.5f);
    }

    public Color getDarkColor() {
        return this.a;
    }

    public Color getBrightColor() {
        return this.b;
    }

    public float getThreshold() {
        return this.c;
    }

    public Color chooseColor(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        float f2 = 0.299f * (float)n2 + 0.587f * (float)n3 + 0.114f * (float)n4;
        return f2 >= this.d ? this.a : this.b;
    }

    public CompositeContext createContext(ColorModel colorModel, final ColorModel colorModel2, RenderingHints renderingHints) {
        return new CompositeContext(){
            private Object a;
            private Object b;
            private int c;
            private int d;
            {
                this.a = colorModel2.getDataElements(IlvContrastingColor.this.a.getRGB(), null);
                this.b = colorModel2.getDataElements(IlvContrastingColor.this.b.getRGB(), null);
                switch (colorModel2.getTransferType()) {
                    case 0: {
                        this.c = ((byte[])this.a)[0] & 0xFF;
                        this.d = ((byte[])this.b)[0] & 0xFF;
                        break;
                    }
                    case 1: {
                        this.c = ((short[])this.a)[0] & 0xFFFF;
                        this.d = ((short[])this.b)[0] & 0xFFFF;
                        break;
                    }
                    case 3: {
                        this.c = ((int[])this.a)[0];
                        this.d = ((int[])this.b)[0];
                    }
                }
            }

            private void a(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n2 = raster.getMinX();
                int n3 = raster.getMinY();
                int n4 = raster2.getMinX();
                int n5 = raster2.getMinY();
                int n6 = writableRaster.getMinX();
                int n7 = writableRaster.getMinY();
                int n8 = Math.min(raster.getWidth(), raster2.getWidth());
                int n9 = Math.min(raster.getHeight(), writableRaster.getHeight());
                Object var12_12 = null;
                Object object = null;
                Object object2 = null;
                for (int i2 = 0; i2 < n9; ++i2) {
                    for (int i3 = 0; i3 < n8; ++i3) {
                        object = raster2.getDataElements(n4 + i3, n5 + i2, object);
                        Color color = new Color(colorModel2.getRGB(object));
                        Color color2 = IlvContrastingColor.this.chooseColor(color);
                        object2 = colorModel2.getDataElements(color2.getRGB(), object2);
                        writableRaster.setDataElements(n6 + i3, n7 + i2, object2);
                    }
                }
            }

            private void b(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n2 = raster.getMinX();
                int n3 = raster.getMinY();
                int n4 = raster2.getMinX();
                int n5 = raster2.getMinY();
                int n6 = writableRaster.getMinX();
                int n7 = writableRaster.getMinY();
                int n8 = Math.min(raster.getWidth(), raster2.getWidth());
                int n9 = Math.min(raster.getHeight(), writableRaster.getHeight());
                Object var12_12 = null;
                Object object = null;
                int n10 = 0xFFFFFF;
                Object object2 = this.a;
                for (int i2 = 0; i2 < n9; ++i2) {
                    for (int i3 = 0; i3 < n8; ++i3) {
                        Object object3;
                        int n11 = colorModel2.getRGB(object = raster2.getDataElements(n4 + i3, n5 + i2, object));
                        if (n11 == n10) {
                            object3 = object2;
                        } else {
                            int n12 = (n11 & 0xFF0000) >> 16;
                            int n13 = (n11 & 0xFF00) >> 8;
                            int n14 = n11 & 0xFF;
                            float f2 = 0.299f * (float)n12 + 0.587f * (float)n13 + 0.114f * (float)n14;
                            object3 = f2 >= IlvContrastingColor.this.d ? this.a : this.b;
                            n10 = n11;
                            object2 = object3;
                        }
                        writableRaster.setDataElements(n6 + i3, n7 + i2, object3);
                    }
                }
            }

            private void c(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n2 = raster.getMinX();
                int n3 = raster.getMinY();
                int n4 = raster2.getMinX();
                int n5 = raster2.getMinY();
                int n6 = writableRaster.getMinX();
                int n7 = writableRaster.getMinY();
                int n8 = Math.min(raster.getWidth(), raster2.getWidth());
                int n9 = Math.min(raster.getHeight(), writableRaster.getHeight());
                int n10 = 0xFFFFFF;
                int n11 = this.c;
                switch (colorModel2.getTransferType()) {
                    case 0: {
                        byte[] byArray = new byte[n8];
                        for (int i2 = 0; i2 < n9; ++i2) {
                            byArray = (byte[])raster2.getDataElements(n4, n5 + i2, n8, 1, byArray);
                            for (int i3 = 0; i3 < n8; ++i3) {
                                int n12;
                                int n13 = byArray[i3] & 0xFF;
                                int n14 = colorModel2.getRGB(n13);
                                if (n14 == n10) {
                                    n12 = n11;
                                } else {
                                    int n15 = (n14 & 0xFF0000) >> 16;
                                    int n16 = (n14 & 0xFF00) >> 8;
                                    int n17 = n14 & 0xFF;
                                    float f2 = 0.299f * (float)n15 + 0.587f * (float)n16 + 0.114f * (float)n17;
                                    n12 = f2 >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n10 = n14;
                                    n11 = n12;
                                }
                                byArray[i3] = (byte)n12;
                            }
                            writableRaster.setDataElements(n6, n7 + i2, n8, 1, byArray);
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = new short[n8];
                        for (int i4 = 0; i4 < n9; ++i4) {
                            sArray = (short[])raster2.getDataElements(n4, n5 + i4, n8, 1, sArray);
                            for (int i5 = 0; i5 < n8; ++i5) {
                                int n18;
                                int n19 = sArray[i5] & 0xFFFF;
                                int n20 = colorModel2.getRGB(n19);
                                if (n20 == n10) {
                                    n18 = n11;
                                } else {
                                    int n21 = (n20 & 0xFF0000) >> 16;
                                    int n22 = (n20 & 0xFF00) >> 8;
                                    int n23 = n20 & 0xFF;
                                    float f3 = 0.299f * (float)n21 + 0.587f * (float)n22 + 0.114f * (float)n23;
                                    n18 = f3 >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n10 = n20;
                                    n11 = n18;
                                }
                                sArray[i5] = (short)n18;
                            }
                            writableRaster.setDataElements(n6, n7 + i4, n8, 1, sArray);
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = new int[n8];
                        for (int i6 = 0; i6 < n9; ++i6) {
                            nArray = (int[])raster2.getDataElements(n4, n5 + i6, n8, 1, nArray);
                            for (int i7 = 0; i7 < n8; ++i7) {
                                int n24;
                                int n25 = nArray[i7];
                                int n26 = colorModel2.getRGB(n25);
                                if (n26 == n10) {
                                    n24 = n11;
                                } else {
                                    int n27 = (n26 & 0xFF0000) >> 16;
                                    int n28 = (n26 & 0xFF00) >> 8;
                                    int n29 = n26 & 0xFF;
                                    float f4 = 0.299f * (float)n27 + 0.587f * (float)n28 + 0.114f * (float)n29;
                                    n24 = f4 >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n10 = n26;
                                    n11 = n24;
                                }
                                nArray[i7] = n24;
                            }
                            writableRaster.setDataElements(n6, n7 + i6, n8, 1, nArray);
                        }
                        break;
                    }
                    default: {
                        this.b(raster, raster2, writableRaster);
                    }
                }
            }

            private void d(Raster raster, Raster raster2, WritableRaster writableRaster) {
                Object object;
                Object[] objectArray;
                int n2 = raster.getMinX();
                int n3 = raster.getMinY();
                int n4 = raster2.getMinX();
                int n5 = raster2.getMinY();
                int n6 = writableRaster.getMinX();
                int n7 = writableRaster.getMinY();
                int n8 = Math.min(raster.getWidth(), raster2.getWidth());
                int n9 = Math.min(raster.getHeight(), writableRaster.getHeight());
                int n10 = colorModel2.getNumComponents();
                switch (colorModel2.getTransferType()) {
                    case 2: {
                        objectArray = new short[n10];
                        object = new short[n8 * n10];
                        break;
                    }
                    case 4: {
                        objectArray = new float[n10];
                        object = new float[n8 * n10];
                        break;
                    }
                    case 5: {
                        objectArray = new double[n10];
                        object = new double[n8 * n10];
                        break;
                    }
                    case 0: {
                        objectArray = new byte[n10];
                        object = new byte[n8 * n10];
                        break;
                    }
                    case 1: {
                        objectArray = new short[n10];
                        object = new short[n8 * n10];
                        break;
                    }
                    case 3: {
                        objectArray = new int[n10];
                        object = new int[n8 * n10];
                        break;
                    }
                    default: {
                        this.b(raster, raster2, writableRaster);
                        return;
                    }
                }
                int n11 = 0xFFFFFF;
                Object object2 = this.a;
                for (int i2 = 0; i2 < n9; ++i2) {
                    object = raster2.getDataElements(n4, n5 + i2, n8, 1, object);
                    int n12 = 0;
                    int n13 = 0;
                    while (n13 < n8) {
                        Object object3;
                        System.arraycopy(object, n12, objectArray, 0, n10);
                        int n14 = colorModel2.getRGB(objectArray);
                        if (n14 == n11) {
                            object3 = object2;
                        } else {
                            int n15 = (n14 & 0xFF0000) >> 16;
                            int n16 = (n14 & 0xFF00) >> 8;
                            int n17 = n14 & 0xFF;
                            float f2 = 0.299f * (float)n15 + 0.587f * (float)n16 + 0.114f * (float)n17;
                            object3 = f2 >= IlvContrastingColor.this.d ? this.a : this.b;
                            n11 = n14;
                            object2 = object3;
                        }
                        System.arraycopy(object3, 0, object, n12, n10);
                        ++n13;
                        n12 += n10;
                    }
                    writableRaster.setDataElements(n6, n7 + i2, n8, 1, object);
                }
            }

            public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
                if (colorModel2 instanceof DirectColorModel || colorModel2 instanceof IndexColorModel) {
                    this.c(raster, raster2, writableRaster);
                } else if (colorModel2 instanceof ComponentColorModel) {
                    this.d(raster, raster2, writableRaster);
                } else {
                    this.b(raster, raster2, writableRaster);
                }
            }

            public void dispose() {
            }
        };
    }

    private static class KnownBackgroundColorKey
    extends RenderingHints.Key {
        static KnownBackgroundColorKey a = new KnownBackgroundColorKey(560442483);

        protected KnownBackgroundColorKey(int n2) {
            super(n2);
        }

        public boolean isCompatibleValue(Object object) {
            return object == null || object instanceof Color;
        }

        public String toString() {
            return "Known background color";
        }
    }
}

