/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupElement;
import ilog.views.prototypes.IlvValueException;
import ilog.views.prototypes.IlvValueSource;
import ilog.views.prototypes.Timer;
import ilog.views.prototypes.TimerManager;
import java.io.IOException;
import java.util.Vector;

public class IlvClockValueSource
extends IlvValueSource
implements Timer {
    long a;
    long b;
    long c;

    public IlvClockValueSource(String string, long l2, long l3) {
        super(string);
        this.setPeriod(l2);
        this.b = l3;
    }

    public IlvClockValueSource(IlvClockValueSource ilvClockValueSource) {
        super(ilvClockValueSource);
        this.a = ilvClockValueSource.a;
        this.b = ilvClockValueSource.b;
    }

    public IlvClockValueSource(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readInt("period");
        this.b = ilvInputStream.readInt("initialTime");
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("period", this.a);
        ilvOutputStream.write("initialTime", this.b);
    }

    public IlvGroupElement copy() {
        return new IlvClockValueSource(this);
    }

    protected void start() {
        this.c = this.b;
        TimerManager.getSingleton().addTimer(this);
    }

    protected void stop() {
        TimerManager.getSingleton().removeTimer(this);
    }

    protected void suspend() {
        TimerManager.getSingleton().removeTimer(this);
    }

    protected void resume() {
        TimerManager.getSingleton().addTimer(this);
    }

    protected void tick(Vector vector, Vector vector2) {
    }

    public void setPeriod(long l2) {
        this.a = l2;
        if (this.a == 0L) {
            this.a = 1000L;
        }
    }

    public long getPeriod() {
        return this.a;
    }

    public void setInitialTime(long l2) {
        this.b = l2;
    }

    public long getInitialTime() {
        return this.b;
    }

    public String[] getValueNames(boolean bl) throws IlvValueException {
        int n2;
        String[] stringArray = super.getValueNames(bl);
        String[] stringArray2 = new String[stringArray.length + 7];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        int n3 = n2++;
        stringArray2[n3] = "time";
        int n4 = n2++;
        stringArray2[n4] = "hours";
        int n5 = n2++;
        stringArray2[n5] = "minutes";
        int n6 = n2++;
        stringArray2[n6] = "seconds";
        int n7 = n2++;
        stringArray2[n7] = "totalMinutes";
        int n8 = n2++;
        stringArray2[n8] = "totalSeconds";
        int n9 = n2++;
        stringArray2[n9] = "milliseconds";
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOutput(String string) {
        if (string.equals("time")) return true;
        if (string.equals("hours")) return true;
        if (string.equals("minutes")) return true;
        if (string.equals("seconds")) return true;
        if (string.equals("totalMinutes")) return true;
        if (string.equals("totalSeconds")) return true;
        if (!string.equals("milliseconds")) return false;
        return true;
    }

    public long getTimerPeriod() {
        return this.getPeriod();
    }

    public void timerTicked() {
        this.c += this.a;
        long l2 = this.c;
        long l3 = l2 / 60000L;
        long l4 = l2 / 1000L;
        long l5 = l2 / 3600000L;
        long l6 = (l2 %= 3600000L) / 60000L;
        long l7 = (l2 %= 60000L) / 1000L;
        l2 %= 1000L;
        Vector<String> vector = new Vector<String>();
        Vector<Long> vector2 = new Vector<Long>();
        vector.addElement("time");
        vector2.addElement(new Long(this.c));
        vector.addElement("hours");
        vector2.addElement(new Long(l5));
        vector.addElement("minutes");
        vector2.addElement(new Long(l6));
        vector.addElement("seconds");
        vector2.addElement(new Long(l7));
        vector.addElement("totalMinutes");
        vector2.addElement(new Long(l3));
        vector.addElement("totalSeconds");
        vector2.addElement(new Long(l3));
        vector.addElement("milliseconds");
        vector2.addElement(new Long(l2));
        this.tick(vector, vector2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new Object[vector2.size()];
        vector2.copyInto(objectArray2);
        try {
            this.pushValues((String[])objectArray, objectArray2);
        }
        catch (Exception exception) {
            IlvGroup.a("exception caught by clock source: " + exception.getMessage());
        }
    }

    public int getSynchronizationCount() {
        return 0;
    }

    public static void setRealTimeMode(boolean bl) {
        TimerManager.getSingleton().setRealTime(bl);
    }

    public static boolean getRealTimeMode() {
        return TimerManager.getSingleton().isRealTime();
    }
}

