/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.print;

import ilog.views.IlvRect;
import ilog.views.print.BoundedNumberField;
import ilog.views.print.FloatNumberField;
import ilog.views.print.IlvManagerPrintableDocument;
import ilog.views.print.IlvMessagesSupport;
import ilog.views.util.IlvImageUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class IlvManagerPageEditor
extends JPanel {
    private IlvManagerPrintableDocument a;
    private BoundedNumberField b;
    private BoundedNumberField c;
    private JRadioButton d;
    private JRadioButton e;
    private Icon f;
    private Icon g;
    private JLabel h;
    private JRadioButton i;
    private JRadioButton j;
    private FloatNumberField k;
    private JCheckBox l;
    private JPanel m;
    private JPanel n;
    private FloatNumberField o;
    private FloatNumberField p;
    private FloatNumberField q;
    private FloatNumberField r;

    public IlvManagerPageEditor(IlvManagerPrintableDocument ilvManagerPrintableDocument) {
        this.a = ilvManagerPrintableDocument;
        this.a();
    }

    private Icon a(String string) {
        try {
            Image image = IlvImageUtil.getImageFromFile(this.getClass(), "resources/" + string);
            return new ImageIcon(image);
        }
        catch (Exception exception) {
            Logger.getLogger("ilog.views.print").log(Level.INFO, "Cannot load " + string, exception);
            return null;
        }
    }

    private String b(String string) {
        return IlvMessagesSupport.getMessage("IlvManagerPageEditor." + string);
    }

    private char c(String string) {
        return IlvMessagesSupport.getMnemonic("IlvManagerPageEditor." + string);
    }

    private void a() {
        this.f = this.a("overdown.gif");
        this.g = this.a("downover.gif");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        jPanel.setBorder(new TitledBorder(this.b("Area")));
        this.o = new FloatNumberField(4);
        this.r = new FloatNumberField(4);
        this.p = new FloatNumberField(4);
        this.q = new FloatNumberField(4);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IlvManagerPageEditor.this.j.setSelected(true);
            }
        };
        this.o.addFocusListener(focusAdapter);
        this.r.addFocusListener(focusAdapter);
        this.p.addFocusListener(focusAdapter);
        this.q.addFocusListener(focusAdapter);
        JLabel jLabel = new JLabel(this.b("Left"));
        jLabel.setDisplayedMnemonic(this.c("Left"));
        jLabel.setLabelFor(this.o);
        JLabel jLabel2 = new JLabel(this.b("Right"));
        jLabel2.setDisplayedMnemonic(this.c("Right"));
        jLabel2.setLabelFor(this.p);
        JLabel jLabel3 = new JLabel(this.b("Top"));
        jLabel3.setDisplayedMnemonic(this.c("Top"));
        jLabel3.setLabelFor(this.r);
        JLabel jLabel4 = new JLabel(this.b("Bottom"));
        jLabel4.setDisplayedMnemonic(this.c("Bottom"));
        jLabel4.setLabelFor(this.q);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.i = new JRadioButton(this.b("All"));
        this.i.setMnemonic(this.c("All"));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IlvManagerPageEditor.this.setPrintAreaImpl(IlvManagerPageEditor.this.a.getTotalManagerPrintableArea());
            }
        };
        this.i.addItemListener(itemListener);
        this.j = new JRadioButton("");
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        jPanel.add(this.i);
        jPanel.add(this.j);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.o, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.r, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.p, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.q, gridBagConstraints);
        jPanel.add(jPanel3);
        this.n = new JPanel(new GridBagLayout());
        this.n.setBorder(new TitledBorder(this.b("Scaling")));
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 5, 5));
        JLabel jLabel5 = new JLabel(this.b("FitTo1"));
        jLabel5.setDisplayedMnemonic(this.c("FitTo1"));
        this.b = new BoundedNumberField(3, 1, 100);
        jLabel5.setLabelFor(this.b);
        JLabel jLabel6 = new JLabel(this.b("FitTo2"));
        this.c = new BoundedNumberField(3, 1, 100);
        JLabel jLabel7 = new JLabel(this.b("FitTo3"));
        jPanel4.add(jLabel5);
        jPanel4.add(this.b);
        jPanel4.add(jLabel6);
        jPanel4.add(this.c);
        jPanel4.add(jLabel7);
        this.m = new JPanel(new FlowLayout(3, 5, 5));
        JLabel jLabel8 = new JLabel(this.b("PrintAt"));
        jLabel8.setDisplayedMnemonic(this.c("PrintAt"));
        this.m.add(jLabel8);
        this.k = new FloatNumberField(4);
        this.m.add(this.k);
        this.m.add(new JLabel(this.b("PercentOfSize")));
        jLabel8.setLabelFor(this.k);
        this.k.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                IlvManagerPageEditor.this.checkZoomLevel();
            }
        });
        this.l = new JCheckBox(this.b("AutomaticZoomLevel"));
        this.l.setMnemonic(this.c("AutomaticZoomLevel"));
        this.l.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IlvManagerPageEditor.this.b();
            }
        });
        gridBagConstraints.gridwidth = 0;
        this.n.add((Component)jPanel4, gridBagConstraints);
        if (this.a.isZoomLevelModificationEnabled()) {
            this.n.add((Component)this.m, gridBagConstraints);
            this.n.add((Component)this.l, gridBagConstraints);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(this.b("PageOrder")));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.e = new JRadioButton(this.b("OverThenDown"));
        this.e.setMnemonic(this.c("OverThenDown"));
        this.d = new JRadioButton(this.b("DownThenOver"));
        this.d.setMnemonic(this.c("DownThenOver"));
        buttonGroup2.add(this.e);
        buttonGroup2.add(this.d);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)this.d, gridBagConstraints);
        jPanel6.add((Component)this.e, gridBagConstraints);
        this.h = new JLabel(this.a.getPageOrder() == 1 ? this.f : this.g);
        jPanel5.add(jPanel6);
        jPanel5.add(this.h);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IlvManagerPageEditor.this.h.setIcon(IlvManagerPageEditor.this.e.isSelected() ? IlvManagerPageEditor.this.f : IlvManagerPageEditor.this.g);
            }
        };
        this.e.addItemListener(itemListener2);
        this.d.addItemListener(itemListener2);
        this.add((Component)jPanel, gridBagConstraints);
        this.add((Component)this.n, gridBagConstraints);
        this.add((Component)jPanel5, gridBagConstraints);
        this.setPrintArea(this.a.getPrintArea(), this.a.isPrintingAllManagerBBox());
        this.setPageOrder(this.a.getPageOrder());
        this.setColumnCount(this.a.b());
        this.setRowCount(this.a.a());
        this.setZoomLevel(this.a.getZoomLevel());
        this.setAutomaticZoomLevel(this.a.isAutomaticZoomLevel());
    }

    private static Window a(Component component) {
        if (component instanceof Window || component == null) {
            return (Window)component;
        }
        return IlvManagerPageEditor.a(component.getParent());
    }

    public void setZoomLevelModificationEnabled(boolean bl) {
        if (bl) {
            if (this.m.getParent() == null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(2, 5, 2, 5);
                gridBagConstraints.gridwidth = 0;
                this.n.add((Component)this.m, gridBagConstraints);
                if (this.l.getParent() == null) {
                    this.n.add((Component)this.l, gridBagConstraints);
                }
                IlvManagerPageEditor.a(this.m).pack();
            }
        } else if (this.m.getParent() != null) {
            this.n.remove(this.m);
            if (this.l.getParent() != null) {
                this.n.remove(this.l);
            }
            IlvManagerPageEditor.a(this.n).pack();
        }
    }

    public void setPrintAreaImpl(IlvRect ilvRect) {
        this.o.setValue(ilvRect.x);
        this.r.setValue(ilvRect.y);
        this.p.setValue(ilvRect.x + ilvRect.width);
        this.q.setValue(ilvRect.y + ilvRect.height);
    }

    public void setPrintArea(IlvRect ilvRect, boolean bl) {
        if (bl) {
            this.i.setSelected(true);
        } else {
            this.j.setSelected(true);
        }
        this.setPrintAreaImpl(ilvRect);
    }

    public void checkZoomLevel() {
        double d2;
        try {
            d2 = (double)this.k.getValue() / 100.0;
            if (d2 <= 0.0) {
                d2 = this.a.getZoomLevel();
            }
            if (d2 > this.a.getMaximumZoomLevel()) {
                d2 = this.a.getMaximumZoomLevel();
            }
            if (d2 < this.a.getMinimumZoomLevel()) {
                d2 = this.a.getMinimumZoomLevel();
            }
        }
        catch (ParseException parseException) {
            d2 = this.a.getZoomLevel();
        }
        this.setZoomLevel(d2);
    }

    public double getZoomLevel() {
        if (this.a.isZoomLevelModificationEnabled()) {
            try {
                float f2 = this.k.getValue() / 100.0f;
                if (f2 <= 0.0f) {
                    return this.a.getZoomLevel();
                }
                return f2;
            }
            catch (ParseException parseException) {
                return this.a.getZoomLevel();
            }
        }
        return this.a.getZoomLevel();
    }

    public void setZoomLevel(double d2) {
        this.k.setValue((float)(d2 * 100.0));
        this.k.setCaretPosition(0);
    }

    public boolean isAutomaticZoomLevel() {
        if (this.a.isZoomLevelModificationEnabled()) {
            return this.l.isSelected();
        }
        return this.a.isAutomaticZoomLevel();
    }

    public void setAutomaticZoomLevel(boolean bl) {
        this.l.setSelected(bl);
        this.b();
    }

    private void b() {
        if (this.isAutomaticZoomLevel()) {
            this.m.setEnabled(false);
            for (int i2 = 0; i2 < this.m.getComponentCount(); ++i2) {
                JComponent jComponent = (JComponent)this.m.getComponent(i2);
                jComponent.setEnabled(false);
            }
        } else {
            this.m.setEnabled(true);
            for (int i3 = 0; i3 < this.m.getComponentCount(); ++i3) {
                JComponent jComponent = (JComponent)this.m.getComponent(i3);
                jComponent.setEnabled(true);
            }
        }
    }

    public void setPageOrder(int n2) {
        this.e.setSelected(n2 == 1);
        this.d.setSelected(n2 == 0);
        this.h.setIcon(this.e.isSelected() ? this.f : this.g);
    }

    public boolean checkPrintArea() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = true;
        if (this.i.isSelected()) {
            return true;
        }
        try {
            f2 = this.o.getValue();
            f3 = this.r.getValue();
            f4 = this.p.getValue() - f2;
            f5 = this.q.getValue() - f3;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        if (bl && f4 < 0.0f || f5 < 0.0f) {
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, this.b("PrintAreaBadlySpecified"), this.b("Error"), 2);
        }
        return bl;
    }

    public IlvRect getPrintArea() {
        if (this.i.isSelected()) {
            return null;
        }
        IlvRect ilvRect = new IlvRect();
        try {
            ilvRect.x = this.o.getValue();
            ilvRect.y = this.r.getValue();
            ilvRect.width = this.p.getValue() - ilvRect.x;
            ilvRect.height = this.q.getValue() - ilvRect.y;
        }
        catch (ParseException parseException) {
            return this.a.getPrintArea();
        }
        if (ilvRect.width < 0.0f || ilvRect.height < 0.0f) {
            return this.a.getPrintArea();
        }
        return ilvRect;
    }

    public int getPageOrder() {
        if (this.d.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setColumnCount(int n2) {
        if (n2 != 0) {
            this.b.setText(Integer.toString(n2));
        } else {
            this.b.setText("");
        }
    }

    public int getColumnCount() {
        int n2;
        try {
            n2 = Integer.parseInt(this.b.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return n2;
    }

    public void setRowCount(int n2) {
        if (n2 != 0) {
            this.c.setText(Integer.toString(n2));
        } else {
            this.c.setText("");
        }
    }

    public int getRowCount() {
        int n2;
        try {
            n2 = Integer.parseInt(this.c.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return n2;
    }

    public void setDocument(IlvManagerPrintableDocument ilvManagerPrintableDocument) {
        this.a = ilvManagerPrintableDocument;
        this.setPageOrder(this.a.getPageOrder());
        this.setColumnCount(this.a.b());
        this.setRowCount(this.a.a());
        this.setPrintArea(this.a.getPrintArea(), this.a.isPrintingAllManagerBBox());
        this.setZoomLevel(this.a.getZoomLevel());
        this.setZoomLevelModificationEnabled(this.a.isZoomLevelModificationEnabled());
    }
}

