/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.io;

import ilog.views.util.internal.IlvStreamTokenizer;
import java.io.IOException;
import java.io.InputStream;

final class Tokenizer
extends IlvStreamTokenizer {
    Tokenizer(InputStream inputStream) {
        super(inputStream);
        this.initSyntax();
    }

    protected void initSyntax() {
        this.resetSyntax();
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.wordChars(35, 47);
        this.wordChars(58, 64);
        this.wordChars(33, 33);
        this.wordChars(91, 91);
        this.wordChars(123, 126);
        this.wordChars(93, 96);
        this.wordChars(92, 92);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.quoteChar(34);
        this.parseNumbers();
    }

    public int nextToken() throws IOException {
        int n2;
        int n3;
        boolean bl = false;
        if (bl) {
            return super.nextToken();
        }
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int n4 = n3 = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && n3 == 10) {
            this.lastCr = false;
            n3 = this.read();
        }
        if (n3 == -1) {
            this.ttype = -1;
            return -1;
        }
        int n5 = n2 = n3 > 255 ? 8 : this.tokenTypes[n3];
        while ((n2 & 4) != 0) {
            if (n3 == 13) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n3 = this.read();
                if (n3 == 10) {
                    n3 = this.read();
                }
            } else if (n3 == 10) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n3 = this.read();
            } else {
                n3 = this.read();
            }
            if (n3 == -1) {
                this.ttype = -1;
                return -1;
            }
            n2 = n3 > 255 ? 8 : this.tokenTypes[n3];
        }
        if ((n2 & 0x10) != 0) {
            boolean bl2;
            StringBuilder stringBuilder = new StringBuilder(20);
            boolean bl3 = false;
            boolean bl4 = bl2 = n3 == 45;
            do {
                if (n3 == 46) {
                    bl3 = true;
                }
                stringBuilder.append((char)n3);
            } while ((n3 = this.read()) >= 48 && n3 <= 57 || !bl3 && n3 == 46 || bl3 && (n3 == 45 || n3 == 43 || n3 == 101 || n3 == 69));
            this.peekChar = n3;
            if (bl2 && stringBuilder.length() == 1) {
                this.ttype = 45;
                return 45;
            }
            String string = stringBuilder.toString();
            char c2 = string.charAt(0);
            if ('0' <= c2 && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+' || c2 == 'e' || c2 == 'E') {
                try {
                    this.nval = Double.parseDouble(string);
                    this.ttype = -2;
                    return -2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.nval = 0.0;
                }
            }
            this.ttype = -3;
            return -3;
        }
        if ((n2 & 8) != 0) {
            StringBuffer stringBuffer = new StringBuffer(20);
            do {
                stringBuffer.append((char)n3);
            } while ((n3 = this.read()) != -1 && (n3 >= 256 || (this.tokenTypes[n3] & 0x18) != 0));
            this.peekChar = n3;
            this.sval = this.forceLowercase ? stringBuffer.toString().toLowerCase() : stringBuffer.toString();
            this.ttype = -3;
            return -3;
        }
        if (n2 == 2) {
            int n6 = n3;
            StringBuffer stringBuffer = new StringBuffer();
            int n7 = this.read();
            while (n7 >= 0 && n7 != n6 && n7 != 13 && n7 != 10) {
                boolean bl5 = true;
                if (n7 == 92) {
                    int n8 = this.getNextChar();
                    if (n8 <= 55 && n8 >= 48) {
                        int n9 = n8 - 48;
                        n8 = this.read();
                        if (n8 > 55 || n8 < 48) {
                            bl5 = false;
                        } else {
                            n9 = n9 * 8 + (n8 - 48);
                            n8 = this.read();
                            if (n9 > 31 || n8 > 55 || n8 < 48) {
                                bl5 = false;
                            } else {
                                n9 = n9 * 8 + (n8 - 48);
                            }
                        }
                        if (!bl5) {
                            stringBuffer.append((char)n9);
                            n7 = n8;
                        } else {
                            n7 = n9;
                        }
                    } else {
                        n7 = this.handleBackslashInString();
                    }
                }
                if (!bl5) continue;
                stringBuffer.append((char)n7);
                n7 = this.getNextChar();
            }
            if (n7 == n6) {
                n7 = this.read();
            }
            this.peekChar = n7;
            this.ttype = n6;
            this.sval = stringBuffer.toString();
            return this.ttype;
        }
        if (n3 == 47 && (this.slashSlashComments || this.slashStarComments)) {
            n3 = this.read();
            if (n3 == 42 && this.slashStarComments) {
                int n10 = this.read();
                while (true) {
                    n3 = n10;
                    n10 = this.read();
                    if (n3 == -1) {
                        this.peekChar = -1;
                        this.ttype = -1;
                        return -1;
                    }
                    if (n3 == 13) {
                        if (n10 == 10) {
                            n10 = this.read();
                        }
                        ++this.lineNumber;
                        continue;
                    }
                    if (n3 == 10) {
                        ++this.lineNumber;
                        continue;
                    }
                    if (n3 == 42 && n10 == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (n3 == 47 && this.slashSlashComments) {
                while ((n3 = this.read()) >= 0 && n3 != 13 && n3 != 10) {
                }
                this.peekChar = n3;
                return this.nextToken();
            }
            if (n2 != 1) {
                this.peekChar = n3;
                this.ttype = 47;
                return 47;
            }
        }
        if (n2 == 1) {
            while ((n3 = this.read()) >= 0 && n3 != 13 && n3 != 10) {
            }
            this.peekChar = n3;
            return this.nextToken();
        }
        this.peekChar = this.read();
        this.ttype = n3;
        return this.ttype;
    }

    protected char handleBackslashInString() {
        try {
            char c2;
            switch (this.nextChar) {
                case 97: {
                    c2 = '\u0007';
                    break;
                }
                case 98: {
                    c2 = '\b';
                    break;
                }
                case 102: {
                    c2 = '\f';
                    break;
                }
                case 110: {
                    c2 = '\n';
                    break;
                }
                case 114: {
                    c2 = '\r';
                    break;
                }
                case 116: {
                    c2 = '\t';
                    break;
                }
                case 118: {
                    c2 = '\u000b';
                    break;
                }
                case 117: {
                    int n2 = 0;
                    int n3 = 0;
                    while ((n3 = this.read()) == 117) {
                    }
                    block18: for (int i2 = 0; i2 < 4; ++i2) {
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n2 = (n2 << 4) + n3 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n2 = (n2 << 4) + 10 + n3 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n2 = (n2 << 4) + 10 + n3 - 65;
                                break;
                            }
                            default: {
                                break block18;
                            }
                        }
                        if (i2 == 3) continue;
                        n3 = this.read();
                    }
                    n3 = n2;
                    c2 = (char)n3;
                    break;
                }
                default: {
                    c2 = (char)this.nextChar;
                }
            }
            return c2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

