/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolyline;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import ilog.views.interactor.IlvPolyPointsObjectFactory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class IlvMakePolyPointsInteractor
extends IlvManagerViewInteractor
implements IlvPermanentInteractorInterface {
    private IlvPoint[] a;
    private int b = 0;
    private Color c = Color.lightGray;
    private Color d = Color.black;
    private Cursor e = Cursor.getPredefinedCursor(1);
    private Cursor f;
    private boolean g;
    private boolean h = false;
    private float i = 5.0f;
    private boolean j = false;
    private boolean k = true;
    private boolean l = false;
    IlvGraphic m;
    private boolean n = true;
    private boolean o = true;
    private boolean p = false;
    Object q;
    private IlvPoint r;

    public IlvMakePolyPointsInteractor() {
        this.enableEvents(48L);
        this.g = true;
        this.setOpaqueMode(false);
    }

    public boolean isGridMode() {
        return this.g;
    }

    public final void setGridMode(boolean bl) {
        this.g = bl;
    }

    public final boolean isPermanent() {
        return this.h;
    }

    public final void setPermanent(boolean bl) {
        this.h = bl;
    }

    public final void setMinPointsDistance(float f2) {
        this.i = Math.abs(f2);
    }

    public final float getMinPointsDistance() {
        return this.i;
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        this.f = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
        ilvManagerView.setCursor(this.getCursor());
        this.reInitialize();
    }

    protected void detach() {
        this.getManagerView().setCursor(this.f);
        this.f = null;
        this.a();
        this.reInitialize();
        super.detach();
    }

    protected void reInitialize() {
        this.a();
        this.b = 0;
        this.m = null;
        this.p = false;
    }

    public Cursor getCursor() {
        return this.e;
    }

    public void setCursor(Cursor cursor) {
        this.e = cursor;
    }

    public boolean allowsMultiplePoints() {
        return this.k;
    }

    public boolean isAllowingMultiplePoints() {
        return this.allowsMultiplePoints();
    }

    public void allowsMultiplePoints(boolean bl) {
        this.k = bl;
    }

    public void setAllowingMultiplePoints(boolean bl) {
        this.allowsMultiplePoints(bl);
    }

    public final int count() {
        return this.b;
    }

    protected IlvPoint[] getPoints(boolean bl) {
        IlvTransformer ilvTransformer = bl ? this.getTransformer() : null;
        int n2 = this.b;
        if (n2 < 1) {
            return null;
        }
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        if (this.isOpaqueMode()) {
            if (this.m == null) {
                return null;
            }
            IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)((Object)this.m);
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvPointArray[i2] = ilvPolyPointsInterface.getPointAt(i2, ilvTransformer);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                ilvPointArray[i3] = new IlvPoint(this.a[i3].x, this.a[i3].y);
                if (ilvTransformer == null) continue;
                ilvTransformer.apply(ilvPointArray[i3]);
            }
        }
        return ilvPointArray;
    }

    protected boolean numberOfPointsReached() {
        return this.b == 2 && !this.isAllowingMultiplePoints();
    }

    private void a(MouseEvent mouseEvent) {
        IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
        IlvTransformer ilvTransformer = this.getTransformer();
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint2);
        }
        if (this.b == 0) {
            this.r = new IlvPoint(ilvPoint2.x, ilvPoint2.y);
        }
        if (!this.accept(ilvPoint2)) {
            return;
        }
        if (this.numberOfPointsReached()) {
            this.doIt();
            return;
        }
        if (this.isGridMode()) {
            this.getManagerView().snapToGrid(ilvPoint);
            ilvPoint2 = ilvPoint;
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint2);
            }
        }
        if (this.isOpaqueMode()) {
            this.a(ilvPoint2, ilvTransformer);
        } else {
            this.b(ilvPoint2, ilvTransformer);
        }
    }

    protected boolean endOnDoubleClick() {
        return this.isAllowingMultiplePoints();
    }

    protected boolean accept(IlvPoint ilvPoint) {
        return true;
    }

    protected void react(IlvPoint ilvPoint) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & 8) == 0 && (mouseEvent.getModifiers() & 4) == 0) {
            this.p = true;
            this.b();
            if (mouseEvent.getClickCount() == 2 && this.endOnDoubleClick()) {
                if (this.b > 1) {
                    --this.b;
                }
                this.doIt();
            } else {
                this.a(mouseEvent);
            }
            this.b();
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) == 0 && (mouseEvent.getModifiers() & 4) == 0) {
            this.b();
            IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
            IlvTransformer ilvTransformer = this.getTransformer();
            boolean bl = this.isOpaqueMode();
            if (this.b != 0) {
                if (this.b == 1) {
                    if (bl) {
                        this.a(new IlvPoint(0.0f, 0.0f), ilvTransformer);
                    } else {
                        this.b = 2;
                    }
                }
                this.ensureVisible(ilvPoint);
                ilvTransformer = this.getTransformer();
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvPoint);
                }
                this.react(ilvPoint);
                if (this.isGridMode()) {
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPoint);
                    }
                    this.getManagerView().snapToGrid(ilvPoint);
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(ilvPoint);
                    }
                }
                if (bl && this.m != null) {
                    IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)((Object)this.m);
                    int n2 = ilvPolyPointsInterface.getPointsCardinal();
                    ((IlvPolyPointsInterface)((Object)this.m)).movePoint(n2 - 1, ilvPoint.x, ilvPoint.y, ilvTransformer);
                } else {
                    this.a[this.b - 1].move(ilvPoint.x, ilvPoint.y);
                }
            } else {
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvPoint);
                }
                this.react(ilvPoint);
            }
            this.b();
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public Color getForeground() {
        return this.d;
    }

    public void setForeground(Color color) {
        this.d = color;
    }

    public Color getBackground() {
        return this.c;
    }

    public void setBackground(Color color) {
        this.c = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaqueMode(boolean bl) {
        try {
            if (this.p && bl != this.l) {
                this.reInitialize();
            }
        }
        finally {
            this.l = bl;
        }
    }

    public boolean isOpaqueMode() {
        return this.l;
    }

    public boolean isXORGhost() {
        return this.isOpaqueMode() ? false : super.isXORGhost();
    }

    public void setSelectionMode(boolean bl) {
        this.o = bl;
    }

    public boolean isSelectionMode() {
        return this.o;
    }

    public final void setObjectFactory(IlvPolyPointsObjectFactory ilvPolyPointsObjectFactory) {
        this.q = ilvPolyPointsObjectFactory;
    }

    public final IlvPolyPointsObjectFactory getObjectFactory() {
        return (IlvPolyPointsObjectFactory)this.q;
    }

    protected IlvGraphic makePolyPoint(IlvPoint[] ilvPointArray) {
        IlvGraphic ilvGraphic;
        IlvGraphic ilvGraphic2 = ilvGraphic = this.getObjectFactory() != null ? this.getObjectFactory().createObject(ilvPointArray) : new IlvPolyline(ilvPointArray);
        if (ilvGraphic != null) {
            ilvGraphic.setBackground(this.getBackground());
            ilvGraphic.setForeground(this.getForeground());
        }
        return ilvGraphic;
    }

    protected void doIt() {
        if (this.b > 1) {
            IlvGraphic ilvGraphic = this.makePolyPoint(this.getPoints(false));
            this.reInitialize();
            if (ilvGraphic != null) {
                this.addPolyPoints(ilvGraphic);
            }
        } else {
            this.reInitialize();
        }
        if (!this.isPermanent()) {
            this.getManagerView().popInteractor();
        }
    }

    protected void drawGhost(Graphics graphics) {
        if (this.isOpaqueMode()) {
            this.a(graphics);
        } else {
            IlvPoint[] ilvPointArray = this.getPoints(true);
            if (ilvPointArray != null && ilvPointArray.length > 0) {
                IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, this.count(), 1.0f, 1, 0, null, null);
            }
        }
    }

    private void a() {
        this.b();
    }

    private void b() {
        IlvManagerView ilvManagerView = this.getManagerView();
        if (ilvManagerView == null) {
            return;
        }
        IlvRect ilvRect = null;
        if (this.isOpaqueMode()) {
            ilvRect = this.m == null ? null : this.m.boundingBox(this.getTransformer());
        } else {
            IlvPoint[] ilvPointArray = this.getPoints(true);
            if (ilvPointArray != null && ilvPointArray.length > 0) {
                ilvRect = IlvGraphicUtil.PolylineBBox(ilvPointArray, ilvPointArray.length, 1.0f, 1, 0, null);
            }
        }
        if (ilvRect != null) {
            ilvManagerView.invalidateRect(ilvRect);
        }
        ilvManagerView.reDrawViews();
    }

    private void a(Graphics graphics) {
        if (this.m == null) {
            return;
        }
        IlvManagerView ilvManagerView = this.getManagerView();
        if (ilvManagerView == null) {
            return;
        }
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        this.m.draw(graphics, ilvTransformer);
    }

    private void a(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.m == null) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(ilvPoint), new IlvPoint(ilvPoint)};
            this.m = this.makePolyPoint(ilvPointArray);
            this.b = 1;
        } else {
            IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)((Object)this.m);
            int n2 = ilvPolyPointsInterface.getPointsCardinal();
            if (n2 > this.b) {
                this.b = n2;
                return;
            }
            if (this.b > 1 && !this.a(ilvPolyPointsInterface.getPointAt(this.b - 2, ilvTransformer), ilvPolyPointsInterface.getPointAt(this.b - 1, ilvTransformer))) {
                return;
            }
            if (!ilvPolyPointsInterface.allowsPointInsertion()) {
                IlvPoint[] ilvPointArray = new IlvPoint[n2 + 1];
                for (int i2 = 0; i2 < n2; ++i2) {
                    ilvPointArray[i2] = ilvPolyPointsInterface.getPointAt(i2, null);
                }
                ilvPointArray[n2] = ilvPoint;
                this.m = this.makePolyPoint(ilvPointArray);
            } else {
                ((IlvPolyPointsInterface)((Object)this.m)).insertPoint(n2, ilvPoint.x, ilvPoint.y, ilvTransformer);
            }
            ++this.b;
        }
    }

    private void b(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.b == 0) {
            this.b = 1;
            this.a = this.a(32);
            this.a[0].move(ilvPoint.x, ilvPoint.y);
        } else {
            if (this.b > 1) {
                IlvPoint ilvPoint2 = new IlvPoint(this.a[this.b - 1].x, this.a[this.b - 1].y);
                IlvPoint ilvPoint3 = new IlvPoint(this.a[this.b - 2].x, this.a[this.b - 2].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint2);
                    ilvTransformer.apply(ilvPoint3);
                }
                if (!this.a(ilvPoint3, ilvPoint2)) {
                    return;
                }
            }
            ++this.b;
            this.a = this.a(this.b);
            this.a[this.b - 1].move(ilvPoint.x, ilvPoint.y);
        }
    }

    private boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        float f2 = ilvPoint.x - ilvPoint2.x;
        float f3 = ilvPoint.y - ilvPoint2.y;
        return Math.sqrt(f2 * f2 + f3 * f3) >= (double)this.getMinPointsDistance();
    }

    public void setCreationInSubManagersAllowed(boolean bl) {
        this.n = bl;
    }

    public boolean isCreationInSubManagersAllowed() {
        return this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPolyPoints(IlvGraphic ilvGraphic) {
        IlvManager ilvManager;
        IlvManager ilvManager2 = ilvManager = this.getManager();
        IlvTransformer ilvTransformer = this.getTransformer();
        if (this.isCreationInSubManagersAllowed()) {
            IlvGraphic ilvGraphic2;
            IlvPoint ilvPoint = new IlvPoint(this.r);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            if ((ilvGraphic2 = ilvManager.getObject(ilvPoint, this.getManagerView(), true)) != null) {
                if (ilvGraphic2 instanceof IlvManager && ilvGraphic2 != ilvManager2) {
                    ilvManager2 = (IlvManager)ilvGraphic2;
                } else if (ilvGraphic2.getGraphicBag() != ilvManager2 && ilvGraphic2.getGraphicBag() instanceof IlvManager) {
                    ilvManager2 = (IlvManager)ilvGraphic2.getGraphicBag();
                }
            }
            if (ilvManager2 != ilvManager) {
                IlvTransformer ilvTransformer2 = ilvManager2.getDrawingTransformer(this.getManagerView());
                IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)((Object)ilvGraphic);
                int n2 = ilvPolyPointsInterface.getPointsCardinal();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ilvPoint = ilvPolyPointsInterface.getPointAt(i2, ilvTransformer);
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse(ilvPoint);
                    }
                    ilvPolyPointsInterface.movePoint(i2, ilvPoint.x, ilvPoint.y, ilvTransformer2);
                }
            }
        }
        try {
            ilvManager2.initReDraws();
            boolean bl = this.isSelectionMode();
            if (ilvManager2 != ilvManager) {
                ilvManager2.setContentsAdjusting(true, true);
                if (bl) {
                    ilvManager.setSelectionAdjusting(true);
                }
            } else if (bl) {
                ilvManager2.setSelectionAdjusting(true);
            }
            if (bl) {
                ilvManager2.deSelectAll(true, true);
            }
            if (this.isGrapherMode() && ilvManager2 instanceof IlvGrapher) {
                ((IlvGrapher)ilvManager2).addNode(ilvGraphic, true);
            } else {
                ilvManager2.addObject(ilvGraphic, true);
            }
            if (bl && ilvManager2.isSelectable(ilvGraphic)) {
                ilvManager2.setSelected(ilvGraphic, true, true);
            }
            if (ilvManager2 != ilvManager) {
                if (bl) {
                    ilvManager.setSelectionAdjusting(false);
                }
                ilvManager2.setContentsAdjusting(false, true);
            } else if (bl) {
                ilvManager2.setSelectionAdjusting(false);
            }
        }
        finally {
            ilvManager2.reDrawViews();
        }
    }

    private IlvPoint[] a(int n2) {
        int n3;
        int n4 = n3 = this.a != null ? this.a.length : 0;
        if (n3 == 0) {
            n3 = n2 + 2;
            this.a = new IlvPoint[n3];
            int n5 = n3;
            while (n5-- > 0) {
                this.a[n5] = new IlvPoint();
            }
            return this.a;
        }
        if (n3 < n2) {
            int n6 = n3;
            while (n3 < n2) {
                n3 *= 2;
            }
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[n3];
            System.arraycopy(ilvPointArray, 0, this.a, 0, n6);
            for (int i2 = n6; i2 < n3; ++i2) {
                this.a[i2] = new IlvPoint(0.0f, 0.0f);
            }
        }
        return this.a;
    }

    public boolean isGrapherMode() {
        return this.j;
    }

    public void setGrapherMode(boolean bl) {
        this.j = bl;
    }
}

